/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.scheduler.impl;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.api.provider.DependentProvider;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.PropertyFileUtils;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;
import org.apache.deltaspike.scheduler.api.Scheduled;
import org.apache.deltaspike.scheduler.impl.CdiAwareJobFactory;
import org.apache.deltaspike.scheduler.impl.DynamicExpressionObserverJob;
import org.apache.deltaspike.scheduler.impl.SchedulerBaseConfig;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public abstract class AbstractQuartzScheduler<T>
implements org.apache.deltaspike.scheduler.spi.Scheduler<T> {
    private static final Logger LOG = Logger.getLogger(AbstractQuartzScheduler.class.getName());
    private static final Scheduled DEFAULT_SCHEDULED_LITERAL = (Scheduled)AnnotationInstanceProvider.of(Scheduled.class);
    private static ThreadLocal<JobListenerContext> currentJobListenerContext = new ThreadLocal();
    protected Scheduler scheduler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.scheduler != null) {
            throw new UnsupportedOperationException("the scheduler is started already");
        }
        StdSchedulerFactory schedulerFactory = null;
        try {
            Properties properties = new Properties();
            properties.put("org.quartz.scheduler.jobFactory.class", CdiAwareJobFactory.class.getName());
            try {
                ResourceBundle config = this.loadCustomQuartzConfig();
                Enumeration<String> keys = config.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    properties.put(key, config.getString(key));
                }
            }
            catch (Exception e1) {
                LOG.info("no custom quartz-config file found. falling back to the default config provided by quartz.");
                try (InputStream inputStream = null;){
                    inputStream = ClassUtils.getClassLoader(null).getResourceAsStream("org/quartz/quartz.properties");
                    properties.load(inputStream);
                }
            }
            if (schedulerFactory == null) {
                schedulerFactory = new StdSchedulerFactory(properties);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "fallback to default scheduler-factory", e);
            schedulerFactory = new StdSchedulerFactory();
        }
        try {
            this.scheduler = schedulerFactory.getScheduler();
            if (SchedulerBaseConfig.LifecycleIntegration.START_SCOPES_PER_JOB.booleanValue()) {
                this.scheduler.getListenerManager().addJobListener((JobListener)new InjectionAwareJobListener());
            }
            if (!this.scheduler.isStarted()) {
                this.scheduler.startDelayed(SchedulerBaseConfig.LifecycleIntegration.DELAYED_START_IN_SECONDS.intValue());
            }
        }
        catch (SchedulerException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    protected ResourceBundle loadCustomQuartzConfig() {
        String configFile = SchedulerBaseConfig.SCHEDULER_CONFIG_FILE;
        return PropertyFileUtils.getResourceBundle((String)configFile);
    }

    public void stop() {
        try {
            if (this.scheduler != null && this.scheduler.isStarted()) {
                this.scheduler.shutdown(SchedulerBaseConfig.LifecycleIntegration.FORCE_STOP == false);
                this.scheduler = null;
            }
        }
        catch (SchedulerException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    public void registerNewJob(Class<? extends T> jobClass) {
        JobKey jobKey = this.createJobKey(jobClass);
        try {
            JobDetail jobDetail;
            Scheduled scheduled = jobClass.getAnnotation(Scheduled.class);
            String description = scheduled.description();
            if ("".equals(scheduled.description())) {
                description = jobClass.getName();
            }
            if ((jobDetail = this.scheduler.getJobDetail(jobKey)) == null) {
                Class<Job> jobClassToAdd = this.createFinalJobClass(jobClass);
                jobDetail = JobBuilder.newJob(jobClassToAdd).withDescription(description).withIdentity(jobKey).build();
                this.scheduleNewJob(scheduled, jobKey, jobDetail);
            } else if (scheduled.overrideOnStartup()) {
                List existingTriggers = this.scheduler.getTriggersOfJob(jobKey);
                if (existingTriggers == null || existingTriggers.isEmpty()) {
                    this.scheduleNewJob(scheduled, jobKey, jobDetail);
                    return;
                }
                if (existingTriggers.size() > 1) {
                    throw new IllegalStateException("multiple triggers found for " + jobKey + " ('" + jobDetail + "'), but aren't supported by @" + Scheduled.class.getName() + "#overrideOnStartup");
                }
                Trigger trigger = (Trigger)existingTriggers.iterator().next();
                if (scheduled.cronExpression().startsWith("{") && scheduled.cronExpression().endsWith("}")) {
                    this.scheduler.unscheduleJobs(Arrays.asList(trigger.getKey()));
                    this.scheduleNewJob(scheduled, jobKey, jobDetail);
                } else {
                    trigger = TriggerBuilder.newTrigger().withIdentity(trigger.getKey()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)scheduled.cronExpression())).build();
                    this.scheduler.rescheduleJob(trigger.getKey(), trigger);
                }
            } else {
                Logger.getLogger(AbstractQuartzScheduler.class.getName()).info(jobKey + " exists already and will be ignored.");
            }
        }
        catch (SchedulerException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    private void scheduleNewJob(Scheduled scheduled, JobKey jobKey, JobDetail jobDetail) throws SchedulerException {
        String cronExpression = this.evaluateExpression(scheduled);
        this.scheduler.scheduleJob(jobDetail, this.createTrigger(scheduled, jobKey, cronExpression));
    }

    private Trigger createTrigger(Scheduled scheduled, JobKey jobKey, String cronExpression) throws SchedulerException {
        UUID triggerKey = UUID.randomUUID();
        if (!scheduled.cronExpression().endsWith(cronExpression)) {
            this.createExpressionObserverJob(jobKey, triggerKey, scheduled.cronExpression(), cronExpression);
        }
        Trigger trigger = TriggerBuilder.newTrigger().forJob(jobKey).withIdentity(triggerKey.toString()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        return trigger;
    }

    private void createExpressionObserverJob(JobKey jobKey, UUID triggerKey, String configExpression, String cronExpression) throws SchedulerException {
        if (!ClassDeactivationUtils.isActivated(DynamicExpressionObserverJob.class)) {
            return;
        }
        JobKey observerJobKey = new JobKey(jobKey.getName() + "_observer", jobKey.getGroup());
        JobDetail jobDetail = JobBuilder.newJob(DynamicExpressionObserverJob.class).usingJobData("ds_configExpression", configExpression).usingJobData("ds_triggerKey", triggerKey.toString()).usingJobData("ds_activeCronExpression", cronExpression).withDescription("Config observer for: " + jobKey).withIdentity(observerJobKey).build();
        Trigger trigger = TriggerBuilder.newTrigger().forJob(observerJobKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)SchedulerBaseConfig.JobCustomization.DYNAMIC_EXPRESSION_OBSERVER_INTERVAL)).build();
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    private String evaluateExpression(Scheduled scheduled) {
        String configKey;
        String expression = scheduled.cronExpression();
        if (expression.startsWith("{") && expression.endsWith("}") && (expression = ConfigResolver.getProjectStageAwarePropertyValue((String)(configKey = expression.substring(1, expression.length() - 1)), null)) == null) {
            throw new IllegalStateException("No config-value found for config-key: " + configKey);
        }
        return expression;
    }

    protected abstract Class<? extends Job> createFinalJobClass(Class<? extends T> var1);

    public void startJobManually(Class<? extends T> jobClass) {
        try {
            this.scheduler.triggerJob(this.createJobKey(jobClass));
        }
        catch (SchedulerException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    public void interruptJob(Class<? extends T> jobClass) {
        try {
            this.scheduler.interrupt(this.createJobKey(jobClass));
        }
        catch (SchedulerException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    public boolean deleteJob(Class<? extends T> jobClass) {
        try {
            return this.scheduler.deleteJob(this.createJobKey(jobClass));
        }
        catch (SchedulerException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    public void pauseJob(Class<? extends T> jobClass) {
        try {
            this.scheduler.pauseJob(this.createJobKey(jobClass));
        }
        catch (SchedulerException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    public void resumeJob(Class<? extends T> jobClass) {
        try {
            this.scheduler.resumeJob(this.createJobKey(jobClass));
        }
        catch (SchedulerException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    public boolean isExecutingJob(Class<? extends T> jobClass) {
        try {
            JobKey jobKey = this.createJobKey(jobClass);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (jobDetail == null) {
                return false;
            }
            for (JobExecutionContext jobExecutionContext : this.scheduler.getCurrentlyExecutingJobs()) {
                if (!jobKey.equals((Object)jobExecutionContext.getJobDetail().getKey())) continue;
                return true;
            }
            return false;
        }
        catch (SchedulerException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    private JobKey createJobKey(Class<?> jobClass) {
        Scheduled scheduled = jobClass.getAnnotation(Scheduled.class);
        if (scheduled == null) {
            throw new IllegalStateException("@" + Scheduled.class.getName() + " is missing on " + jobClass.getName());
        }
        String groupName = scheduled.group().getSimpleName();
        String jobName = this.getJobName(jobClass);
        if (!Scheduled.class.getSimpleName().equals(groupName)) {
            return new JobKey(jobName, groupName);
        }
        return new JobKey(jobName);
    }

    protected String getJobName(Class<?> jobClass) {
        return jobClass.getSimpleName();
    }

    public <S> S unwrap(Class<? extends S> schedulerClass) {
        if (schedulerClass.isAssignableFrom(this.scheduler.getClass())) {
            return (S)this.scheduler;
        }
        throw new IllegalArgumentException(schedulerClass.getName() + " isn't compatible with " + this.scheduler.getClass().getName());
    }

    private static class JobListenerContext {
        private Stack<Class<? extends Annotation>> scopes = new Stack();
        private DependentProvider<ContextControl> contextControl;

        private JobListenerContext() {
        }

        public void startContexts(Scheduled scheduled) {
            Collections.addAll(this.scopes, scheduled.startScopes());
            if (!this.scopes.isEmpty()) {
                this.contextControl = BeanProvider.getDependent(ContextControl.class, (Annotation[])new Annotation[0]);
                for (Class clazz : this.scopes) {
                    ((ContextControl)this.contextControl.get()).startContext(clazz);
                }
            }
        }

        private void stopStartedScopes() {
            if (this.contextControl == null) {
                return;
            }
            while (!this.scopes.empty()) {
                ((ContextControl)this.contextControl.get()).stopContext(this.scopes.pop());
            }
            this.contextControl.destroy();
        }
    }

    private class InjectionAwareJobListener
    implements JobListener {
        private InjectionAwareJobListener() {
        }

        public String getName() {
            return this.getClass().getName();
        }

        public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
            boolean jobInstanceIsBean;
            Class jobClass = ProxyUtils.getUnproxiedClass(jobExecutionContext.getJobInstance().getClass());
            Scheduled scheduled = jobClass.getAnnotation(Scheduled.class);
            if (scheduled == null && !jobClass.equals(DynamicExpressionObserverJob.class)) {
                scheduled = DEFAULT_SCHEDULED_LITERAL;
            }
            if (scheduled == null) {
                return;
            }
            JobListenerContext jobListenerContext = new JobListenerContext();
            currentJobListenerContext.set(jobListenerContext);
            jobListenerContext.startContexts(scheduled);
            try {
                jobInstanceIsBean = Boolean.TRUE.equals(jobExecutionContext.getScheduler().getContext().get((Object)jobClass.getName()));
            }
            catch (SchedulerException e) {
                jobInstanceIsBean = false;
            }
            if (!jobInstanceIsBean) {
                BeanProvider.injectFields((Object)jobExecutionContext.getJobInstance());
            }
        }

        public void jobExecutionVetoed(JobExecutionContext context) {
            this.stopStartedScopes();
        }

        public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
            this.stopStartedScopes();
        }

        private void stopStartedScopes() {
            JobListenerContext jobListenerContext = (JobListenerContext)currentJobListenerContext.get();
            if (jobListenerContext != null) {
                jobListenerContext.stopStartedScopes();
                currentJobListenerContext.set(null);
                currentJobListenerContext.remove();
            }
        }
    }
}

