/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.security.Principal;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.AccessMgr;
import org.apache.directory.fortress.core.DelAccessMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.realm.J2eePolicyMgr;
import org.apache.directory.fortress.web.AuditAuthzPage;
import org.apache.directory.fortress.web.AuditBindPage;
import org.apache.directory.fortress.web.AuditModPage;
import org.apache.directory.fortress.web.FortressWebBasePage;
import org.apache.directory.fortress.web.GroupPage;
import org.apache.directory.fortress.web.ObjectAdminPage;
import org.apache.directory.fortress.web.ObjectPage;
import org.apache.directory.fortress.web.OuPermPage;
import org.apache.directory.fortress.web.OuUserPage;
import org.apache.directory.fortress.web.PermAdminPage;
import org.apache.directory.fortress.web.PermPage;
import org.apache.directory.fortress.web.PwPolicyPage;
import org.apache.directory.fortress.web.RoleAdminPage;
import org.apache.directory.fortress.web.RolePage;
import org.apache.directory.fortress.web.SdDynamicPage;
import org.apache.directory.fortress.web.SdStaticPage;
import org.apache.directory.fortress.web.UserPage;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.control.SecureBookmarkablePageLink;
import org.apache.directory.fortress.web.control.WicketSession;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FortressWebBasePage
extends WebPage {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private AccessMgr accessMgr;
    @SpringBean
    private DelAccessMgr delAccessMgr;
    @SpringBean
    private J2eePolicyMgr j2eePolicyMgr;
    private static final String CLS_NM = FortressWebBasePage.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FortressWebBasePage() {
        boolean isSecured;
        StringBuilder titlebuf = new StringBuilder();
        titlebuf.append("Fortress Web Administration");
        String szContextId = Config.getInstance().getProperty("contextId");
        if (StringUtils.isNotEmpty((CharSequence)szContextId) && !szContextId.equalsIgnoreCase("HOME")) {
            titlebuf.append(" : ");
            titlebuf.append(szContextId);
        }
        this.add(new Component[]{new Label("titleBar", (Serializable)((Object)titlebuf.toString()))});
        SecureBookmarkablePageLink usersLink = new SecureBookmarkablePageLink("users", UserPage.class, "ROLE_USERS");
        this.add(new Component[]{usersLink});
        PageParameters parameters = new PageParameters();
        SecureBookmarkablePageLink rolesLink = new SecureBookmarkablePageLink("roles", RolePage.class, parameters, "ROLE_ROLES");
        this.add(new Component[]{rolesLink});
        parameters = new PageParameters();
        SecureBookmarkablePageLink admrolesLink = new SecureBookmarkablePageLink("admroles", RoleAdminPage.class, parameters, "ROLE_ADMINROLES");
        this.add(new Component[]{admrolesLink});
        parameters = new PageParameters();
        SecureBookmarkablePageLink objectsLink = new SecureBookmarkablePageLink("pobjs", ObjectPage.class, parameters, "ROLE_PERMOBJS");
        this.add(new Component[]{objectsLink});
        parameters = new PageParameters();
        SecureBookmarkablePageLink admobjsLink = new SecureBookmarkablePageLink("admpobjs", ObjectAdminPage.class, parameters, "ROLE_ADMINOBJS");
        this.add(new Component[]{admobjsLink});
        parameters = new PageParameters();
        SecureBookmarkablePageLink permsLink = new SecureBookmarkablePageLink("perms", PermPage.class, parameters, "ROLE_PERMS");
        this.add(new Component[]{permsLink});
        parameters = new PageParameters();
        SecureBookmarkablePageLink admpermsLink = new SecureBookmarkablePageLink("admperms", PermAdminPage.class, parameters, "ROLE_ADMINPERMS");
        this.add(new Component[]{admpermsLink});
        SecureBookmarkablePageLink policiesLink = new SecureBookmarkablePageLink("pwpolicies", PwPolicyPage.class, "ROLE_POLICIES");
        this.add(new Component[]{policiesLink});
        parameters = new PageParameters();
        SecureBookmarkablePageLink ssdsLink = new SecureBookmarkablePageLink("ssds", SdStaticPage.class, parameters, "ROLE_SSDS");
        this.add(new Component[]{ssdsLink});
        parameters = new PageParameters();
        SecureBookmarkablePageLink dsdsLink = new SecureBookmarkablePageLink("dsds", SdDynamicPage.class, parameters, "ROLE_DSDS");
        this.add(new Component[]{dsdsLink});
        parameters = new PageParameters();
        SecureBookmarkablePageLink userouLink = new SecureBookmarkablePageLink("userous", OuUserPage.class, parameters, "ROLE_USEROUS");
        this.add(new Component[]{userouLink});
        parameters = new PageParameters();
        SecureBookmarkablePageLink permouLink = new SecureBookmarkablePageLink("permous", OuPermPage.class, parameters, "ROLE_PERMOUS");
        this.add(new Component[]{permouLink});
        this.add(new Component[]{new SecureBookmarkablePageLink("groups", GroupPage.class, "ROLE_GROUPS")});
        if (Config.getInstance().isOpenldap()) {
            this.add(new Component[]{new SecureBookmarkablePageLink("binds", AuditBindPage.class, "ROLE_AUDIT_BINDS")});
            this.add(new Component[]{new SecureBookmarkablePageLink("authzs", AuditAuthzPage.class, "ROLE_AUDIT_AUTHZS")});
            this.add(new Component[]{new SecureBookmarkablePageLink("mods", AuditModPage.class, "ROLE_AUDIT_MODS")});
        } else {
            this.add(new Component[]{new Label("binds", (Serializable)((Object)"")).setVisible(false)});
            this.add(new Component[]{new Label("authzs", (Serializable)((Object)"")).setVisible(false)});
            this.add(new Component[]{new Label("mods", (Serializable)((Object)"")).setVisible(false)});
        }
        this.add(new Component[]{new Label("footer", (Serializable)((Object)"Copyright (c) 2003-2025, The Apache Software Foundation. All Rights Reserved.;"))});
        1 actionLink = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{actionLink});
        HttpServletRequest servletReq = (HttpServletRequest)this.getRequest().getContainerRequest();
        Principal principal = servletReq.getUserPrincipal();
        boolean bl = isSecured = principal != null;
        if (isSecured && !this.isLoggedIn()) {
            String szPrincipal = principal.toString();
            Session session = null;
            try {
                session = this.j2eePolicyMgr.deserialize(szPrincipal);
            }
            catch (SecurityException se) {
                throw new RuntimeException(se);
            }
            if (session == null) {
                session = SecUtils.createSession((AccessMgr)this.accessMgr, (String)principal.getName());
            }
            WicketSession wicketSession = (WicketSession)WicketSession.get();
            synchronized (wicketSession) {
                SecUtils.loadPermissionsIntoSession((DelAccessMgr)this.delAccessMgr, (Session)session);
            }
        }
    }

    private boolean isLoggedIn() {
        boolean isLoggedIn = false;
        if (SecUtils.getSession((Component)this) != null) {
            isLoggedIn = true;
        }
        return isLoggedIn;
    }
}

