/**
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.kerby.kerberos.kerb;

import java.util.HashMap;
import java.util.Map;

public class Message {
    private static Map<MessageCode, String> entries = new HashMap<>();

    public static void init() {

    }

    public static void define(MessageCode code, String message) {
        entries.put(code, message);
    }

    public static String getMessage(MessageCode code) {
        String msg = entries.get(code);
        if (msg == null) {
            msg = code.getCodeName();
        }
        return msg;
    }
}
