/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.ldif;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.UUID;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileLdifPartition
extends AbstractLdifPartition {
    private RandomAccessFile ldifFile;
    private volatile boolean enableRewriting = true;
    private boolean dirty = false;
    private Object lock = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(SingleFileLdifPartition.class);

    public SingleFileLdifPartition(SchemaManager schemaManager, DnFactory dnFactory) {
        super(schemaManager, dnFactory);
    }

    protected void doInit() throws LdapException {
        if (!this.initialized) {
            if (this.getPartitionPath() == null) {
                throw new IllegalArgumentException("Partition path cannot be null");
            }
            File partitionFile = new File(this.getPartitionPath());
            if (partitionFile.exists() && !partitionFile.isFile()) {
                throw new IllegalArgumentException("Partition path must be a LDIF file");
            }
            try {
                this.ldifFile = new RandomAccessFile(partitionFile, "rws");
            }
            catch (FileNotFoundException fnfe) {
                throw new LdapOtherException(fnfe.getMessage(), (Throwable)fnfe);
            }
            LOG.debug("id is : {}", (Object)this.getId());
            if (this.suffixDn == null || this.suffixDn.isEmpty()) {
                String msg = I18n.err((I18n)I18n.ERR_150, (Object[])new Object[0]);
                LOG.error(msg);
                throw new LdapInvalidDnException(msg);
            }
            if (!this.suffixDn.isSchemaAware()) {
                this.suffixDn = new Dn(this.schemaManager, this.suffixDn);
            }
            super.doInit();
            this.loadEntries();
        }
    }

    private void loadEntries() throws LdapException {
        try (RandomAccessLdifReader parser = new RandomAccessLdifReader(this.schemaManager);){
            Iterator itr = parser.iterator();
            if (!itr.hasNext()) {
                return;
            }
            LdifEntry ldifEntry = (LdifEntry)itr.next();
            this.contextEntry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
            if (this.suffixDn.equals((Object)this.contextEntry.getDn())) {
                this.addMandatoryOpAt(this.contextEntry);
                AddOperationContext addContext = new AddOperationContext(null, this.contextEntry);
                addContext.setPartition((Partition)this);
                addContext.setTransaction((PartitionTxn)this.beginWriteTransaction());
                super.add(addContext);
            } else {
                throw new LdapException("The given LDIF file doesn't contain the context entry");
            }
            while (itr.hasNext()) {
                ldifEntry = (LdifEntry)itr.next();
                DefaultEntry entry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
                this.addMandatoryOpAt((Entry)entry);
                AddOperationContext addContext = new AddOperationContext(null, (Entry)entry);
                addContext.setPartition((Partition)this);
                addContext.setTransaction((PartitionTxn)this.beginWriteTransaction());
                super.add(addContext);
            }
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AddOperationContext addContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            super.add(addContext);
            if (this.contextEntry == null && (entry = addContext.getEntry()).getDn().equals((Object)this.suffixDn)) {
                this.contextEntry = entry;
            }
            this.dirty = true;
            this.rewritePartitionData(addContext.getTransaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        PartitionTxn partitionTxn = modifyContext.getTransaction();
        Object object = this.lock;
        synchronized (object) {
            try {
                Entry modifiedEntry = super.modify(partitionTxn, modifyContext.getDn(), modifyContext.getModItems().toArray(new Modification[0]));
                modifiedEntry.removeAttributes(new AttributeType[]{this.entryDnAT});
                modifyContext.setAlteredEntry(modifiedEntry);
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), (Throwable)e);
            }
            this.dirty = true;
            this.rewritePartitionData(partitionTxn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.rename(renameContext);
            this.dirty = true;
            this.rewritePartitionData(renameContext.getTransaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(MoveOperationContext moveContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.move(moveContext);
            this.dirty = true;
            this.rewritePartitionData(moveContext.getTransaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.moveAndRename(opContext);
            this.dirty = true;
            this.rewritePartitionData(opContext.getTransaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry delete(PartitionTxn partitionTxn, String id) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            Entry deletedEntry = super.delete(partitionTxn, id);
            this.dirty = true;
            this.rewritePartitionData(partitionTxn);
            return deletedEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewritePartitionData(PartitionTxn partitionTxn) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.enableRewriting || !this.dirty) {
                return;
            }
            try {
                this.ldifFile.setLength(0L);
                String suffixId = this.getEntryId(partitionTxn, this.suffixDn);
                if (suffixId == null) {
                    this.contextEntry = null;
                    return;
                }
                ParentIdAndRdn suffixEntry = (ParentIdAndRdn)this.rdnIdx.reverseLookup(partitionTxn, (Object)suffixId);
                if (suffixEntry != null) {
                    Entry entry = (Entry)this.master.get(partitionTxn, (Object)suffixId);
                    entry.removeAttributes(new AttributeType[]{this.entryDnAT});
                    entry.setDn(this.suffixDn);
                    this.appendLdif(entry);
                    this.appendRecursive(partitionTxn, suffixId, suffixEntry.getNbChildren());
                }
                this.dirty = false;
            }
            catch (LdapException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LdapException((Throwable)e);
            }
        }
    }

    private void appendRecursive(PartitionTxn partitionTxn, String id, int nbSibbling) throws Exception {
        Cursor cursor = this.rdnIdx.forwardCursor(partitionTxn);
        IndexEntry startingPos = new IndexEntry();
        startingPos.setKey((Object)new ParentIdAndRdn(id, (Rdn[])null));
        cursor.before((Object)startingPos);
        for (int countChildren = 0; cursor.next() && countChildren < nbSibbling; ++countChildren) {
            IndexEntry element = (IndexEntry)cursor.get();
            String childId = (String)element.getId();
            Entry entry = this.fetch(partitionTxn, childId);
            entry.removeAttributes(new String[]{"entryDN"});
            this.appendLdif(entry);
            int nbChildren = ((ParentIdAndRdn)element.getKey()).getNbChildren();
            if (nbChildren <= 0) continue;
            this.appendRecursive(partitionTxn, childId, nbChildren);
        }
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLdif(Entry entry) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String ldif = LdifUtils.convertToLdif((Entry)entry);
            this.ldifFile.write(Strings.getBytesUtf8((String)(ldif + "\n")));
        }
    }

    private void addMandatoryOpAt(Entry entry) throws LdapException {
        if (entry.get("entryCSN") == null) {
            entry.add("entryCSN", new String[]{defaultCSNFactory.newInstance().toString()});
        }
        if (entry.get("entryUUID") == null) {
            String uuid = UUID.randomUUID().toString();
            entry.add("entryUUID", new String[]{uuid});
        }
    }

    protected void doDestroy(PartitionTxn partitionTxn) throws LdapException {
        super.doDestroy(partitionTxn);
        try {
            this.ldifFile.close();
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void setEnableRewriting(PartitionTxn partitionTxn, boolean enableRewriting) throws LdapException {
        this.enableRewriting = enableRewriting;
        this.rewritePartitionData(partitionTxn);
    }

    private class RandomAccessLdifReader
    extends LdifReader {
        private long len;

        RandomAccessLdifReader() throws LdapException {
            try {
                this.len = SingleFileLdifPartition.this.ldifFile.length();
            }
            catch (IOException e) {
                LdapException le = new LdapException(e.getMessage(), (Throwable)e);
                le.initCause((Throwable)e);
                throw le;
            }
        }

        RandomAccessLdifReader(SchemaManager schemaManager) throws LdapException {
            try {
                this.schemaManager = schemaManager;
                this.len = SingleFileLdifPartition.this.ldifFile.length();
            }
            catch (IOException e) {
                LdapException le = new LdapException(e.getMessage(), (Throwable)e);
                le.initCause((Throwable)e);
                throw le;
            }
        }

        protected String getLine() throws IOException {
            if (this.len == 0L) {
                return null;
            }
            return SingleFileLdifPartition.this.ldifFile.readLine();
        }
    }
}

