/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.dialogs.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroup;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetUniversalListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.OpenDefaultEditorAction;
import org.apache.directory.studio.ldapbrowser.core.events.AttributeDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EmptyValueAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EmptyValueDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.ValueAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueModifiedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueMultiModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class MultivaluedDialog
extends Dialog {
    private static final String DIALOG_TITLE = Messages.getString("MultivaluedDialog.MultivaluedEditor");
    private AttributeHierarchy workingAttributeHierarchy;
    private AttributeHierarchy referenceAttributeHierarchy;
    private MultiValuedEntryEditorConfiguration configuration;
    private EntryEditorWidgetActionGroup actionGroup;
    private EntryEditorWidget mainWidget;
    private MultiValuedEntryEditorUniversalListener universalListener;
    private IContextActivation contextActivation;

    public MultivaluedDialog(Shell parentShell, AttributeHierarchy attributeHierarchy) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.referenceAttributeHierarchy = attributeHierarchy;
        IEntry entry = attributeHierarchy.getEntry();
        String attributeDescription = attributeHierarchy.getAttributeDescription();
        IEntry clone = new CompoundModification().cloneEntry(entry);
        this.workingAttributeHierarchy = clone.getAttributeWithSubtypes(attributeDescription);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/multivaluededitor.gif"));
    }

    protected void okPressed() {
        LdifFile diff = Utils.computeDiff((IEntry)this.referenceAttributeHierarchy.getEntry(), (IEntry)this.workingAttributeHierarchy.getEntry());
        if (diff != null) {
            IAttribute attribute;
            EventRegistry.suspendEventFiringInCurrentThread();
            IEntry entry = this.referenceAttributeHierarchy.getEntry();
            IAttribute[] iAttributeArray = this.referenceAttributeHierarchy.getAttributes();
            int n = iAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                attribute = iAttributeArray[n2];
                entry.deleteAttribute(attribute);
                ++n2;
            }
            iAttributeArray = this.workingAttributeHierarchy.getAttributes();
            n = iAttributeArray.length;
            n2 = 0;
            while (n2 < n) {
                attribute = iAttributeArray[n2];
                entry.addAttribute(attribute);
                ++n2;
            }
            EventRegistry.resumeEventFiringInCurrentThread();
            ValueMultiModificationEvent event = new ValueMultiModificationEvent(entry.getBrowserConnection(), entry);
            EventRegistry.fireEntryUpdated((EntryModificationEvent)event, (Object)((Object)this));
        }
        super.okPressed();
    }

    public int open() {
        if (this.workingAttributeHierarchy.getAttribute().getValueSize() == 0) {
            this.workingAttributeHierarchy.getAttribute().addEmptyValue();
        }
        return super.open();
    }

    public boolean close() {
        boolean returnValue = super.close();
        if (returnValue) {
            this.dispose();
            for (IAttribute attribute : this.workingAttributeHierarchy) {
                if (attribute == null) continue;
                IValue[] values = attribute.getValues();
                int i = 0;
                while (i < values.length) {
                    if (values[i].isEmpty()) {
                        attribute.deleteEmptyValue();
                    }
                    ++i;
                }
                if (attribute.getValueSize() != 0) continue;
                attribute.getEntry().deleteAttribute(attribute);
            }
        }
        return returnValue;
    }

    public void dispose() {
        if (this.configuration != null) {
            this.universalListener.dispose();
            this.universalListener = null;
            this.mainWidget.dispose();
            this.mainWidget = null;
            this.actionGroup.deactivateGlobalActionHandlers();
            this.actionGroup.dispose();
            this.actionGroup = null;
            this.configuration.dispose();
            this.configuration = null;
            if (this.contextActivation != null) {
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                contextService.deactivateContext(this.contextActivation);
                this.contextActivation = null;
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.configuration = new MultiValuedEntryEditorConfiguration();
        this.mainWidget = new EntryEditorWidget(this.configuration);
        this.mainWidget.createWidget(composite);
        this.mainWidget.getViewer().getTree().setFocus();
        this.actionGroup = new EntryEditorWidgetActionGroup(this.mainWidget, this.configuration);
        this.actionGroup.fillToolBar(this.mainWidget.getToolBarManager());
        this.actionGroup.fillMenu(this.mainWidget.getMenuManager());
        this.actionGroup.fillContextMenu(this.mainWidget.getContextMenuManager());
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
        this.contextActivation = contextService.activateContext(BrowserCommonConstants.CONTEXT_DIALOGS);
        this.actionGroup.activateGlobalActionHandlers();
        this.universalListener = new MultiValuedEntryEditorUniversalListener(this.mainWidget.getViewer(), this.configuration, this.actionGroup, this.actionGroup.getOpenDefaultEditorAction());
        this.universalListener.setInput(this.workingAttributeHierarchy);
        block0: for (IAttribute attribute : this.workingAttributeHierarchy) {
            IValue[] values = attribute.getValues();
            int i = 0;
            while (i < values.length) {
                IValue value = values[i];
                if (value.isEmpty()) {
                    this.mainWidget.getViewer().setSelection((ISelection)new StructuredSelection((Object)value), true);
                    if (this.actionGroup.getOpenDefaultEditorAction().isEnabled()) {
                        this.actionGroup.getOpenDefaultEditorAction().run();
                        continue block0;
                    }
                }
                ++i;
            }
        }
        MultivaluedDialog.applyDialogFont((Control)composite);
        return composite;
    }

    class MultiValuedEntryEditorConfiguration
    extends EntryEditorWidgetConfiguration {
        MultiValuedEntryEditorConfiguration() {
        }

        @Override
        public ValueEditorManager getValueEditorManager(TreeViewer viewer) {
            if (this.valueEditorManager == null) {
                this.valueEditorManager = new ValueEditorManager((Composite)viewer.getTree(), false, false);
            }
            return this.valueEditorManager;
        }
    }

    class MultiValuedEntryEditorUniversalListener
    extends EntryEditorWidgetUniversalListener {
        public MultiValuedEntryEditorUniversalListener(TreeViewer treeViewer, EntryEditorWidgetConfiguration configuration, EntryEditorWidgetActionGroup actionGroup, OpenDefaultEditorAction startEditAction) {
            super(treeViewer, configuration, actionGroup, startEditAction);
        }

        @Override
        public void entryUpdated(EntryModificationEvent event) {
            if (this.viewer == null || this.viewer.getTree() == null || this.viewer.getTree().isDisposed()) {
                return;
            }
            if (this.viewer.isCellEditorActive()) {
                this.viewer.cancelEditing();
            }
            this.viewer.refresh();
            if (event instanceof ValueAddedEvent) {
                ValueAddedEvent vaEvent = (ValueAddedEvent)event;
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)vaEvent.getAddedValue()), true);
                this.viewer.refresh();
            } else if (event instanceof ValueModifiedEvent) {
                ValueModifiedEvent vmEvent = (ValueModifiedEvent)event;
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)vmEvent.getNewValue()), true);
            } else if (event instanceof ValueDeletedEvent) {
                ValueDeletedEvent vdEvent = (ValueDeletedEvent)event;
                if (vdEvent.getDeletedValue().getAttribute().getValueSize() > 0) {
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)vdEvent.getDeletedValue().getAttribute().getValues()[0]), true);
                }
            } else if (event instanceof EmptyValueAddedEvent) {
                this.viewer.refresh();
                EmptyValueAddedEvent evaEvent = (EmptyValueAddedEvent)event;
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)evaEvent.getAddedValue()), true);
                if (this.startEditAction.isEnabled()) {
                    this.startEditAction.run();
                }
            } else if (event instanceof EmptyValueDeletedEvent) {
                EmptyValueDeletedEvent evdEvent = (EmptyValueDeletedEvent)event;
                if (this.viewer.getSelection().isEmpty() && evdEvent.getDeletedValue().getAttribute().getValueSize() > 0) {
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)evdEvent.getDeletedValue().getAttribute().getValues()[0]), true);
                }
            } else {
                boolean cfr_ignored_0 = event instanceof AttributeDeletedEvent;
            }
        }
    }
}

