/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.wizards;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.wizards.AttributeWizard;
import org.apache.directory.studio.ldapbrowser.common.wizards.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttributeOptionsWizardPage
extends WizardPage {
    private AttributeWizard wizard;
    private Shell shell;
    private String[] possibleLanguages;
    private Map<String, String[]> possibleLangToCountriesMap;
    private List<String> parsedLangList;
    private List<String> parsedOptionList;
    private boolean parsedBinary;
    private Group langGroup;
    private ArrayList<LangLine> langLineList;
    private Group optionsGroup;
    private ArrayList<OptionLine> optionLineList;
    private Button binaryOptionButton;
    private Text previewText;

    public AttributeOptionsWizardPage(String pageName, String initialAttributeDescription, AttributeWizard wizard) {
        super(pageName);
        SortedSet countrySet;
        super.setTitle(Messages.getString("AttributeOptionsWizardPage.Options"));
        super.setDescription(Messages.getString("AttributeOptionsWizardPage.OptionsDescription"));
        super.setPageComplete(false);
        this.wizard = wizard;
        TreeSet<String> languageSet = new TreeSet<String>();
        HashMap languageToCountrySetMap = new HashMap();
        Locale[] locales = Locale.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            languageSet.add(locale.getLanguage());
            if (!languageToCountrySetMap.containsKey(locale.getLanguage())) {
                languageToCountrySetMap.put(locale.getLanguage(), new TreeSet());
            }
            countrySet = (SortedSet)languageToCountrySetMap.get(locale.getLanguage());
            countrySet.add(locale.getCountry());
            ++i;
        }
        this.possibleLanguages = languageSet.toArray(new String[languageSet.size()]);
        this.possibleLangToCountriesMap = new HashMap<String, String[]>();
        for (String language : languageToCountrySetMap.keySet()) {
            countrySet = (SortedSet)languageToCountrySetMap.get(language);
            String[] countries = countrySet.toArray(new String[countrySet.size()]);
            this.possibleLangToCountriesMap.put(language, countries);
        }
        if (initialAttributeDescription == null) {
            initialAttributeDescription = "";
        }
        String[] attributeDescriptionComponents = initialAttributeDescription.split(";");
        this.parsedLangList = new ArrayList<String>();
        this.parsedOptionList = new ArrayList<String>();
        this.parsedBinary = false;
        int i2 = 1;
        while (i2 < attributeDescriptionComponents.length) {
            if (attributeDescriptionComponents[i2].startsWith("lang-")) {
                this.parsedLangList.add(attributeDescriptionComponents[i2]);
            } else if (attributeDescriptionComponents[i2].equals("binary")) {
                this.parsedBinary = true;
            } else {
                this.parsedOptionList.add(attributeDescriptionComponents[i2]);
            }
            ++i2;
        }
    }

    private void validate() {
        this.previewText.setText(this.wizard.getAttributeDescription());
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validate();
        }
    }

    public void createControl(Composite parent) {
        int i;
        this.shell = parent.getShell();
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.langGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("AttributeOptionsWizardPage.LanguageTags"), (int)2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.langGroup.setLayoutData((Object)gd);
        Composite langComposite = BaseWidgetUtils.createColumnContainer((Composite)this.langGroup, (int)6, (int)1);
        this.langLineList = new ArrayList();
        BaseWidgetUtils.createSpacer((Composite)composite, (int)2);
        this.optionsGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("AttributeOptionsWizardPage.OtherOptions"), (int)2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.optionsGroup.setLayoutData((Object)gd);
        Composite optionsComposite = BaseWidgetUtils.createColumnContainer((Composite)this.optionsGroup, (int)3, (int)1);
        this.optionLineList = new ArrayList();
        Composite binaryComposite = BaseWidgetUtils.createColumnContainer((Composite)this.optionsGroup, (int)1, (int)1);
        this.binaryOptionButton = BaseWidgetUtils.createCheckbox((Composite)binaryComposite, (String)Messages.getString("AttributeOptionsWizardPage.BinaryOption"), (int)1);
        this.binaryOptionButton.setSelection(this.parsedBinary);
        Label la = new Label(composite, 0);
        gd = new GridData(1024);
        gd.horizontalSpan = 2;
        la.setLayoutData((Object)gd);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("AttributeOptionsWizardPage.Preview"), (int)1);
        this.previewText = BaseWidgetUtils.createReadonlyText((Composite)composite, (String)"", (int)1);
        if (this.parsedLangList.isEmpty()) {
            this.addLangLine(langComposite, 0);
        } else {
            i = 0;
            while (i < this.parsedLangList.size()) {
                this.addLangLine(langComposite, i);
                String l = this.parsedLangList.get(i);
                String[] ls = l.split("-", 3);
                if (ls.length > 1) {
                    this.langLineList.get((int)i).languageCombo.setText(ls[1]);
                }
                if (ls.length > 2) {
                    this.langLineList.get((int)i).countryCombo.setText(ls[2]);
                }
                ++i;
            }
        }
        if (this.parsedOptionList.isEmpty()) {
            this.addOptionLine(optionsComposite, 0);
        } else {
            i = 0;
            while (i < this.parsedOptionList.size()) {
                this.addOptionLine(optionsComposite, i);
                this.optionLineList.get((int)i).optionText.setText(this.parsedOptionList.get(i));
                ++i;
            }
        }
        this.binaryOptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeOptionsWizardPage.this.validate();
            }
        });
        this.validate();
        this.setControl((Control)composite);
    }

    String getAttributeOptions() {
        if (this.binaryOptionButton == null || this.binaryOptionButton.isDisposed()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1 == null || s2 == null) {
                    throw new ClassCastException(Messages.getString("AttributeOptionsWizardPage.MustNotBeNull"));
                }
                return s1.compareToIgnoreCase(s2);
            }
        };
        TreeSet<String> options = new TreeSet<String>(comparator);
        if (this.binaryOptionButton.getSelection()) {
            options.add("binary");
        }
        int i = 0;
        while (i < this.optionLineList.size()) {
            OptionLine optionLine = this.optionLineList.get(i);
            if (!"".equals(optionLine.optionText.getText())) {
                options.add(optionLine.optionText.getText());
            }
            if (this.optionLineList.size() > 1) {
                optionLine.optionDeleteButton.setEnabled(true);
            } else {
                optionLine.optionDeleteButton.setEnabled(false);
            }
            ++i;
        }
        i = 0;
        while (i < this.langLineList.size()) {
            LangLine langLine = this.langLineList.get(i);
            String l = langLine.languageCombo.getText();
            String c = langLine.countryCombo.getText();
            if (!"".equals(l)) {
                String s = "lang-" + l;
                if (!"".equals(c)) {
                    s = String.valueOf(s) + "-" + c;
                }
                options.add(s);
            }
            if (this.langLineList.size() > 1) {
                langLine.deleteButton.setEnabled(true);
            } else {
                langLine.deleteButton.setEnabled(false);
            }
            ++i;
        }
        for (String option : options) {
            sb.append(';');
            sb.append(option);
        }
        return sb.toString();
    }

    private void addOptionLine(Composite optionComposite, int index) {
        OptionLine[] optionLines = this.optionLineList.toArray(new OptionLine[this.optionLineList.size()]);
        if (optionLines.length > 0) {
            int i = 0;
            while (i < optionLines.length) {
                OptionLine oldOptionLine = optionLines[i];
                String oldValue = oldOptionLine.optionText.getText();
                oldOptionLine.optionText.dispose();
                oldOptionLine.optionAddButton.dispose();
                oldOptionLine.optionDeleteButton.dispose();
                this.optionLineList.remove(oldOptionLine);
                OptionLine newOptionLine = this.createOptionLine(optionComposite);
                this.optionLineList.add(newOptionLine);
                newOptionLine.optionText.setText(oldValue);
                if (index == i + 1) {
                    OptionLine optionLine = this.createOptionLine(optionComposite);
                    this.optionLineList.add(optionLine);
                }
                ++i;
            }
        } else {
            OptionLine optionLine = this.createOptionLine(optionComposite);
            this.optionLineList.add(optionLine);
        }
        this.shell.layout(true, true);
    }

    private OptionLine createOptionLine(final Composite optionComposite) {
        OptionLine optionLine = new OptionLine();
        optionLine.optionText = new Text(optionComposite, 2048);
        GridData gd = new GridData(768);
        optionLine.optionText.setLayoutData((Object)gd);
        optionLine.optionAddButton = new Button(optionComposite, 8);
        optionLine.optionAddButton.setText("  +   ");
        optionLine.optionAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AttributeOptionsWizardPage.this.optionLineList.size();
                int i = 0;
                while (i < AttributeOptionsWizardPage.this.optionLineList.size()) {
                    OptionLine optionLine = (OptionLine)AttributeOptionsWizardPage.this.optionLineList.get(i);
                    if (optionLine.optionAddButton == e.widget) {
                        index = i + 1;
                    }
                    ++i;
                }
                AttributeOptionsWizardPage.this.addOptionLine(optionComposite, index);
                AttributeOptionsWizardPage.this.validate();
            }
        });
        optionLine.optionDeleteButton = new Button(optionComposite, 8);
        optionLine.optionDeleteButton.setText("  \u2212  ");
        optionLine.optionDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = 0;
                int i = 0;
                while (i < AttributeOptionsWizardPage.this.optionLineList.size()) {
                    OptionLine optionLine = (OptionLine)AttributeOptionsWizardPage.this.optionLineList.get(i);
                    if (optionLine.optionDeleteButton == e.widget) {
                        index = i;
                    }
                    ++i;
                }
                AttributeOptionsWizardPage.this.deleteOptionLine(optionComposite, index);
                AttributeOptionsWizardPage.this.validate();
            }
        });
        optionLine.optionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeOptionsWizardPage.this.validate();
            }
        });
        return optionLine;
    }

    private void deleteOptionLine(Composite optionComposite, int index) {
        OptionLine optionLine = this.optionLineList.remove(index);
        if (optionLine != null) {
            optionLine.optionText.dispose();
            optionLine.optionAddButton.dispose();
            optionLine.optionDeleteButton.dispose();
            if (!optionComposite.isDisposed()) {
                this.shell.layout(true, true);
            }
        }
    }

    private void addLangLine(Composite langComposite, int index) {
        LangLine[] langLines = this.langLineList.toArray(new LangLine[this.langLineList.size()]);
        if (langLines.length > 0) {
            int i = 0;
            while (i < langLines.length) {
                LangLine oldLangLine = langLines[i];
                String oldLanguage = oldLangLine.languageCombo.getText();
                String oldCountry = oldLangLine.countryCombo.getText();
                oldLangLine.langLabel.dispose();
                oldLangLine.languageCombo.dispose();
                oldLangLine.minusLabel.dispose();
                oldLangLine.countryCombo.dispose();
                oldLangLine.addButton.dispose();
                oldLangLine.deleteButton.dispose();
                this.langLineList.remove(oldLangLine);
                LangLine newLangLine = this.createLangLine(langComposite);
                this.langLineList.add(newLangLine);
                newLangLine.languageCombo.setText(oldLanguage);
                newLangLine.countryCombo.setText(oldCountry);
                if (index == i + 1) {
                    LangLine langLine = this.createLangLine(langComposite);
                    this.langLineList.add(langLine);
                }
                ++i;
            }
        } else {
            LangLine langLine = this.createLangLine(langComposite);
            this.langLineList.add(langLine);
        }
        this.shell.layout(true, true);
    }

    private LangLine createLangLine(final Composite langComposite) {
        final LangLine langLine = new LangLine();
        langLine.langLabel = BaseWidgetUtils.createLabel((Composite)langComposite, (String)"lang-", (int)1);
        langLine.languageCombo = BaseWidgetUtils.createCombo((Composite)langComposite, (String[])this.possibleLanguages, (int)-1, (int)1);
        langLine.minusLabel = BaseWidgetUtils.createLabel((Composite)langComposite, (String)"-", (int)1);
        langLine.countryCombo = BaseWidgetUtils.createCombo((Composite)langComposite, (String[])new String[0], (int)-1, (int)1);
        langLine.countryCombo.setEnabled(false);
        langLine.addButton = new Button(langComposite, 8);
        langLine.addButton.setText("  +   ");
        langLine.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AttributeOptionsWizardPage.this.langLineList.size();
                int i = 0;
                while (i < AttributeOptionsWizardPage.this.langLineList.size()) {
                    LangLine langLine = (LangLine)AttributeOptionsWizardPage.this.langLineList.get(i);
                    if (langLine.addButton == e.widget) {
                        index = i + 1;
                    }
                    ++i;
                }
                AttributeOptionsWizardPage.this.addLangLine(langComposite, index);
                AttributeOptionsWizardPage.this.validate();
            }
        });
        langLine.deleteButton = new Button(langComposite, 8);
        langLine.deleteButton.setText("  \u2212  ");
        langLine.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = 0;
                int i = 0;
                while (i < AttributeOptionsWizardPage.this.langLineList.size()) {
                    LangLine langLine = (LangLine)AttributeOptionsWizardPage.this.langLineList.get(i);
                    if (langLine.deleteButton == e.widget) {
                        index = i;
                    }
                    ++i;
                }
                AttributeOptionsWizardPage.this.deleteLangLine(langComposite, index);
                AttributeOptionsWizardPage.this.validate();
            }
        });
        langLine.languageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if ("".equals(langLine.languageCombo.getText())) {
                    langLine.countryCombo.setEnabled(false);
                } else {
                    langLine.countryCombo.setEnabled(true);
                    String oldValue = langLine.countryCombo.getText();
                    if (AttributeOptionsWizardPage.this.possibleLangToCountriesMap.containsKey(langLine.languageCombo.getText())) {
                        langLine.countryCombo.setItems((String[])AttributeOptionsWizardPage.this.possibleLangToCountriesMap.get(langLine.languageCombo.getText()));
                    } else {
                        langLine.countryCombo.setItems(new String[0]);
                    }
                    langLine.countryCombo.setText(oldValue);
                }
                AttributeOptionsWizardPage.this.validate();
            }
        });
        langLine.countryCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeOptionsWizardPage.this.validate();
            }
        });
        return langLine;
    }

    private void deleteLangLine(Composite langComposite, int index) {
        LangLine langLine = this.langLineList.remove(index);
        if (langLine != null) {
            langLine.langLabel.dispose();
            langLine.languageCombo.dispose();
            langLine.minusLabel.dispose();
            langLine.countryCombo.dispose();
            langLine.addButton.dispose();
            langLine.deleteButton.dispose();
            if (!langComposite.isDisposed()) {
                this.shell.layout(true, true);
            }
        }
    }

    public class LangLine {
        public Label langLabel;
        public Combo languageCombo;
        public Label minusLabel;
        public Combo countryCombo;
        public Button addButton;
        public Button deleteButton;
    }

    public class OptionLine {
        public Text optionText;
        public Button optionAddButton;
        public Button optionDeleteButton;
    }
}

