/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.connection;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorInput;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.AbstractLinkWithEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionView;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.Messages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class LinkWithEditorAction
extends AbstractLinkWithEditorAction {
    private ConnectionView connectionView;

    public LinkWithEditorAction(ConnectionView connectionView) {
        super(connectionView, Messages.getString("LinkWithEditorAction.LinkWithEditor"));
        this.connectionView = connectionView;
        super.init();
    }

    @Override
    protected void linkViewWithEditor(IWorkbenchPart part) {
        if (part != null && this.connectionView != null && part.getSite().getWorkbenchWindow() == this.connectionView.getSite().getWorkbenchWindow()) {
            IStructuredSelection selection;
            Connection objectToSelect = null;
            if (part instanceof IEditorPart) {
                SearchResultEditorInput srei;
                ISearch search;
                IEditorPart editor = (IEditorPart)part;
                IEditorInput input = editor.getEditorInput();
                if (input instanceof EntryEditorInput) {
                    EntryEditorInput eei = (EntryEditorInput)input;
                    IEntry entry = eei.getResolvedEntry();
                    if (entry != null) {
                        objectToSelect = entry.getBrowserConnection().getConnection();
                    }
                } else if (input instanceof SearchResultEditorInput && (search = (srei = (SearchResultEditorInput)input).getSearch()) != null) {
                    objectToSelect = search.getBrowserConnection().getConnection();
                }
            }
            if (!(objectToSelect == null || (selection = (IStructuredSelection)this.connectionView.getMainWidget().getViewer().getSelection()).size() == 1 && selection.getFirstElement().equals(objectToSelect))) {
                this.connectionView.select(objectToSelect);
            }
        }
    }
}

