/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.feature.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.feature.Feature;
import org.osgi.service.feature.FeatureBuilder;
import org.osgi.service.feature.FeatureBundle;
import org.osgi.service.feature.FeatureConfiguration;
import org.osgi.service.feature.FeatureExtension;
import org.osgi.service.feature.ID;

class FeatureBuilderImpl
implements FeatureBuilder {
    private final ID id;
    private String name;
    private String description;
    private String docURL;
    private String license;
    private String scm;
    private String vendor;
    private boolean complete;
    private final List<FeatureBundle> bundles = new ArrayList<FeatureBundle>();
    private final List<String> categories = new ArrayList<String>();
    private final Map<String, FeatureConfiguration> configurations = new LinkedHashMap<String, FeatureConfiguration>();
    private final Map<String, FeatureExtension> extensions = new LinkedHashMap<String, FeatureExtension>();
    private final Map<String, Object> variables = new LinkedHashMap<String, Object>();

    FeatureBuilderImpl(ID id) {
        this.id = id;
    }

    public FeatureBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public FeatureBuilder setDocURL(String url) {
        this.docURL = url;
        return this;
    }

    public FeatureBuilder setVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    public FeatureBuilder setLicense(String license) {
        this.license = license;
        return this;
    }

    public FeatureBuilder setComplete(boolean complete) {
        this.complete = complete;
        return this;
    }

    public FeatureBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public FeatureBuilder setSCM(String scm) {
        this.scm = scm;
        return this;
    }

    public FeatureBuilder addBundles(FeatureBundle ... bundles) {
        this.bundles.addAll(Arrays.asList(bundles));
        return this;
    }

    public FeatureBuilder addCategories(String ... categories) {
        this.categories.addAll(Arrays.asList(categories));
        return this;
    }

    public FeatureBuilder addConfigurations(FeatureConfiguration ... configs) {
        for (FeatureConfiguration cfg : configs) {
            this.configurations.put(cfg.getPid(), cfg);
        }
        return this;
    }

    public FeatureBuilder addExtensions(FeatureExtension ... extensions) {
        for (FeatureExtension ex : extensions) {
            this.extensions.put(ex.getName(), ex);
        }
        return this;
    }

    public FeatureBuilder addVariable(String key, Object value) {
        this.variables.put(key, value);
        return this;
    }

    public FeatureBuilder addVariables(Map<String, Object> variables) {
        this.variables.putAll(variables);
        return this;
    }

    public Feature build() {
        return new FeatureImpl(this.id, this.name, this.description, this.docURL, this.license, this.scm, this.vendor, this.complete, this.bundles, this.categories, this.configurations, this.extensions, this.variables);
    }

    private static class FeatureImpl
    implements Feature {
        private final ID id;
        private final Optional<String> name;
        private final Optional<String> description;
        private final Optional<String> docURL;
        private final Optional<String> license;
        private final Optional<String> scm;
        private final Optional<String> vendor;
        private final boolean complete;
        private final List<FeatureBundle> bundles;
        private final List<String> categories;
        private final Map<String, FeatureConfiguration> configurations;
        private final Map<String, FeatureExtension> extensions;
        private final Map<String, Object> variables;

        private FeatureImpl(ID id, String aName, String desc, String docs, String lic, String sc, String vnd, boolean comp, List<FeatureBundle> bs, List<String> cats, Map<String, FeatureConfiguration> cs, Map<String, FeatureExtension> es, Map<String, Object> vars) {
            this.id = id;
            this.name = Optional.ofNullable(aName);
            this.description = Optional.ofNullable(desc);
            this.docURL = Optional.ofNullable(docs);
            this.license = Optional.ofNullable(lic);
            this.scm = Optional.ofNullable(sc);
            this.vendor = Optional.ofNullable(vnd);
            this.complete = comp;
            this.bundles = Collections.unmodifiableList(bs);
            this.categories = Collections.unmodifiableList(cats);
            this.configurations = Collections.unmodifiableMap(cs);
            this.extensions = Collections.unmodifiableMap(es);
            this.variables = Collections.unmodifiableMap(vars);
        }

        public ID getID() {
            return this.id;
        }

        public Optional<String> getName() {
            return this.name;
        }

        public Optional<String> getDescription() {
            return this.description;
        }

        public Optional<String> getVendor() {
            return this.vendor;
        }

        public Optional<String> getLicense() {
            return this.license;
        }

        public Optional<String> getDocURL() {
            return this.docURL;
        }

        public Optional<String> getSCM() {
            return this.scm;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public List<FeatureBundle> getBundles() {
            return this.bundles;
        }

        public List<String> getCategories() {
            return this.categories;
        }

        public Map<String, FeatureConfiguration> getConfigurations() {
            return this.configurations;
        }

        public Map<String, FeatureExtension> getExtensions() {
            return this.extensions;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public int hashCode() {
            return Objects.hash(this.bundles, this.categories, this.complete, this.configurations, this.description, this.docURL, this.extensions, this.id, this.license, this.name, this.scm, this.variables, this.vendor);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FeatureImpl other = (FeatureImpl)obj;
            return Objects.equals(this.bundles, other.bundles) && Objects.equals(this.categories, other.categories) && this.complete == other.complete && Objects.equals(this.configurations, other.configurations) && Objects.equals(this.description, other.description) && Objects.equals(this.docURL, other.docURL) && Objects.equals(this.extensions, other.extensions) && Objects.equals(this.id, other.id) && Objects.equals(this.license, other.license) && Objects.equals(this.name, other.name) && Objects.equals(this.scm, other.scm) && Objects.equals(this.variables, other.variables) && Objects.equals(this.vendor, other.vendor);
        }

        public String toString() {
            return "FeatureImpl [getID()=" + this.getID() + "]";
        }
    }
}

