/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.commands;

import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.core.impl.servlet.ResultTxtVerboseSerializer;
import org.apache.felix.hc.core.impl.util.HealthCheckFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={HealthCheckListCommand.class}, property={"osgi.command.scope=hc", "osgi.command.function=list"})
public class HealthCheckListCommand {
    private BundleContext bundleContext;

    @Activate
    protected final void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String list(String ... params) {
        boolean isVerbose = false;
        for (String param : params) {
            if (!"-v".equals(param)) {
                if ("-h".equals(param)) {
                    return this.getHelpText();
                }
                System.out.println("unrecognized option: " + param);
                return this.getHelpText();
            }
            isVerbose = true;
        }
        HealthCheckFilter hcFilter = new HealthCheckFilter(this.bundleContext);
        HealthCheckSelector selector = HealthCheckSelector.empty();
        ServiceReference<HealthCheck>[] hcRefs = hcFilter.getHealthCheckServiceReferences(selector);
        Stream hcRefsStream = Arrays.asList(hcRefs).stream();
        if (isVerbose) {
            return hcRefsStream.map(ref -> {
                HealthCheckMetadata metadata = new HealthCheckMetadata(ref);
                return String.join((CharSequence)" ", ResultTxtVerboseSerializer.rightPad(metadata.getTitle(), 60), ResultTxtVerboseSerializer.rightPad(String.join((CharSequence)",", metadata.getTags()), 50), ref.getBundle().getSymbolicName());
            }).collect(Collectors.joining("\n"));
        }
        return hcRefsStream.flatMap(ref -> new HealthCheckMetadata(ref).getTags().stream()).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.joining(","));
    }

    private String getHelpText() {
        return "Usage: hc:list [-v]\n  -v verbose";
    }
}

