/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.logger;

import java.lang.reflect.Array;
import org.apache.felix.http.base.internal.logger.LogServiceEnabledLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class SystemLogger {
    private static volatile LogServiceEnabledLogger LOGGER;

    public static void init(BundleContext bundleContext) {
        LOGGER = new LogServiceEnabledLogger(bundleContext);
    }

    public static void destroy() {
        if (LOGGER != null) {
            LOGGER.close();
            LOGGER = null;
        }
    }

    private static String getMessage(ServiceReference<?> ref, String message) {
        if (ref == null) {
            return message;
        }
        Bundle bundle = ref.getBundle();
        StringBuilder ib = new StringBuilder();
        ib.append("[ServiceReference ");
        ib.append(String.valueOf(ref.getProperty("service.id")));
        ib.append(" from bundle ");
        if (bundle == null) {
            ib.append("<uninstalled>");
        } else {
            ib.append(bundle.getBundleId());
            if (bundle.getSymbolicName() != null) {
                ib.append(" : ");
                ib.append(bundle.getSymbolicName());
                ib.append(":");
                ib.append(bundle.getVersion());
            }
        }
        ib.append(" ref=");
        ib.append(ref);
        ib.append(" properties={");
        boolean first = true;
        for (String name : ref.getPropertyKeys()) {
            if (first) {
                first = false;
            } else {
                ib.append(", ");
            }
            Object val = ref.getProperty(name);
            ib.append(name);
            ib.append("=");
            if (val.getClass().isArray()) {
                boolean fa = true;
                ib.append('[');
                for (int i = 0; i < Array.getLength(val); ++i) {
                    if (fa) {
                        fa = false;
                    } else {
                        ib.append(", ");
                    }
                    ib.append(Array.get(val, i));
                }
                ib.append(']');
                continue;
            }
            ib.append(val);
        }
        ib.append("}] ");
        ib.append(message);
        return ib.toString();
    }

    private static void log(int level, ServiceReference<?> ref, String message, Throwable cause) {
        LogServiceEnabledLogger l = LOGGER;
        if (l != null) {
            l.log(level, SystemLogger.getMessage(ref, message), cause);
        }
    }

    public static void debug(String message) {
        SystemLogger.log(4, null, message, null);
    }

    public static void debug(ServiceReference<?> ref, String message) {
        SystemLogger.log(4, ref, message, null);
    }

    public static void debug(String message, Throwable cause) {
        SystemLogger.log(4, null, message, cause);
    }

    public static void info(String message) {
        SystemLogger.log(3, null, message, null);
    }

    public static void warning(String message, Throwable cause) {
        SystemLogger.log(2, null, message, cause);
    }

    public static void error(String message, Throwable cause) {
        SystemLogger.log(1, null, message, cause);
    }

    public static void error(ServiceReference<?> ref, String message, Throwable cause) {
        SystemLogger.log(1, ref, message, cause);
    }
}

