/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.osgi.ServiceRegistration;
import org.apache.felix.httplite.osgi.ServiceRegistrationResolver;
import org.apache.felix.httplite.servlet.ConcreteServletInputStream;
import org.apache.felix.httplite.servlet.HttpConstants;
import org.apache.felix.httplite.servlet.UnimplementedAPIException;

public class HttpServletRequestImpl
implements HttpServletRequest {
    private String m_method;
    private String m_uriHost;
    private String m_uri;
    private String m_version;
    private final Map m_headers = new HashMap();
    private final Socket m_socket;
    private Cookie[] m_cookies;
    private final Locale m_locale = new Locale(System.getProperty("user.language"), System.getProperty("user.country"));
    private Map m_attributes;
    private final ServiceRegistrationResolver m_resolver;
    private String m_servletPath;
    private Map m_parameters;
    private byte[] m_requestBody = null;
    private final Logger m_logger;
    private String m_queryString;
    private boolean m_getInputStreamCalled = false;
    private boolean m_getReaderCalled = false;

    public HttpServletRequestImpl(Socket socket, ServiceRegistrationResolver serviceRegistrationResolver, Logger logger) {
        this.m_socket = socket;
        this.m_resolver = serviceRegistrationResolver;
        this.m_logger = logger;
    }

    protected Socket getSocket() {
        return this.m_socket;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.m_getReaderCalled) {
            throw new IllegalStateException("getReader() has already been called.");
        }
        if (this.m_requestBody == null) {
            this.parseBody(new BufferedInputStream(this.m_socket.getInputStream()));
        }
        this.m_getInputStreamCalled = true;
        return new ConcreteServletInputStream(new ByteArrayInputStream(this.m_requestBody));
    }

    public BufferedReader getReader() throws IOException {
        if (this.m_getInputStreamCalled) {
            throw new IllegalStateException("getInputStream() has already been called.");
        }
        if (this.m_requestBody == null) {
            this.parseBody(new BufferedInputStream(this.m_socket.getInputStream()));
        }
        this.m_getReaderCalled = true;
        return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.m_requestBody)));
    }

    public void parseRequestLine(ConcreteServletInputStream is) throws IOException {
        String requestLine = is.readLine();
        if (requestLine == null) {
            throw new IOException("Unexpected end of file when reading request line.");
        }
        StringTokenizer st = new StringTokenizer(requestLine, " ");
        if (st.countTokens() != 3) {
            throw new IOException("Malformed HTTP request: " + requestLine);
        }
        this.m_method = st.nextToken();
        this.m_uri = st.nextToken();
        this.m_version = st.nextToken();
        int qsIdx = this.m_uri.indexOf("?");
        if (qsIdx > 0) {
            this.m_queryString = this.m_uri.substring(qsIdx + 1);
            this.m_uri = this.m_uri.substring(0, qsIdx);
        }
        if (this.m_uri.indexOf("//") > -1) {
            this.m_uri = this.stripRedundantSeparators(this.m_uri);
        }
    }

    private String stripRedundantSeparators(String in) {
        StringBuffer sb = new StringBuffer();
        boolean lastIsSeparator = false;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (lastIsSeparator && c == '/') continue;
            sb.append(c);
            lastIsSeparator = c == '/';
        }
        return sb.toString();
    }

    public void parseHeader(ConcreteServletInputStream is) throws IOException {
        String s = is.readLine();
        while (s != null && s.length() != 0) {
            int idx = s.indexOf(":");
            if (idx > 0) {
                String header = s.substring(0, idx).trim();
                String value = s.substring(idx + 1).trim();
                String key = header.toLowerCase();
                if (!this.m_headers.containsKey(key)) {
                    this.m_headers.put(key, value);
                } else {
                    Object originalValue = this.m_headers.get(key);
                    if (originalValue instanceof String) {
                        ArrayList<Object> headerList = new ArrayList<Object>();
                        headerList.add(originalValue);
                        headerList.add(value);
                        this.m_headers.put(key, headerList);
                    } else if (originalValue instanceof List) {
                        ((List)originalValue).add(value);
                    } else {
                        throw new RuntimeException("Unexpected type in m_headers: " + originalValue.getClass().getName());
                    }
                }
            }
            s = is.readLine();
        }
        if (this.m_headers.containsKey("Host")) {
            this.m_uriHost = this.m_headers.get("Host").toString();
        }
    }

    public void parseBody(InputStream is) throws IOException {
        int length = this.getContentLength();
        if (length > 0) {
            OutputStream baos = null;
            byte[] buf = new byte[length];
            int left = length;
            do {
                if ((left -= is.read(buf)) <= 0) continue;
                if (baos == null) {
                    baos = new ByteArrayOutputStream(length);
                }
                baos.write(buf);
            } while (left > 0);
            this.m_requestBody = baos != null ? ((ByteArrayOutputStream)baos).toByteArray() : buf;
        } else {
            this.m_requestBody = new byte[0];
        }
    }

    public String getMethod() {
        return this.m_method;
    }

    public String getHeader(String header) {
        Object value = this.m_headers.get(header.toLowerCase());
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Enumeration getHeaders(String name) {
        Object v = this.m_headers.get(name);
        if (v == null) {
            return HttpConstants.EMPTY_ENUMERATION;
        }
        if (v instanceof String) {
            return Collections.enumeration(Arrays.asList((String)v));
        }
        if (v instanceof List) {
            return Collections.enumeration((List)v);
        }
        throw new RuntimeException("Unexpected type in m_headers: " + v.getClass().getName());
    }

    public Enumeration getHeaderNames() {
        if (this.m_headers.isEmpty()) {
            return HttpConstants.EMPTY_ENUMERATION;
        }
        return Collections.enumeration(this.m_headers.keySet());
    }

    public Object getAttribute(String arg0) {
        if (this.m_attributes != null) {
            return this.m_attributes.get(arg0);
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        if (this.m_attributes != null) {
            return Collections.enumeration(this.m_attributes.keySet());
        }
        return HttpConstants.EMPTY_ENUMERATION;
    }

    public String getCharacterEncoding() {
        return this.getHeader("Accept-Encoding");
    }

    public int getContentLength() {
        int len = 0;
        try {
            len = Integer.parseInt(this.getHeader("Content-Length"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return len;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Enumeration getLocales() {
        return Collections.enumeration(Arrays.asList(this.m_locale));
    }

    public String getParameter(String arg0) {
        if (this.m_parameters == null) {
            try {
                this.m_parameters = this.parseParameters();
            }
            catch (UnsupportedEncodingException e) {
                this.m_logger.log(1, "Failed to parse request parameters.", e);
                return null;
            }
        }
        return (String)this.m_parameters.get(arg0);
    }

    public Map getParameterMap() {
        if (this.m_parameters == null) {
            try {
                this.m_parameters = this.parseParameters();
            }
            catch (UnsupportedEncodingException e) {
                this.m_logger.log(1, "Failed to parse request parameters.", e);
                return null;
            }
        }
        return this.m_parameters;
    }

    public Enumeration getParameterNames() {
        if (this.m_parameters == null) {
            try {
                this.m_parameters = this.parseParameters();
            }
            catch (UnsupportedEncodingException e) {
                this.m_logger.log(1, "Failed to parse request parameters.", e);
                return null;
            }
        }
        return Collections.enumeration(this.m_parameters.keySet());
    }

    public String[] getParameterValues(String arg0) {
        if (this.m_parameters == null) {
            try {
                this.m_parameters = this.parseParameters();
            }
            catch (UnsupportedEncodingException e) {
                this.m_logger.log(1, "Failed to parse request parameters.", e);
                return null;
            }
        }
        return this.m_parameters.values().toArray(new String[this.m_parameters.size()]);
    }

    public String getProtocol() {
        return this.m_version;
    }

    public String getRealPath(String arg0) {
        throw new UnimplementedAPIException();
    }

    public String getRemoteAddr() {
        return this.getSocket().getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.getSocket().getInetAddress().getHostName();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return "Apache Felix Lightweight HTTP Service";
    }

    public int getServerPort() {
        return this.getSocket().getLocalPort();
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String arg0) {
        if (this.m_attributes != null) {
            this.m_attributes.remove(arg0);
        }
    }

    public void setAttribute(String arg0, Object arg1) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        throw new UnimplementedAPIException();
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        if (this.m_cookies == null) {
            String cookieHeader = this.getHeader("Cookie");
            if (cookieHeader == null) {
                return null;
            }
            ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
            Iterator<String> i = Arrays.asList(HttpServletRequestImpl.splitString(cookieHeader, ";")).iterator();
            while (i.hasNext()) {
                String[] nvp = HttpServletRequestImpl.splitString(i.next().toString(), "=");
                if (nvp.length != 2) continue;
                cookieList.add(new Cookie(nvp[0].trim(), nvp[1].trim()));
            }
            this.m_cookies = cookieList.toArray(new Cookie[cookieList.size()]);
        }
        return this.m_cookies;
    }

    public long getDateHeader(String name) {
        String headerValue = this.getHeader(name);
        if (headerValue == null) {
            return -1L;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            return sdf.parse(headerValue).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to convert to date: " + headerValue);
        }
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getPathInfo() {
        String alias = this.getAlias();
        if (this.m_uri != null && alias.length() > 0) {
            if (this.m_uri.length() == alias.length()) {
                return null;
            }
            return this.m_uri.substring(alias.length());
        }
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return "";
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return this.m_uri;
    }

    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        if (this.m_uriHost != null) {
            sb.append(this.m_uriHost);
        }
        sb.append(this.m_uri);
        return sb;
    }

    public String getServletPath() {
        if (this.m_servletPath == null) {
            ServiceRegistration element = this.m_resolver.getServiceRegistration(this.m_uri);
            if (element == null) {
                throw new IllegalStateException("Unable to get ServletElement for HttpRequest.");
            }
            this.m_servletPath = element.getAlias();
        }
        return this.m_servletPath;
    }

    private String getAlias() {
        ServiceRegistration element = this.m_resolver.getServiceRegistration(this.m_uri);
        if (element == null) {
            throw new IllegalStateException("Unable to get ServletElement for HttpRequest.");
        }
        return element.getAlias();
    }

    public HttpSession getSession(boolean create) {
        throw new UnimplementedAPIException();
    }

    public HttpSession getSession() {
        throw new UnimplementedAPIException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnimplementedAPIException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnimplementedAPIException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnimplementedAPIException();
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnimplementedAPIException();
    }

    private Map parseParameters() throws UnsupportedEncodingException {
        HashMap params = new HashMap();
        String queryString = this.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            this.parseParameterString(queryString, params);
        }
        if (this.m_requestBody != null && this.m_requestBody.length > 0) {
            this.parseParameterString(new String(this.m_requestBody), params);
        }
        return Collections.unmodifiableMap(params);
    }

    private void parseParameterString(String queryString, Map params) throws UnsupportedEncodingException {
        String[] parameters = HttpServletRequestImpl.splitString(queryString, "&");
        Iterator<String> i = Arrays.asList(parameters).iterator();
        while (i.hasNext()) {
            String[] nva = HttpServletRequestImpl.splitString(i.next().toString(), "=");
            if (nva.length != 2) continue;
            params.put(URLDecoder.decode(nva[0].trim()), nva[1].trim());
        }
    }

    public static boolean isSupportedMethod(String method) {
        return !method.equals(HttpConstants.OPTIONS_REQUEST);
    }

    public String toString() {
        if (this.m_method != null && this.m_uri != null) {
            return this.m_method + " " + this.m_uri;
        }
        return super.toString();
    }

    public String getLocalAddr() {
        return this.m_socket.getLocalAddress().getHostAddress();
    }

    public String getLocalName() {
        return this.m_socket.getLocalAddress().getHostName();
    }

    public int getLocalPort() {
        return this.m_socket.getLocalPort();
    }

    public int getRemotePort() {
        return this.m_socket.getPort();
    }

    private static String[] splitString(String instr, String separator) {
        if (instr == null) {
            throw new IllegalArgumentException("Input string must not be null.");
        }
        StringTokenizer tokenizer = new StringTokenizer(instr, separator);
        int length = tokenizer.countTokens();
        String[] str_array = new String[length];
        for (int i = 0; i < length; ++i) {
            str_array[i] = tokenizer.nextToken();
        }
        return str_array;
    }
}

