/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.arch.gogo;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.extender.ExtensionDeclaration;
import org.apache.felix.ipojo.extender.InstanceDeclaration;
import org.apache.felix.ipojo.extender.TypeDeclaration;
import org.apache.felix.service.command.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(public_factory=false, immediate=true)
@Instantiate
@Provides(specifications={Arch.class})
public class Arch
implements Pojo {
    private InstanceManager __IM;
    private boolean __Fm_scope;
    @ServiceProperty(name="osgi.command.scope", value="ipojo")
    String m_scope;
    private boolean __Fm_function;
    @ServiceProperty(name="osgi.command.function", value="{}")
    String[] m_function;
    private boolean __Fm_archs;
    @Requires(optional=true)
    private Architecture[] m_archs;
    private boolean __Fm_factories;
    @Requires(optional=true)
    private Factory[] m_factories;
    private boolean __Fm_handlers;
    @Requires(optional=true)
    private HandlerFactory[] m_handlers;
    private boolean __Fm_instances;
    @Requires(optional=true)
    private InstanceDeclaration[] m_instances;
    private boolean __Fm_types;
    @Requires(optional=true)
    private TypeDeclaration[] m_types;
    private boolean __Fm_extensions;
    @Requires(optional=true)
    private ExtensionDeclaration[] m_extensions;
    private boolean __Minstances;
    private boolean __Mname$java_util_Dictionary;
    private boolean __Minstance$java_lang_String;
    private boolean __Mcomponent$java_lang_String;
    private boolean __Mfactory$java_lang_String;
    private boolean __Mcomponents;
    private boolean __Mfactories;
    private boolean __Mhandlers;
    private boolean __Mextensions;

    String __getm_scope() {
        if (!this.__Fm_scope) {
            return this.m_scope;
        }
        return (String)this.__IM.onGet((Object)this, "m_scope");
    }

    void __setm_scope(String string) {
        if (!this.__Fm_scope) {
            this.m_scope = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_scope", (Object)string);
    }

    String[] __getm_function() {
        if (!this.__Fm_function) {
            return this.m_function;
        }
        return (String[])this.__IM.onGet((Object)this, "m_function");
    }

    void __setm_function(String[] stringArray) {
        if (!this.__Fm_function) {
            this.m_function = stringArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_function", (Object)stringArray);
    }

    Architecture[] __getm_archs() {
        if (!this.__Fm_archs) {
            return this.m_archs;
        }
        return (Architecture[])this.__IM.onGet((Object)this, "m_archs");
    }

    void __setm_archs(Architecture[] architectureArray) {
        if (!this.__Fm_archs) {
            this.m_archs = architectureArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_archs", (Object)architectureArray);
    }

    Factory[] __getm_factories() {
        if (!this.__Fm_factories) {
            return this.m_factories;
        }
        return (Factory[])this.__IM.onGet((Object)this, "m_factories");
    }

    void __setm_factories(Factory[] factoryArray) {
        if (!this.__Fm_factories) {
            this.m_factories = factoryArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_factories", (Object)factoryArray);
    }

    HandlerFactory[] __getm_handlers() {
        if (!this.__Fm_handlers) {
            return this.m_handlers;
        }
        return (HandlerFactory[])this.__IM.onGet((Object)this, "m_handlers");
    }

    void __setm_handlers(HandlerFactory[] handlerFactoryArray) {
        if (!this.__Fm_handlers) {
            this.m_handlers = handlerFactoryArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_handlers", (Object)handlerFactoryArray);
    }

    InstanceDeclaration[] __getm_instances() {
        if (!this.__Fm_instances) {
            return this.m_instances;
        }
        return (InstanceDeclaration[])this.__IM.onGet((Object)this, "m_instances");
    }

    void __setm_instances(InstanceDeclaration[] instanceDeclarationArray) {
        if (!this.__Fm_instances) {
            this.m_instances = instanceDeclarationArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_instances", (Object)instanceDeclarationArray);
    }

    TypeDeclaration[] __getm_types() {
        if (!this.__Fm_types) {
            return this.m_types;
        }
        return (TypeDeclaration[])this.__IM.onGet((Object)this, "m_types");
    }

    void __setm_types(TypeDeclaration[] typeDeclarationArray) {
        if (!this.__Fm_types) {
            this.m_types = typeDeclarationArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_types", (Object)typeDeclarationArray);
    }

    ExtensionDeclaration[] __getm_extensions() {
        if (!this.__Fm_extensions) {
            return this.m_extensions;
        }
        return (ExtensionDeclaration[])this.__IM.onGet((Object)this, "m_extensions");
    }

    void __setm_extensions(ExtensionDeclaration[] extensionDeclarationArray) {
        if (!this.__Fm_extensions) {
            this.m_extensions = extensionDeclarationArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_extensions", (Object)extensionDeclarationArray);
    }

    public Arch() {
        this(null);
    }

    private Arch(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_function(new String[]{"instances", "instance", "factory", "component", "factories", "components", "handlers", "extensions"});
    }

    @Descriptor(value="Display iPOJO instances")
    public void instances() {
        if (!this.__Minstances) {
            this.__M_instances();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "instances", new Object[0]);
            this.__M_instances();
            this.__IM.onExit((Object)this, "instances", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "instances", throwable);
            throw throwable;
        }
    }

    private void __M_instances() {
        StringBuilder buffer = new StringBuilder();
        for (Architecture architecture : this.__getm_archs()) {
            InstanceDescription instance = architecture.getInstanceDescription();
            if (instance.getState() == 2) {
                buffer.append(String.format("Instance %s -> valid%n", instance.getName()));
            }
            if (instance.getState() == 1) {
                buffer.append(String.format("Instance %s -> invalid%n", instance.getName()));
            }
            if (instance.getState() != 0) continue;
            buffer.append(String.format("Instance %s -> stopped%n", instance.getName()));
        }
        for (Architecture architecture : this.__getm_instances()) {
            if (architecture.getStatus().isBound()) continue;
            buffer.append(String.format("Instance %s of type %s is not bound.%n", this.name(architecture.getConfiguration()), architecture.getConfiguration().get("component")));
            buffer.append(String.format("  Reason: %s", architecture.getStatus().getMessage()));
            buffer.append("\n");
        }
        if (buffer.length() == 0) {
            buffer.append("No instances \n");
        }
        System.out.println(buffer.toString());
    }

    private String name(Dictionary<String, Object> configuration) {
        String string;
        if (!this.__Mname$java_util_Dictionary) {
            return this.__M_name(configuration);
        }
        try {
            this.__IM.onEntry((Object)this, "name$java_util_Dictionary", new Object[]{configuration});
            string = this.__M_name(configuration);
            this.__IM.onExit((Object)this, "name$java_util_Dictionary", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "name$java_util_Dictionary", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_name(Dictionary<String, Object> configuration) {
        String name = (String)configuration.get("instance.name");
        if (name == null) {
            name = "unnamed";
        }
        return name;
    }

    @Descriptor(value="Display the architecture of a specific instance")
    public void instance(@Descriptor(value="target instance name") String instance) {
        if (!this.__Minstance$java_lang_String) {
            this.__M_instance(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "instance$java_lang_String", new Object[]{instance});
            this.__M_instance(instance);
            this.__IM.onExit((Object)this, "instance$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "instance$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_instance(String instance) {
        StringBuilder sb = new StringBuilder();
        for (Architecture architecture : this.__getm_archs()) {
            InstanceDescription id = architecture.getInstanceDescription();
            if (!id.getName().equalsIgnoreCase(instance)) continue;
            sb.append(id.getDescription());
            sb.append('\n');
        }
        for (Architecture architecture : this.__getm_instances()) {
            if (architecture.getStatus().isBound() || !instance.equals(this.name(architecture.getConfiguration()))) continue;
            sb.append(String.format("InstanceDeclaration %s not bound to its factory%n", instance));
            sb.append(String.format(" type: %s%n", architecture.getComponentName()));
            sb.append(String.format(" reason: %s%n", architecture.getStatus().getMessage()));
            Throwable throwable = architecture.getStatus().getThrowable();
            if (throwable == null) continue;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintStream(os));
            sb.append(" throwable: ");
            sb.append(os.toString());
        }
        if (sb.length() == 0) {
            System.err.printf("Instance named '%s' not found", instance);
        } else {
            System.out.print(sb);
        }
    }

    @Descriptor(value="Display the information about a specific factory / component")
    public void component(@Descriptor(value="target factory name") String name) {
        if (!this.__Mcomponent$java_lang_String) {
            this.__M_component(name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "component$java_lang_String", new Object[]{name});
            this.__M_component(name);
            this.__IM.onExit((Object)this, "component$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "component$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_component(String name) {
        this.factory(name);
    }

    @Descriptor(value="Display the information about a specific factory")
    public void factory(@Descriptor(value="target factory name") String name) {
        if (!this.__Mfactory$java_lang_String) {
            this.__M_factory(name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "factory$java_lang_String", new Object[]{name});
            this.__M_factory(name);
            this.__IM.onExit((Object)this, "factory$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "factory$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_factory(String name) {
        ArrayList<Factory> factories = new ArrayList<Factory>();
        ArrayList<Factory> types = new ArrayList<Factory>();
        for (Factory factory : this.__getm_factories()) {
            if (!factory.getName().equalsIgnoreCase(name)) continue;
            factories.add(factory);
        }
        for (Factory factory : this.__getm_types()) {
            if (!name.equalsIgnoreCase(factory.getComponentName()) || factory.isPublic() && (factory.getStatus().isBound() || !factory.isPublic())) continue;
            types.add(factory);
        }
        if (factories.isEmpty() && types.isEmpty()) {
            System.err.println("Factory " + name + " not found");
            return;
        }
        for (Factory factory : factories) {
            System.out.println(factory.getComponentDescription());
        }
        for (TypeDeclaration typeDeclaration : types) {
            if (!typeDeclaration.getStatus().isBound()) {
                System.out.printf("Factory %s is not bound%n", typeDeclaration.getComponentName());
                System.out.printf("  reason: %s%n", typeDeclaration.getStatus().getMessage());
                Throwable throwable = typeDeclaration.getStatus().getThrowable();
                if (throwable == null) continue;
                System.out.print("  throwable: ");
                throwable.printStackTrace(System.out);
                continue;
            }
            System.out.printf("Factory %s is bound - Private%n", typeDeclaration.getComponentName());
        }
    }

    @Descriptor(value="Display iPOJO factories / components")
    public void components() {
        if (!this.__Mcomponents) {
            this.__M_components();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "components", new Object[0]);
            this.__M_components();
            this.__IM.onExit((Object)this, "components", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "components", throwable);
            throw throwable;
        }
    }

    private void __M_components() {
        this.factories();
    }

    @Descriptor(value="Display iPOJO factories")
    public void factories() {
        if (!this.__Mfactories) {
            this.__M_factories();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "factories", new Object[0]);
            this.__M_factories();
            this.__IM.onExit((Object)this, "factories", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "factories", throwable);
            throw throwable;
        }
    }

    private void __M_factories() {
        StringBuilder buffer = new StringBuilder();
        for (Factory factory : this.__getm_factories()) {
            if (factory.getMissingHandlers().size() == 0) {
                buffer.append(String.format("Factory %s (VALID)%n", factory.getName()));
                continue;
            }
            buffer.append(String.format("Factory %s (INVALID: %s)%n", factory.getName(), factory.getMissingHandlers()));
        }
        for (Factory factory : this.__getm_types()) {
            if (!factory.isPublic()) {
                if (factory.getStatus().isBound()) {
                    buffer.append(String.format("Factory %s (UNKNOWN) - Private%n", factory.getComponentName()));
                    continue;
                }
                buffer.append(String.format("Factory %s (INVALID) - Private%n", factory.getComponentName()));
                buffer.append(String.format("  -> %s", factory.getStatus().getMessage()));
                continue;
            }
            if (factory.getStatus().isBound()) continue;
            buffer.append(String.format("Factory %s is not bound%n", factory.getComponentName()));
            buffer.append(String.format("  -> %s%n", factory.getStatus().getMessage()));
        }
        if (buffer.length() == 0) {
            buffer.append("No factories \n");
        }
        System.out.println(buffer.toString());
    }

    @Descriptor(value="Display iPOJO handlers")
    public void handlers() {
        if (!this.__Mhandlers) {
            this.__M_handlers();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "handlers", new Object[0]);
            this.__M_handlers();
            this.__IM.onExit((Object)this, "handlers", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "handlers", throwable);
            throw throwable;
        }
    }

    private void __M_handlers() {
        PrintStream out = System.out;
        for (HandlerFactory handlerFactory : this.__getm_handlers()) {
            String name = handlerFactory.getHandlerName();
            if ("composite".equals(handlerFactory.getType())) {
                name = name + " [composite]";
            }
            if (handlerFactory.getMissingHandlers().size() == 0) {
                out.println("Handler " + name + " (VALID)");
                continue;
            }
            out.println("Handler " + name + " (INVALID : " + handlerFactory.getMissingHandlers() + ")");
        }
        for (HandlerFactory handlerFactory : this.__getm_types()) {
            if (handlerFactory.getStatus().isBound()) continue;
            out.println("HandlerFactory " + handlerFactory.getComponentName() + " is not bound");
            out.println("  -> " + handlerFactory.getStatus().getMessage());
        }
    }

    @Descriptor(value="Display iPOJO extensions")
    public void extensions() {
        if (!this.__Mextensions) {
            this.__M_extensions();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "extensions", new Object[0]);
            this.__M_extensions();
            this.__IM.onExit((Object)this, "extensions", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "extensions", throwable);
            throw throwable;
        }
    }

    private void __M_extensions() {
        PrintStream out = System.out;
        out.println("Available extensions:");
        for (ExtensionDeclaration extension : this.__getm_extensions()) {
            out.println("  * " + extension.getExtensionName());
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_archs")) {
                this.__Fm_archs = true;
            }
            if (set.contains("m_extensions")) {
                this.__Fm_extensions = true;
            }
            if (set.contains("m_factories")) {
                this.__Fm_factories = true;
            }
            if (set.contains("m_function")) {
                this.__Fm_function = true;
            }
            if (set.contains("m_handlers")) {
                this.__Fm_handlers = true;
            }
            if (set.contains("m_instances")) {
                this.__Fm_instances = true;
            }
            if (set.contains("m_scope")) {
                this.__Fm_scope = true;
            }
            if (set.contains("m_types")) {
                this.__Fm_types = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("instances")) {
                this.__Minstances = true;
            }
            if (set.contains("name$java_util_Dictionary")) {
                this.__Mname$java_util_Dictionary = true;
            }
            if (set.contains("instance$java_lang_String")) {
                this.__Minstance$java_lang_String = true;
            }
            if (set.contains("component$java_lang_String")) {
                this.__Mcomponent$java_lang_String = true;
            }
            if (set.contains("factory$java_lang_String")) {
                this.__Mfactory$java_lang_String = true;
            }
            if (set.contains("components")) {
                this.__Mcomponents = true;
            }
            if (set.contains("factories")) {
                this.__Mfactories = true;
            }
            if (set.contains("handlers")) {
                this.__Mhandlers = true;
            }
            if (set.contains("extensions")) {
                this.__Mextensions = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

