/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.online.manipulator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.StaticServiceProperty;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.manipulator.ManipulationVisitor;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.metadata.CompositeMetadataProvider;
import org.apache.felix.ipojo.manipulator.metadata.FileMetadataProvider;
import org.apache.felix.ipojo.manipulator.reporter.SystemReporter;
import org.apache.felix.ipojo.manipulator.spi.Module;
import org.apache.felix.ipojo.manipulator.spi.ModuleProvider;
import org.apache.felix.ipojo.manipulator.spi.provider.CompositeModuleProvider;
import org.apache.felix.ipojo.manipulator.spi.provider.CoreModuleProvider;
import org.apache.felix.ipojo.manipulator.spi.provider.DefaultModuleProvider;
import org.apache.felix.ipojo.manipulator.visitor.check.CheckFieldConsistencyVisitor;
import org.apache.felix.ipojo.manipulator.visitor.writer.ManipulatedResourcesWriter;
import org.apache.felix.ipojo.online.manipulator.BridgeClassLoader;
import org.apache.felix.ipojo.online.manipulator.BundleAwareJarFileResourceStore;
import org.apache.felix.ipojo.online.manipulator.Files;
import org.apache.felix.ipojo.online.manipulator.SystemLogService;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@Component(publicFactory=false, immediate=true)
@Provides(specifications={URLStreamHandlerService.class}, properties={@StaticServiceProperty(name="url.handler.protocol", value="ipojo", type="java.lang.String")})
@Instantiate
public class IPOJOURLHandler
extends AbstractURLStreamHandlerService
implements Pojo {
    InstanceManager __IM;
    public static final String IPOJO_SCHEME = "ipojo:";
    private boolean __Fm_context;
    private final BundleContext m_context;
    private boolean __Fm_temp;
    private final File m_temp;
    private boolean __Fm_modules;
    private List<Module> m_modules;
    private boolean __Flogger;
    private LogService logger;
    boolean __MbindModule$org_apache_felix_ipojo_manipulator_spi_Module;
    boolean __MunbindModule$org_apache_felix_ipojo_manipulator_spi_Module;
    boolean __Mstop;
    boolean __MopenConnection$java_net_URL;
    boolean __MremoveScheme$java_net_URL;
    boolean __McreateVisitor$org_apache_felix_ipojo_manipulator_ResourceStore$org_apache_felix_ipojo_manipulator_Reporter;
    boolean __McreateModuleProvider;
    boolean __MfindMetadata$java_util_jar_JarFile;

    BundleContext __getm_context() {
        if (!this.__Fm_context) {
            return this.m_context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "m_context");
    }

    void __setm_context(BundleContext bundleContext) {
        if (!this.__Fm_context) {
            return;
        }
        this.__IM.onSet((Object)this, "m_context", (Object)bundleContext);
    }

    File __getm_temp() {
        if (!this.__Fm_temp) {
            return this.m_temp;
        }
        return (File)this.__IM.onGet((Object)this, "m_temp");
    }

    void __setm_temp(File file) {
        if (!this.__Fm_temp) {
            return;
        }
        this.__IM.onSet((Object)this, "m_temp", (Object)file);
    }

    List __getm_modules() {
        if (!this.__Fm_modules) {
            return this.m_modules;
        }
        return (List)this.__IM.onGet((Object)this, "m_modules");
    }

    void __setm_modules(List list) {
        if (!this.__Fm_modules) {
            this.m_modules = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_modules", (Object)list);
    }

    LogService __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (LogService)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(LogService logService) {
        if (!this.__Flogger) {
            this.logger = logService;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logService);
    }

    public void bindModule(Module module) {
        if (!this.__MbindModule$org_apache_felix_ipojo_manipulator_spi_Module) {
            this.__M_bindModule(module);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindModule$org_apache_felix_ipojo_manipulator_spi_Module", new Object[]{module});
            this.__M_bindModule(module);
            this.__IM.onExit((Object)this, "bindModule$org_apache_felix_ipojo_manipulator_spi_Module", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindModule$org_apache_felix_ipojo_manipulator_spi_Module", throwable);
            throw throwable;
        }
    }

    @Bind(optional=true, aggregate=true)
    private void __M_bindModule(Module module) {
        this.__getm_modules().add(module);
    }

    public void unbindModule(Module module) {
        if (!this.__MunbindModule$org_apache_felix_ipojo_manipulator_spi_Module) {
            this.__M_unbindModule(module);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindModule$org_apache_felix_ipojo_manipulator_spi_Module", new Object[]{module});
            this.__M_unbindModule(module);
            this.__IM.onExit((Object)this, "unbindModule$org_apache_felix_ipojo_manipulator_spi_Module", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindModule$org_apache_felix_ipojo_manipulator_spi_Module", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindModule(Module module) {
        this.__getm_modules().remove(module);
    }

    public IPOJOURLHandler(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private IPOJOURLHandler(InstanceManager _manager, BundleContext bundleContext) {
        this(bundleContext, bundleContext.getDataFile("temp"));
    }

    public IPOJOURLHandler(BundleContext context, File work) {
        this(null, context, work);
    }

    private IPOJOURLHandler(InstanceManager _manager, BundleContext context, File work) {
        this._setInstanceManager(_manager);
        this.__setm_modules(new ArrayList());
        this.__setlogger(new SystemLogService());
        this.m_context = context;
        this.__setm_context(this.m_context);
        this.m_temp = work;
        this.__setm_temp(this.m_temp);
        if (!this.__getm_temp().exists()) {
            this.__getm_temp().mkdir();
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        File[] files = this.__getm_temp().listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        this.__getm_temp().delete();
    }

    public URLConnection openConnection(URL url) throws IOException {
        URLConnection uRLConnection;
        if (!this.__MopenConnection$java_net_URL) {
            return this.__M_openConnection(url);
        }
        try {
            this.__IM.onEntry((Object)this, "openConnection$java_net_URL", new Object[]{url});
            uRLConnection = this.__M_openConnection(url);
            this.__IM.onExit((Object)this, "openConnection$java_net_URL", (Object)uRLConnection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "openConnection$java_net_URL", throwable);
            throw throwable;
        }
        return uRLConnection;
    }

    private URLConnection __M_openConnection(URL url) throws IOException {
        this.__getlogger().log(4, String.format("Processing URL %s", url));
        String full = this.removeScheme(url);
        String[] urls = full.split("!");
        URL bundleURL = null;
        URL metadataURL = null;
        if (urls.length == 1) {
            bundleURL = new URL(urls[0]);
        } else if (urls.length == 2) {
            bundleURL = new URL(urls[0]);
            metadataURL = new URL(urls[1]);
        } else {
            throw new MalformedURLException("The iPOJO url is not formatted correctly, ipojo:bundle_url[!metadata_url] expected");
        }
        this.__getlogger().log(4, String.format("Extracted URL %s", url));
        File original = File.createTempFile("original-", ".jar", this.__getm_temp());
        Files.dump(bundleURL.openStream(), original);
        JarFile jf = new JarFile(original);
        File metadata = null;
        if (metadataURL != null) {
            metadata = File.createTempFile("ipojo-", ".xml", this.__getm_temp());
            Files.dump(metadataURL, metadata);
        } else {
            metadata = this.findMetadata(jf);
        }
        SystemReporter reporter = new SystemReporter();
        File out = File.createTempFile("ipojo-", ".jar", this.__getm_temp());
        BundleAwareJarFileResourceStore store = new BundleAwareJarFileResourceStore(jf, out, this.__getm_context());
        CompositeMetadataProvider composite = new CompositeMetadataProvider(reporter);
        if (metadata != null) {
            FileMetadataProvider provider = new FileMetadataProvider(metadata, reporter);
            composite.addMetadataProvider(provider);
        }
        BridgeClassLoader classloader = new BridgeClassLoader(original, this.__getm_context());
        Pojoization pojoizator = new Pojoization(this.createModuleProvider());
        try {
            pojoizator.pojoization(store, composite, this.createVisitor(store, reporter), (ClassLoader)classloader);
        }
        catch (Exception e) {
            if (!pojoizator.getErrors().isEmpty()) {
                throw new IOException("Errors occurred during the manipulation : " + pojoizator.getErrors(), e);
            }
            e.printStackTrace();
            throw new IOException("Cannot manipulate the Url: " + url, e);
        }
        if (!pojoizator.getErrors().isEmpty()) {
            throw new IOException("Errors occurred during the manipulation : " + pojoizator.getErrors());
        }
        if (!pojoizator.getWarnings().isEmpty()) {
            this.__getlogger().log(2, String.format("Warnings occurred during the manipulation %s", pojoizator.getWarnings()));
        }
        this.__getlogger().log(4, String.format("Manipulation done %s", out.exists()));
        if (metadata != null) {
            metadata.delete();
        }
        original.delete();
        out.deleteOnExit();
        return out.toURI().toURL().openConnection();
    }

    private String removeScheme(URL url) {
        String string;
        if (!this.__MremoveScheme$java_net_URL) {
            return this.__M_removeScheme(url);
        }
        try {
            this.__IM.onEntry((Object)this, "removeScheme$java_net_URL", new Object[]{url});
            string = this.__M_removeScheme(url);
            this.__IM.onExit((Object)this, "removeScheme$java_net_URL", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeScheme$java_net_URL", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_removeScheme(URL url) {
        String full = url.toExternalForm();
        if (full.startsWith(IPOJO_SCHEME)) {
            full = full.substring(IPOJO_SCHEME.length());
        }
        while (full.startsWith("/")) {
            full = full.substring(1);
        }
        return full.trim();
    }

    private ManipulationVisitor createVisitor(ResourceStore store, Reporter reporter) {
        ManipulationVisitor manipulationVisitor;
        if (!this.__McreateVisitor$org_apache_felix_ipojo_manipulator_ResourceStore$org_apache_felix_ipojo_manipulator_Reporter) {
            return this.__M_createVisitor(store, reporter);
        }
        try {
            this.__IM.onEntry((Object)this, "createVisitor$org_apache_felix_ipojo_manipulator_ResourceStore$org_apache_felix_ipojo_manipulator_Reporter", new Object[]{store, reporter});
            manipulationVisitor = this.__M_createVisitor(store, reporter);
            this.__IM.onExit((Object)this, "createVisitor$org_apache_felix_ipojo_manipulator_ResourceStore$org_apache_felix_ipojo_manipulator_Reporter", (Object)manipulationVisitor);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createVisitor$org_apache_felix_ipojo_manipulator_ResourceStore$org_apache_felix_ipojo_manipulator_Reporter", throwable);
            throw throwable;
        }
        return manipulationVisitor;
    }

    private ManipulationVisitor __M_createVisitor(ResourceStore store, Reporter reporter) {
        ManipulatedResourcesWriter writer = new ManipulatedResourcesWriter();
        writer.setReporter(reporter);
        writer.setResourceStore(store);
        CheckFieldConsistencyVisitor checkFieldConsistencyVisitor = new CheckFieldConsistencyVisitor(writer);
        checkFieldConsistencyVisitor.setReporter(reporter);
        return checkFieldConsistencyVisitor;
    }

    private ModuleProvider createModuleProvider() {
        ModuleProvider moduleProvider;
        if (!this.__McreateModuleProvider) {
            return this.__M_createModuleProvider();
        }
        try {
            this.__IM.onEntry((Object)this, "createModuleProvider", new Object[0]);
            moduleProvider = this.__M_createModuleProvider();
            this.__IM.onExit((Object)this, "createModuleProvider", (Object)moduleProvider);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createModuleProvider", throwable);
            throw throwable;
        }
        return moduleProvider;
    }

    private ModuleProvider __M_createModuleProvider() {
        return new CompositeModuleProvider(new CoreModuleProvider(), new DefaultModuleProvider(this.__getm_modules()));
    }

    private File findMetadata(JarFile jar) throws IOException {
        File file;
        if (!this.__MfindMetadata$java_util_jar_JarFile) {
            return this.__M_findMetadata(jar);
        }
        try {
            this.__IM.onEntry((Object)this, "findMetadata$java_util_jar_JarFile", new Object[]{jar});
            file = this.__M_findMetadata(jar);
            this.__IM.onExit((Object)this, "findMetadata$java_util_jar_JarFile", (Object)file);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findMetadata$java_util_jar_JarFile", throwable);
            throw throwable;
        }
        return file;
    }

    private File __M_findMetadata(JarFile jar) throws IOException {
        JarEntry je = jar.getJarEntry("metadata.xml");
        if (je == null) {
            je = jar.getJarEntry("META-INF/metadata.xml");
        }
        if (je == null) {
            this.__getlogger().log(4, "Metadata file not found, use annotations only.");
            return null;
        }
        this.__getlogger().log(4, String.format("Metadata file found at  %s", je.getName()));
        File metadata = File.createTempFile("ipojo-", ".xml", this.__getm_temp());
        Files.dump(jar.getInputStream(je), metadata);
        this.__getlogger().log(4, String.format("Metadata file saved at %s", metadata));
        return metadata;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("m_context")) {
                this.__Fm_context = true;
            }
            if (set.contains("m_modules")) {
                this.__Fm_modules = true;
            }
            if (set.contains("m_temp")) {
                this.__Fm_temp = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("bindModule$org_apache_felix_ipojo_manipulator_spi_Module")) {
                this.__MbindModule$org_apache_felix_ipojo_manipulator_spi_Module = true;
            }
            if (set.contains("unbindModule$org_apache_felix_ipojo_manipulator_spi_Module")) {
                this.__MunbindModule$org_apache_felix_ipojo_manipulator_spi_Module = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("openConnection$java_net_URL")) {
                this.__MopenConnection$java_net_URL = true;
            }
            if (set.contains("removeScheme$java_net_URL")) {
                this.__MremoveScheme$java_net_URL = true;
            }
            if (set.contains("createVisitor$org_apache_felix_ipojo_manipulator_ResourceStore$org_apache_felix_ipojo_manipulator_Reporter")) {
                this.__McreateVisitor$org_apache_felix_ipojo_manipulator_ResourceStore$org_apache_felix_ipojo_manipulator_Reporter = true;
            }
            if (set.contains("createModuleProvider")) {
                this.__McreateModuleProvider = true;
            }
            if (set.contains("findMetadata$java_util_jar_JarFile")) {
                this.__MfindMetadata$java_util_jar_JarFile = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

