/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.felix.webconsole.bundleinfo.BundleInfo;
import org.apache.felix.webconsole.bundleinfo.BundleInfoProvider;
import org.apache.felix.webconsole.bundleinfo.BundleInfoType;
import org.apache.felix.webconsole.i18n.LocalizationHelper;
import org.apache.felix.webconsole.internal.core.CapabilitiesPrinter;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWiring;

public class CapabilitiesRequiredInfoProvider
implements BundleInfoProvider {
    private final LocalizationHelper localization;

    CapabilitiesRequiredInfoProvider(Bundle bundle) {
        this.localization = new LocalizationHelper(bundle);
    }

    @Override
    public String getName(Locale locale) {
        return this.localization.getResourceBundle(locale).getString("capabilities.required.info.name");
    }

    @Override
    public BundleInfo[] getBundleInfo(Bundle bundle, String webConsoleRoot, Locale locale) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new BundleInfo[0];
        }
        List requirements = wiring.getRequirements(null);
        if (requirements == null) {
            return new BundleInfo[0];
        }
        return (BundleInfo[])requirements.stream().filter(t -> CapabilitiesPrinter.EXCLUDED_NAMESPACES_PREDICATE.test(t.getNamespace())).map(r -> this.toInfo((BundleRequirement)r, wiring, webConsoleRoot, locale)).filter(Objects::nonNull).toArray(BundleInfo[]::new);
    }

    private BundleInfo toInfo(BundleRequirement requirement, BundleWiring wiring, String webConsoleRoot, Locale locale) {
        String descr = this.localization.getResourceBundle(locale).getString("capabilities.required.info.descr");
        List wires = wiring.getRequiredWires(requirement.getNamespace());
        if (wires == null) {
            return null;
        }
        Optional<Bundle> providerBundle = wires.stream().map(w -> w.getProvider().getBundle()).findFirst();
        String name = this.localization.getResourceBundle(locale).getString("capabilities.required.info.key");
        name = MessageFormat.format(name, requirement.getNamespace(), CapabilitiesPrinter.dumpDirectives(requirement.getDirectives()));
        String link = "/#";
        if (providerBundle.isPresent()) {
            name = name + MessageFormat.format(this.localization.getResourceBundle(locale).getString("capabilities.required.info.key.addition"), providerBundle.get().getSymbolicName(), providerBundle.get().getBundleId());
            if (webConsoleRoot != null) {
                link = webConsoleRoot + "/bundles/" + providerBundle.get().getBundleId();
            }
        }
        return new BundleInfo(name, link, BundleInfoType.LINK, descr);
    }
}

