/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.swf.tools.as3.EvaluatorAdapter;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.expression.Context;
import flash.tools.debugger.expression.DebuggerEvaluator;
import flash.tools.debugger.expression.ExpressionEvaluatorException;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.tools.debugger.expression.ValueExp;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.semantics.Value;

class DebuggerExpression
implements ValueExp {
    private ProgramNode m_programNode;
    private boolean m_lookupMembers = false;
    private macromedia.asc.util.Context m_cx;

    DebuggerExpression() {
    }

    public ProgramNode getProgramNode() {
        return this.m_programNode;
    }

    public void setProgramNode(ProgramNode programNode) {
        this.m_programNode = programNode;
    }

    public boolean isLookupMembers() {
        return this.m_lookupMembers;
    }

    public void setLookupMembers(boolean value) {
        this.m_lookupMembers = value;
    }

    public void setContext(macromedia.asc.util.Context cx) {
        this.m_cx = cx;
    }

    public boolean containsAssignment() {
        final boolean[] hasAssignment = new boolean[]{false};
        this.m_programNode.evaluate(this.m_cx, new EvaluatorAdapter(){

            public Value evaluate(macromedia.asc.util.Context cx, SetExpressionNode node) {
                hasAssignment[0] = true;
                return super.evaluate(cx, node);
            }
        });
        return hasAssignment[0];
    }

    public Object evaluate(Context context) throws NumberFormatException, NoSuchVariableException, PlayerFaultException, PlayerDebugException {
        assert (this.m_cx.getScopeDepth() == 0);
        this.m_cx.pushScope(new DebuggerEvaluator.ExpressionEvaluatorScope(context));
        try {
            DebuggerEvaluator.DebuggerValue value = (DebuggerEvaluator.DebuggerValue)this.m_programNode.evaluate(this.m_cx, new DebuggerEvaluator());
            if (this.isLookupMembers()) {
                Object object = context.lookupMembers(value.debuggerValue);
                return object;
            }
            Object object = value.debuggerValue;
            return object;
        }
        catch (ExpressionEvaluatorException e) {
            if (e.getCause() instanceof NumberFormatException) {
                throw (NumberFormatException)e.getCause();
            }
            if (e.getCause() instanceof NoSuchVariableException) {
                throw (NoSuchVariableException)e.getCause();
            }
            if (e.getCause() instanceof PlayerFaultException) {
                throw (PlayerFaultException)e.getCause();
            }
            if (e.getCause() instanceof PlayerDebugException) {
                throw (PlayerDebugException)e.getCause();
            }
            throw new PlayerDebugException(e.getLocalizedMessage());
        }
        finally {
            this.m_cx.popScope();
        }
    }
}

