/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.config;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.flex.compiler.common.IPathResolver;
import org.apache.flex.compiler.common.VersionInfo;
import org.apache.flex.compiler.config.ApplicationDomainTarget;
import org.apache.flex.compiler.config.CommandLineConfigurator;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.config.ConfigurationBuffer;
import org.apache.flex.compiler.config.ConfigurationPathResolver;
import org.apache.flex.compiler.config.ConfigurationValue;
import org.apache.flex.compiler.config.ICompilerProblemSettings;
import org.apache.flex.compiler.config.ICompilerSettingsConstants;
import org.apache.flex.compiler.config.RSLSettings;
import org.apache.flex.compiler.exceptions.ConfigurationException;
import org.apache.flex.compiler.filespecs.FileSpecification;
import org.apache.flex.compiler.filespecs.IFileSpecification;
import org.apache.flex.compiler.internal.config.CompilerProblemSettings;
import org.apache.flex.compiler.internal.config.DefaultsConfigurator;
import org.apache.flex.compiler.internal.config.FileConfigurator;
import org.apache.flex.compiler.internal.config.ICompilerSettings;
import org.apache.flex.compiler.internal.config.IConfigurator;
import org.apache.flex.compiler.internal.config.RuntimeSharedLibraryPathInfo;
import org.apache.flex.compiler.internal.config.SystemPropertyConfigurator;
import org.apache.flex.compiler.internal.config.TargetSettings;
import org.apache.flex.compiler.internal.config.localization.LocalizationManager;
import org.apache.flex.compiler.internal.config.localization.ResourceBundleLocalizer;
import org.apache.flex.compiler.internal.mxml.MXMLNamespaceMapping;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.projects.FlexProjectConfigurator;
import org.apache.flex.compiler.internal.projects.SourcePathManager;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.mxml.IMXMLNamespaceMapping;
import org.apache.flex.compiler.problems.ANELibraryNotAllowedProblem;
import org.apache.flex.compiler.problems.ConfigurationProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.IFlexProject;
import org.apache.flex.compiler.targets.ITarget;
import org.apache.flex.compiler.targets.ITargetSettings;
import org.apache.flex.compiler.workspaces.IWorkspace;
import org.apache.flex.swc.ISWC;
import org.apache.flex.utils.FileUtils;
import org.apache.flex.utils.FilenameNormalization;
import org.apache.flex.utils.Trace;

public class Configurator
implements ICompilerSettings,
IConfigurator,
ICompilerSettingsConstants,
Cloneable {
    private static final String EQUALS_STRING = "=";
    private static final String PLUS_EQUALS_STRING = "+=";
    private static final String COMMA_STRING = ",";
    private static final String PLUS_STRING = "+";
    private static final Set<String> excludes = new HashSet<String>();
    private ConfigurationBuffer cfgbuf;
    private Configuration configuration;
    private Class<? extends Configuration> configurationClass;
    private Map<String, Object> args;
    private Map<String, Object> more;
    private String[] extras;
    private String configurationDefaultVariable;
    private boolean keepLinkReport;
    private boolean keepSizeReport;
    private boolean keepConfigurationReport;
    private String mainDefinition;
    private boolean reportMissingLibraries;
    private boolean warnOnFlexOnlyOptionUsage;
    private List<String> loadedConfigFiles;
    private List<String> missingConfigFiles;
    private Map<String, String> tokens;
    private boolean isConfigurationDirty;
    private boolean configurationSuccess;
    private Collection<ICompilerProblem> configurationProblems;
    private boolean extrasRequireDefaultVariable;
    private IPathResolver configurationPathResolver;
    private IFlexProject project;

    public static List<File> toFiles(List<String> paths) {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : paths) {
            if (path == null) continue;
            result.add(new File(path));
        }
        return result;
    }

    public static List<File> toFileList(List<String> paths) {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : paths) {
            if (path == null) continue;
            result.add(FilenameNormalization.normalize(new File(path)));
        }
        return result;
    }

    public static String[] toPaths(File[] files) {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : files) {
            if (file == null) continue;
            result.add(file.getAbsolutePath());
        }
        return result.toArray(new String[0]);
    }

    public static List<IFileSpecification> toFileSpecifications(List<String> paths, final Workspace workspace) {
        return Lists.transform(paths, (Function)new Function<String, IFileSpecification>(){

            public IFileSpecification apply(String path) {
                return workspace.getFileSpecification(path);
            }
        });
    }

    public Configurator() {
        this(Configuration.class);
    }

    public Configurator(Class<? extends Configuration> configurationClass) {
        this.configurationClass = configurationClass;
        this.args = new LinkedHashMap<String, Object>();
        this.more = new LinkedHashMap<String, Object>();
        this.tokens = new TreeMap<String, String>();
        this.keepLinkReport = false;
        this.keepSizeReport = false;
        this.keepConfigurationReport = false;
        this.reportMissingLibraries = true;
        this.warnOnFlexOnlyOptionUsage = false;
        this.isConfigurationDirty = true;
        this.configurationDefaultVariable = "file-specs";
        this.configurationPathResolver = new ConfigurationPathResolver(System.getProperty("user.dir"));
        this.configurationProblems = new ArrayList<ICompilerProblem>();
        LocalizationManager.get().addLocalizer(new ResourceBundleLocalizer());
    }

    @Override
    public List<String> getLoadedConfigurationFiles() {
        return this.loadedConfigFiles != null ? this.loadedConfigFiles : Collections.emptyList();
    }

    @Override
    public List<String> getMissingConfigurationFiles() {
        return this.missingConfigFiles != null ? this.missingConfigFiles : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean applyToProject(IFlexProject project) {
        this.project = project;
        IWorkspace workspace = project.getWorkspace();
        boolean success = this.processConfiguration();
        workspace.startIdleState();
        try {
            if (this.configuration == null) {
                boolean bl = false;
                return bl;
            }
            if (project instanceof FlexProject) {
                FlexProject flexProject = (FlexProject)project;
                FlexProjectConfigurator.configure(flexProject, this.configuration);
                this.setupCompatibilityVersion(flexProject);
                this.setupConfigVariables(flexProject);
                this.setupLocaleSettings(flexProject);
                this.setupServices(flexProject);
                this.setupThemeFiles(flexProject);
                this.setupFlex(flexProject);
                this.setupCodegenOptions(flexProject);
            }
            project.setRuntimeSharedLibraryPath(Configurator.getRSLSettingsFromConfiguration(this.configuration));
            if (!this.setupProjectLibraries(project)) {
                success = false;
            }
            this.setupNamespaces(project);
        }
        finally {
            workspace.endIdleState(IWorkspace.NIL_COMPILATIONUNITS_TO_UPDATE);
        }
        if (!this.setupSources(project)) {
            success = false;
        }
        return success;
    }

    private void setupFlex(FlexProject flexProject) {
        flexProject.setFlex(this.configuration.isFlex());
    }

    private void setupCodegenOptions(FlexProject flexProject) {
        flexProject.setEnableInlining(this.configuration.isInliningEnabled());
    }

    private String computeQNameForTargetFile() {
        ArrayList<String> computedSourcePath = new ArrayList<String>();
        this.applySourcePathRules(computedSourcePath);
        String targetSourceFileName = this.configuration.getTargetFile();
        if (targetSourceFileName == null) {
            return null;
        }
        File targetSourceFile = FilenameNormalization.normalize(new File(this.configuration.getTargetFile()));
        for (String sourcePathEntry : computedSourcePath) {
            String computedQName = SourcePathManager.computeQName(new File(sourcePathEntry), targetSourceFile);
            if (computedQName == null) continue;
            return computedQName;
        }
        return null;
    }

    @Override
    public ITargetSettings getTargetSettings(ITarget.TargetType targetType) {
        boolean wasConfigurationDirty = this.isConfigurationDirty;
        if (!this.processConfiguration()) {
            return null;
        }
        try {
            String computedQName;
            String dumpConfigPath;
            if (!wasConfigurationDirty && this.cfgbuf.getVar("dump-config") != null && (dumpConfigPath = this.configuration.getDumpConfig()) != null && !new File(dumpConfigPath).exists()) {
                this.configuration.validateDumpConfig(this.cfgbuf);
            }
            if (this.mainDefinition != null) {
                this.configuration.setMainDefinition(this.mainDefinition);
            } else if (this.configuration.getMainDefinition() == null && targetType == ITarget.TargetType.SWF && (computedQName = this.computeQNameForTargetFile()) != null) {
                this.configuration.setMainDefinition(computedQName);
            }
            if (targetType == ITarget.TargetType.SWC) {
                this.validateSWCConfiguration();
            } else {
                Configuration.validateNoCompcOnlyOptions(this.cfgbuf);
            }
        }
        catch (ConfigurationException e) {
            this.reportConfigurationException(e);
            return null;
        }
        return new TargetSettings(this.configuration, this.project);
    }

    @Override
    public ICompilerProblemSettings getCompilerProblemSettings() {
        this.processConfiguration();
        return new CompilerProblemSettings(this.configuration);
    }

    @Override
    public Collection<ICompilerProblem> validateConfiguration(String[] args, ITarget.TargetType targetType) {
        if (args == null) {
            throw new NullPointerException("args may not be null");
        }
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        ConfigurationBuffer configurationBuffer = this.createConfigurationBuffer(this.configurationClass);
        try {
            CommandLineConfigurator.parse(configurationBuffer, null, args);
            if (targetType == ITarget.TargetType.SWF) {
                Configuration.validateNoCompcOnlyOptions(configurationBuffer);
            }
        }
        catch (ConfigurationException e) {
            ConfigurationProblem problem = new ConfigurationProblem(e);
            problems.add(problem);
        }
        return problems;
    }

    @Override
    public Collection<ICompilerProblem> getConfigurationProblems() {
        assert (this.configuration != null) : "Get the configuration problems after calling applyToProject() or getTargetSettings()";
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>(this.configurationProblems.size() + this.configuration.getConfigurationProblems().size());
        problems.addAll(this.configurationProblems);
        problems.addAll(this.configuration.getConfigurationProblems());
        return problems;
    }

    @Override
    public void setConfigurationPathResolver(IPathResolver pathResolver) {
        if (pathResolver == null) {
            throw new NullPointerException("pathResolver may not be null");
        }
        this.configurationPathResolver = pathResolver;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ConfigurationBuffer getConfigurationBuffer() {
        return this.cfgbuf;
    }

    protected Configuration createConfiguration() {
        try {
            return this.configurationClass.newInstance();
        }
        catch (Exception e) {
            this.reportConfigurationException(new ConfigurationException.CouldNotInstantiate(this.configurationClass.getName()));
            try {
                return (Configuration)Configuration.class.newInstance();
            }
            catch (Exception e2) {
                assert (false);
                return null;
            }
        }
    }

    protected void initializeConfiguration() {
        this.configuration = this.createConfiguration();
        this.cfgbuf = this.createConfigurationBuffer(this.configuration.getClass());
        assert (this.configurationPathResolver != null) : "No configuration path resolver was set.";
        this.configuration.setPathResolver(this.configurationPathResolver);
        this.configuration.setReportMissingCompilerLibraries(this.reportMissingLibraries);
        this.configuration.setWarnOnFlexOnlyOptionUsage(this.warnOnFlexOnlyOptionUsage);
    }

    protected ConfigurationBuffer createConfigurationBuffer(Class<? extends Configuration> configurationClass) {
        return new ConfigurationBuffer(configurationClass, Configuration.getAliases());
    }

    protected void setupThemeFiles(FlexProject project) {
        project.setThemeFiles(Configurator.toFileSpecifications(this.configuration.getCompilerThemeFiles(), project.getWorkspace()));
    }

    protected boolean setupProjectLibraries(IFlexProject project) {
        LinkedHashSet<File> libraries = new LinkedHashSet<File>();
        List<File> externalLibraryFiles = Configurator.toFileList(project.getCompilerExternalLibraryPath(this.configuration));
        libraries.addAll(externalLibraryFiles);
        libraries.addAll(this.configuration.getRslExcludedLibraries());
        libraries.addAll(Configurator.toFileList(this.configuration.getCompilerIncludeLibraries()));
        libraries.addAll(Configurator.toFileList(project.getCompilerLibraryPath(this.configuration)));
        project.setLibraries(new ArrayList<File>(libraries));
        return this.validateNoANEFiles(project, externalLibraryFiles);
    }

    private boolean validateNoANEFiles(IFlexProject project, List<File> externalLibraryFiles) {
        List<ISWC> libraries = project.getLibraries();
        for (ISWC library : libraries) {
            if (!library.isANE() || this.isOnExternalLibrayPath(library, externalLibraryFiles)) continue;
            this.configurationProblems.add(new ANELibraryNotAllowedProblem(library.getSWCFile().getAbsolutePath()));
            return false;
        }
        return true;
    }

    private boolean isOnExternalLibrayPath(ISWC library, List<File> externalLibraryFiles) {
        File aneFile = library.getSWCFile();
        for (File file : externalLibraryFiles) {
            if (!file.equals(aneFile)) continue;
            return true;
        }
        return false;
    }

    protected void setupCompatibilityVersion(FlexProject project) {
        int compatibilityVersion = this.configuration.getCompilerMxmlCompatibilityVersion();
        if (compatibilityVersion < 0x3000000) {
            throw new UnsupportedOperationException("Unsupported compatibility version: " + this.configuration.getCompilerCompatibilityVersionString());
        }
        project.setCompatibilityVersion(this.configuration.getCompilerMxmlMajorCompatibilityVersion(), this.configuration.getCompilerMxmlMinorCompatibilityVersion(), this.configuration.getCompilerMxmlRevisionCompatibilityVersion());
    }

    protected void setupServices(FlexProject project) {
        if (this.configuration.getCompilerServices() != null) {
            project.setServicesXMLPath(this.configuration.getCompilerServices().getPath(), this.configuration.getCompilerContextRoot());
        }
    }

    protected boolean setupSources(IFlexProject project) {
        ArrayList<String> sourcePath = new ArrayList<String>();
        this.applySourcePathRules(sourcePath);
        project.setSourcePath(Configurator.toFiles(sourcePath));
        try {
            project.setIncludeSources(Configurator.toFileList(this.configuration.getIncludeSources()));
        }
        catch (InterruptedException e) {
            assert (false) : "InterruptedException should never be thrown here";
            return false;
        }
        return true;
    }

    protected void applySourcePathRules(List<String> sourcePath) {
        String targetFileDirectory = this.configuration.getTargetFileDirectory();
        List<String> configuredSourcePath = this.configuration.getCompilerSourcePath();
        if (targetFileDirectory != null && (configuredSourcePath.isEmpty() || !configuredSourcePath.contains(targetFileDirectory) && !Configurator.isSubdirectoryOf(targetFileDirectory, configuredSourcePath))) {
            sourcePath.add(targetFileDirectory);
        }
        sourcePath.addAll(configuredSourcePath);
    }

    private static boolean isSubdirectoryOf(String path, Iterable<String> directories) {
        File pathFile = FileUtils.canonicalFile(new File(path));
        block0: for (String directoryName : directories) {
            File dirFile = FileUtils.canonicalFile(new File(directoryName));
            long dirFilenameLength = dirFile.getAbsolutePath().length();
            for (File parentFile = pathFile.getParentFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
                if (dirFile.equals(parentFile)) {
                    return true;
                }
                if (dirFilenameLength > (long)parentFile.getAbsolutePath().length()) continue block0;
            }
        }
        return false;
    }

    protected void setupConfigVariables(IFlexProject project) {
        Map<String, String> compilerDefine = this.configuration.getCompilerDefine();
        if (compilerDefine != null) {
            project.setDefineDirectives(compilerDefine);
        }
    }

    protected void setupNamespaces(IFlexProject project) {
        List<MXMLNamespaceMapping> configManifestMappings = project.getCompilerNamespacesManifestMappings(this.configuration);
        if (configManifestMappings != null) {
            project.setNamespaceMappings(configManifestMappings);
        }
    }

    protected void setupLocaleSettings(IFlexProject project) {
        project.setLocales(this.configuration.getCompilerLocales());
        project.setLocaleDependentResources(this.configuration.getLocaleDependentSources());
    }

    public static List<RSLSettings> getRSLSettingsFromConfiguration(Configuration configuration) {
        List<RuntimeSharedLibraryPathInfo> infoList = configuration.getRslPathInfo();
        if (infoList == null || infoList.size() == 0) {
            return Collections.emptyList();
        }
        boolean verifyDigests = configuration.getVerifyDigests();
        ArrayList<RSLSettings> rslSettingsList = new ArrayList<RSLSettings>(infoList.size());
        for (RuntimeSharedLibraryPathInfo info : infoList) {
            RSLSettings rslSettings = new RSLSettings(info.getSWCFile());
            List<String> rslURLs = info.getRSLURLs();
            List<String> policyFileURLs = info.getPolicyFileURLs();
            int n = info.getRSLURLs().size();
            for (int i = 0; i < n; ++i) {
                rslSettings.addRSLURLAndPolicyFileURL(rslURLs.get(i), policyFileURLs.get(i));
            }
            rslSettings.setVerifyDigest(verifyDigests);
            String swcPath = info.getSWCFile().getPath();
            rslSettings.setApplicationDomain(configuration.getApplicationDomain(swcPath));
            rslSettings.setForceLoad(configuration.getForceRsls().contains(swcPath));
            rslSettingsList.add(rslSettings);
        }
        return rslSettingsList;
    }

    protected boolean processConfiguration() {
        boolean success = true;
        if (this.isConfigurationDirty) {
            this.configurationProblems.clear();
            try {
                success = this.processConfiguration(this.getOptions(this.args, this.more, this.processExtras(this.extras)));
            }
            catch (ConfigurationException e) {
                this.reportConfigurationException(e);
                success = false;
            }
        } else {
            success = this.configurationSuccess;
        }
        this.isConfigurationDirty = false;
        this.configurationSuccess = success;
        return success;
    }

    protected boolean processConfiguration(String[] argsArray) {
        this.initializeConfiguration();
        boolean success = true;
        try {
            this.loadDefaults(this.cfgbuf);
            this.byPassConfigurationsRequiringFlexSDK();
            SystemPropertyConfigurator.load(this.cfgbuf, "flex");
            CommandLineConfigurator.parse(this.cfgbuf, this.configurationDefaultVariable, argsArray);
            this.overrideDefaults();
            if (this.cfgbuf.getVar("version") != null) {
                return false;
            }
            List<ConfigurationValue> helpVar = this.cfgbuf.getVar("help");
            if (helpVar != null) {
                return false;
            }
            if (!this.loadConfig()) {
                success = false;
            }
            if (!this.loadProjectConfig()) {
                success = false;
            }
            this.cfgbuf.clearSourceVars("command line");
            CommandLineConfigurator.parse(this.cfgbuf, this.configurationDefaultVariable, argsArray);
            if (!this.cfgbuf.commit(this.configuration, this.configurationProblems)) {
                success = false;
            }
            this.configuration.validate(this.cfgbuf);
        }
        catch (ConfigurationException e) {
            this.reportConfigurationException(e);
            success = false;
        }
        return success;
    }

    protected void loadDefaults(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        DefaultsConfigurator.loadDefaults(cfgbuf);
    }

    protected void validateSWCConfiguration() throws ConfigurationException {
        this.validateSWCInputs();
        if (this.configuration.getIncludeInheritanceDependenciesOnly() && this.configuration.getIncludeClasses().size() == 0) {
            throw new ConfigurationException.MissingIncludeClasses();
        }
    }

    protected void validateSWCInputs() throws ConfigurationException {
        if (this.configuration.getIncludeSources().isEmpty() && this.configuration.getIncludeClasses().isEmpty() && this.configuration.getIncludeNamespaces().isEmpty() && (this.configuration.getCompilerIncludeLibraries() == null || this.configuration.getCompilerIncludeLibraries().size() == 0) && this.configuration.getIncludeFiles().isEmpty() && this.configuration.getIncludeResourceBundles().isEmpty()) {
            throw new ConfigurationException.NoSwcInputs(null, null, -1);
        }
    }

    protected void byPassConfigurationsRequiringFlexSDK() throws ConfigurationException {
        if (System.getProperty("flexlib") == null && System.getProperty("application.home") == null) {
            this.cfgbuf.clearVar("load-config", null, -1);
            this.cfgbuf.clearVar("compiler.theme", null, -1);
        }
    }

    protected void overrideDefaults() throws ConfigurationException {
        String buildNumber;
        String configname;
        String framework;
        String flexlib = this.cfgbuf.getToken("flexlib");
        if (flexlib == null) {
            String appHome = System.getProperty("application.home");
            if (appHome == null) {
                this.cfgbuf.setToken("flexlib", ".");
            } else {
                this.cfgbuf.setToken("flexlib", appHome + File.separator + "frameworks");
            }
        }
        if ((framework = this.cfgbuf.getToken("framework")) == null) {
            this.cfgbuf.setToken("framework", "halo");
        }
        if ((configname = this.cfgbuf.getToken("configname")) == null) {
            this.cfgbuf.setToken("configname", "flex");
        }
        if ((buildNumber = this.cfgbuf.getToken("build.number")) == null) {
            buildNumber = "".equals(VersionInfo.getBuild()) ? "workspace" : VersionInfo.getBuild();
            this.cfgbuf.setToken("build.number", buildNumber);
        }
    }

    protected boolean loadConfig() {
        boolean success = true;
        try {
            List<ConfigurationValue> configs = this.cfgbuf.peekConfigurationVar("load-config");
            if (configs != null) {
                for (ConfigurationValue cv : configs) {
                    for (String path : cv.getArgs()) {
                        File configFile = this.configurationPathResolver.resolve(path);
                        if (!configFile.exists()) {
                            success = false;
                            if (this.missingConfigFiles == null) {
                                this.missingConfigFiles = new ArrayList<String>();
                            }
                            this.missingConfigFiles.add(path);
                            continue;
                        }
                        if (this.loadConfigFromFile(this.cfgbuf, configFile, new File(configFile.getPath()).getParent(), "flex-config", false)) continue;
                        success = false;
                    }
                }
            }
        }
        catch (ConfigurationException e) {
            this.reportConfigurationException(e);
            success = false;
        }
        return success;
    }

    protected final boolean loadConfigFromFile(ConfigurationBuffer buffer, File fileSpec, String context, String rootElement, boolean ignoreUnknownItems) {
        boolean success = true;
        try {
            FileConfigurator.load(buffer, new FileSpecification(fileSpec.getAbsolutePath()), context, rootElement, ignoreUnknownItems);
        }
        catch (ConfigurationException e) {
            this.reportConfigurationException(e);
            success = false;
        }
        if (this.loadedConfigFiles == null) {
            this.loadedConfigFiles = new ArrayList<String>();
        }
        this.loadedConfigFiles.add(fileSpec.getPath());
        return success;
    }

    protected void reportConfigurationException(ConfigurationException e) {
        ConfigurationProblem problem = new ConfigurationProblem(e);
        this.configurationProblems.add(problem);
    }

    protected boolean loadProjectConfig() {
        String project;
        File projectFile;
        String val;
        int index;
        ConfigurationValue cv;
        boolean success = true;
        List<ConfigurationValue> fileValues = this.cfgbuf.getVar("file-specs");
        if (fileValues != null && fileValues.size() > 0 && (cv = fileValues.get(fileValues.size() - 1)).getArgs().size() > 0 && (index = (val = cv.getArgs().get(cv.getArgs().size() - 1)).lastIndexOf(46)) != -1 && (projectFile = this.configurationPathResolver.resolve(project = val.substring(0, index) + "-config.xml")).exists() && !this.loadConfigFromFile(this.cfgbuf, projectFile, new File(project).getParent(), "flex-config", false)) {
            success = false;
        }
        return success;
    }

    protected String[] getOptions(Map<String, Object> args, Map<String, Object> more, String[] extras) {
        Object v;
        String k;
        Map m;
        Object value;
        String key;
        ArrayList<String> buffer = new ArrayList<String>();
        for (Map.Entry<String, String> tokenEntry : this.tokens.entrySet()) {
            buffer.add(PLUS_STRING + tokenEntry.getKey() + EQUALS_STRING + tokenEntry.getValue());
        }
        for (Map.Entry<String, Object> arg : args.entrySet()) {
            key = arg.getKey();
            value = arg.getValue();
            if (value instanceof Boolean) {
                buffer.add(key + EQUALS_STRING + value);
                continue;
            }
            if (value instanceof Number) {
                buffer.add(key);
                buffer.add(value.toString());
                continue;
            }
            if ("--compiler.context-root".equals(key) && value instanceof String) {
                buffer.add(key);
                buffer.add((String)value);
                continue;
            }
            if (value instanceof String) {
                if (!"".equals(value)) {
                    buffer.add(key);
                    buffer.add((String)value);
                    continue;
                }
                buffer.add(key + EQUALS_STRING);
                continue;
            }
            if (value instanceof File) {
                String p = ((File)value).getPath();
                if (!"".equals(p)) {
                    buffer.add(key);
                    buffer.add(p);
                    continue;
                }
                buffer.add(key + EQUALS_STRING);
                continue;
            }
            if (value instanceof Date) {
                buffer.add(key);
                buffer.add(value.toString());
                continue;
            }
            if (value instanceof MXMLNamespaceMappingList) {
                this.addNamespaceMappingsToBuffer(buffer, (MXMLNamespaceMappingList)value, false);
                continue;
            }
            if (value instanceof RSLSettingsList) {
                this.addRSLSettingsToBuffer(buffer, (RSLSettingsList)value, false);
                continue;
            }
            if (value instanceof CompilerDefinitionMap) {
                CompilerDefinitionMap defs = (CompilerDefinitionMap)value;
                for (Map.Entry entry : defs.entrySet()) {
                    String name = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    if (name.length() == 0) {
                        name = "\"\"";
                    }
                    if (val.length() == 0) {
                        val = "\"\"";
                    }
                    buffer.add("--compiler.define+=" + name + COMMA_STRING + val);
                }
                continue;
            }
            if (value instanceof Map) {
                m = (Map)value;
                for (Map.Entry entry : m.entrySet()) {
                    k = (String)entry.getKey();
                    v = entry.getValue();
                    if (v instanceof String) {
                        buffer.add(key);
                        buffer.add(k);
                        buffer.add((String)v);
                        continue;
                    }
                    if (v instanceof File) {
                        buffer.add(key);
                        buffer.add(k);
                        buffer.add(((File)v).getPath());
                        continue;
                    }
                    if (v instanceof Collection) {
                        buffer.add(key);
                        buffer.add(k);
                        Collection list = (Collection)v;
                        for (Object next : list) {
                            if (next == null) continue;
                            buffer.add(next.toString());
                        }
                        continue;
                    }
                    if (v != null) assert (false);
                }
                continue;
            }
            if (value instanceof int[]) {
                int[] a = (int[])value;
                buffer.add(key);
                buffer.add(String.valueOf(a[0]));
                buffer.add(String.valueOf(a[1]));
                continue;
            }
            if (value instanceof Collection) {
                LinkedList list = new LinkedList((Collection)args.get(key));
                int length = list.size();
                if (length > 0) {
                    buffer.add(key);
                } else if (!"--load-config".equals(key)) {
                    buffer.add(key + EQUALS_STRING);
                }
                for (Object obj : list) {
                    if (obj instanceof String) {
                        buffer.add((String)obj);
                        continue;
                    }
                    if (!(obj instanceof File)) continue;
                    buffer.add(((File)obj).getPath());
                }
                continue;
            }
            if (value != null) assert (false);
        }
        for (Map.Entry<String, Object> moreEntry : more.entrySet()) {
            key = moreEntry.getKey();
            value = moreEntry.getValue();
            if (value instanceof Collection) {
                buffer.add(key + PLUS_EQUALS_STRING + this.toCommaSeparatedString((Collection)value));
                continue;
            }
            if (value instanceof Map) {
                m = (Map)value;
                for (Map.Entry entry : m.entrySet()) {
                    k = (String)entry.getKey();
                    v = entry.getValue();
                    if (v instanceof Collection) {
                        buffer.add(key + PLUS_EQUALS_STRING + k + COMMA_STRING + this.toCommaSeparatedString((Collection)v));
                        continue;
                    }
                    if (v != null) assert (false);
                }
                continue;
            }
            if (value instanceof MXMLNamespaceMappingList) {
                this.addNamespaceMappingsToBuffer(buffer, (MXMLNamespaceMappingList)value, true);
                continue;
            }
            if (value instanceof RSLSettingsList) {
                this.addRSLSettingsToBuffer(buffer, (RSLSettingsList)value, true);
                continue;
            }
            if (value != null) assert (false);
        }
        if (extras != null && extras.length > 0) {
            int length;
            int n = length = extras == null ? 0 : extras.length;
            for (int i = 0; i < length; ++i) {
                if (extras[i] == null) continue;
                buffer.add(extras[i]);
            }
        }
        String[] options = new String[buffer.size()];
        buffer.toArray(options);
        if (Trace.config) {
            Trace.trace("Configurator: options = " + buffer.toString());
        }
        return options;
    }

    protected String[] processExtras(String[] extraOptions) throws ConfigurationException {
        if (extraOptions == null || this.extrasRequireDefaultVariable) {
            return extraOptions;
        }
        ArrayList<String> newArgs = new ArrayList<String>();
        ConfigurationBuffer extrasBuffer = this.createConfigurationBuffer(this.configurationClass);
        CommandLineConfigurator.parse(extrasBuffer, null, extraOptions);
        List<Object[]> positions = extrasBuffer.getPositions();
        int length = positions.size();
        for (int i = 0; i < length; ++i) {
            Object[] a = positions.get(i);
            String var = (String)a[0];
            if ("link-report".equals(var)) {
                this.keepLinkReport(true);
            } else if ("compiler.debug".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    String debugPassword = extrasBuffer.peekSimpleConfigurationVar("debug-password");
                    if ("true".equals(value)) {
                        this.enableDebugging(true, debugPassword);
                    } else if ("false".equals(value)) {
                        this.enableDebugging(false, debugPassword);
                    }
                }
                catch (ConfigurationException value) {}
            } else if ("compiler.verbose-stacktraces".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    if ("true".equals(value)) {
                        this.enableVerboseStacktraces(true);
                    } else if ("false".equals(value)) {
                        this.enableVerboseStacktraces(false);
                    }
                }
                catch (ConfigurationException value) {}
            } else if ("compiler.accessible".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    if ("true".equals(value)) {
                        this.enableAccessibility(true);
                    } else if ("false".equals(value)) {
                        this.enableAccessibility(false);
                    }
                }
                catch (ConfigurationException value) {}
            } else if ("compiler.strict".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    if ("true".equals(value)) {
                        this.enableStrictChecking(true);
                    } else if ("false".equals(value)) {
                        this.enableStrictChecking(false);
                    }
                }
                catch (ConfigurationException value) {}
            } else if ("output".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    this.setOutput(new File(value));
                }
                catch (ConfigurationException value) {}
            } else if ("size-report".equals(var)) {
                this.keepSizeReport(true);
            } else if ("warnings".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    if ("true".equals(value)) {
                        this.showActionScriptWarnings(true);
                        this.showBindingWarnings(true);
                        this.showDeprecationWarnings(true);
                        this.showUnusedTypeSelectorWarnings(true);
                    } else if ("false".equals(value)) {
                        this.showActionScriptWarnings(false);
                        this.showBindingWarnings(false);
                        this.showDeprecationWarnings(false);
                        this.showUnusedTypeSelectorWarnings(false);
                    }
                }
                catch (ConfigurationException value) {}
            } else if ("compiler.show-actionscript-warnings".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    if ("true".equals(value)) {
                        this.showActionScriptWarnings(true);
                    } else if ("false".equals(value)) {
                        this.showActionScriptWarnings(false);
                    }
                }
                catch (ConfigurationException value) {}
            } else if ("compiler.show-deprecation-warnings".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    if ("true".equals(value)) {
                        this.showDeprecationWarnings(true);
                    } else if ("false".equals(value)) {
                        this.showDeprecationWarnings(false);
                    }
                }
                catch (ConfigurationException value) {}
            } else if ("compiler.show-binding-warnings".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    if ("true".equals(value)) {
                        this.showBindingWarnings(true);
                    } else if ("false".equals(value)) {
                        this.showBindingWarnings(false);
                    }
                }
                catch (ConfigurationException value) {}
            } else if ("compiler.show-unused-type-selector-warnings".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    if ("true".equals(value)) {
                        this.showUnusedTypeSelectorWarnings(true);
                    } else if ("false".equals(value)) {
                        this.showUnusedTypeSelectorWarnings(false);
                    }
                }
                catch (ConfigurationException value) {}
            } else if ("compiler.show-multiple-definition-warnings".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    if ("true".equals(value)) {
                        this.showMultipleDefinitionWarnings(true);
                    } else if ("false".equals(value)) {
                        this.showMultipleDefinitionWarnings(false);
                    }
                }
                catch (ConfigurationException value) {}
            } else if ("flex".equals(var)) {
                try {
                    String value = extrasBuffer.peekSimpleConfigurationVar(var);
                    if ("true".equals(value)) {
                        this.setFlex(true);
                    } else if ("false".equals(value)) {
                        this.setFlex(false);
                    }
                }
                catch (ConfigurationException value) {
                    // empty catch block
                }
            }
            if (excludes.contains(var)) continue;
            int iStart = (Integer)a[1];
            int iEnd = (Integer)a[2];
            for (int j = iStart; j < iEnd; ++j) {
                newArgs.add(extraOptions[j]);
            }
        }
        extraOptions = new String[newArgs.size()];
        newArgs.toArray(extraOptions);
        return extraOptions;
    }

    private void addNamespaceMappingsToBuffer(ArrayList<String> buffer, MXMLNamespaceMappingList valueList, boolean append) {
        if (valueList.isEmpty()) {
            StringBuilder sb = new StringBuilder("--compiler.namespaces.namespace");
            sb.append(append ? PLUS_EQUALS_STRING : EQUALS_STRING);
            buffer.add(sb.toString());
            return;
        }
        for (IMXMLNamespaceMapping value : valueList) {
            StringBuilder sb = new StringBuilder("--compiler.namespaces.namespace");
            sb.append(append ? PLUS_EQUALS_STRING : EQUALS_STRING);
            sb.append(value.getURI());
            sb.append(COMMA_STRING);
            sb.append(value.getManifestFileName());
            buffer.add(sb.toString());
        }
    }

    private void addRSLSettingsToBuffer(ArrayList<String> buffer, RSLSettingsList valueList, boolean append) {
        if (valueList.isEmpty()) {
            StringBuilder sb = new StringBuilder("--runtime-shared-library-path");
            sb.append(append ? PLUS_EQUALS_STRING : EQUALS_STRING);
            buffer.add(sb.toString());
            return;
        }
        for (RSLSettings settings : valueList) {
            StringBuilder sb = new StringBuilder("--runtime-shared-library-path");
            sb.append(append ? PLUS_EQUALS_STRING : EQUALS_STRING);
            sb.append(settings.getLibraryFile().getPath());
            for (RSLSettings.RSLAndPolicyFileURLPair urls : settings.getRSLURLs()) {
                sb.append(COMMA_STRING);
                sb.append(urls.getRSLURL());
                sb.append(COMMA_STRING);
                sb.append(urls.getPolicyFileURL());
            }
            buffer.add(sb.toString());
            if (settings.getApplicationDomain() != ApplicationDomainTarget.DEFAULT) {
                sb = new StringBuilder("--runtime-shared-library-settings.application-domain");
                sb.append(append ? PLUS_EQUALS_STRING : EQUALS_STRING);
                sb.append(settings.getLibraryFile().getPath());
                sb.append(COMMA_STRING);
                sb.append(settings.getApplicationDomain().getApplicationDomainValue());
                buffer.add(sb.toString());
            }
            if (!settings.isForceLoad()) continue;
            sb = new StringBuilder("--runtime-shared-library-settings.force-rsls");
            sb.append(append ? PLUS_EQUALS_STRING : EQUALS_STRING);
            sb.append(settings.getLibraryFile().getPath());
            buffer.add(sb.toString());
        }
    }

    @Override
    public void enableAccessibility(boolean b) {
        this.args.put("--compiler.accessible", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setActionScriptFileEncoding(String encoding) {
        this.args.put("--compiler.actionscript-file-encoding", encoding);
        this.isConfigurationDirty = true;
    }

    @Override
    public void allowSourcePathOverlap(boolean b) {
        this.args.put("--compiler.allow-source-path-overlap", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setContextRoot(String path) {
        this.args.put("--compiler.context-root", path);
        this.isConfigurationDirty = true;
    }

    @Override
    public void enableDebugging(boolean b, String debugPassword) {
        this.args.put("--compiler.debug", b ? Boolean.TRUE : Boolean.FALSE);
        this.args.put("--debug-password", debugPassword);
        this.isConfigurationDirty = true;
    }

    public void setStaticLinkRuntimeSharedLibraries(boolean b) {
        this.args.put("--static-link-runtime-shared-libraries", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    public void setDefaultCSS(File url) {
        this.args.put("--compiler.defaults-css-url", url);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setExternalLibraryPath(Collection<File> paths) {
        this.removeNativeJSLibrariesIfNeeded(paths);
        this.args.put("--compiler.external-library-path", paths);
        this.more.remove("--compiler.external-library-path");
        this.isConfigurationDirty = true;
    }

    private void removeNativeJSLibrariesIfNeeded(Collection<File> paths) {
        Iterator<File> fileIterator = paths.iterator();
        while (fileIterator.hasNext()) {
            File file = fileIterator.next();
            boolean isNativeJS = file.getAbsolutePath().contains("js/libs");
            boolean excludeNativeJS = false;
            try {
                excludeNativeJS = this.cfgbuf.peekSimpleConfigurationVar("exclude-native-js-libraries").equals(Boolean.TRUE.toString());
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            if (!isNativeJS || !excludeNativeJS) continue;
            fileIterator.remove();
        }
    }

    @Override
    public void addExternalLibraryPath(Collection<File> paths) {
        this.removeNativeJSLibrariesIfNeeded(paths);
        this.addFiles("--compiler.external-library-path", paths);
        this.isConfigurationDirty = true;
    }

    public void setASMetadataNames(String[] md) {
        this.args.put("--compiler.keep-as3-metadata", md);
        this.more.remove("--compiler.keep-as3-metadata");
        this.isConfigurationDirty = true;
    }

    public void addASMetadataNames(Collection<String> md) {
        this.addStrings("--compiler.keep-as3-metadata", md);
        this.isConfigurationDirty = true;
    }

    public void keepAllTypeSelectors(boolean b) {
        this.args.put("--compiler.keep-all-type-selectors", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    public void keepLinkReport(boolean b) {
        this.keepLinkReport = b;
        this.isConfigurationDirty = true;
    }

    public boolean keepLinkReport() {
        return this.keepLinkReport;
    }

    public void keepSizeReport(boolean b) {
        this.keepSizeReport = b;
        this.isConfigurationDirty = true;
    }

    public boolean keepSizeReport() {
        return this.keepSizeReport;
    }

    public void keepConfigurationReport(boolean b) {
        this.keepConfigurationReport = b;
        this.isConfigurationDirty = true;
    }

    public boolean keepConfigurationReport() {
        return this.keepConfigurationReport;
    }

    public void reportMissingsLibraries(boolean b) {
        this.reportMissingLibraries = b;
        this.isConfigurationDirty = true;
    }

    public void setWarnOnFlexOnlyOptionUsage(boolean value) {
        this.warnOnFlexOnlyOptionUsage = value;
        this.isConfigurationDirty = true;
    }

    @Override
    public void setIncludeLibraries(Collection<File> libraries) {
        this.args.put("--compiler.include-libraries", libraries);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setIncludeResourceBundles(Collection<String> bundles) {
        this.args.put("--include-resource-bundles", bundles);
        this.isConfigurationDirty = true;
    }

    public void addIncludeResourceBundles(Collection<String> bundles) {
        this.addStrings("--include-resource-bundles", bundles);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setLibraryPath(Collection<File> paths) {
        this.removeNativeJSLibrariesIfNeeded(paths);
        this.args.put("--compiler.library-path", paths);
        this.more.remove("--compiler.library-path");
        this.isConfigurationDirty = true;
    }

    public void addLibraryPath(Collection<File> paths) {
        this.removeNativeJSLibrariesIfNeeded(paths);
        this.addFiles("--compiler.library-path", paths);
        this.isConfigurationDirty = true;
    }

    public void setLocale(String[] locales) {
        this.args.put("--compiler.locale", locales);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setNamespaceMappings(List<? extends IMXMLNamespaceMapping> namespaceMappings) {
        this.args.put("--compiler.namespaces.namespace", namespaceMappings != null ? new MXMLNamespaceMappingList((Collection<? extends IMXMLNamespaceMapping>)namespaceMappings) : null);
        this.more.remove("--compiler.namespaces.namespace");
        this.isConfigurationDirty = true;
    }

    @Override
    public void addNamespaceMappings(Collection<IMXMLNamespaceMapping> namespaceMappings) {
        MXMLNamespaceMappingList currentSettings = (MXMLNamespaceMappingList)this.more.get("--compiler.namespaces.namespace");
        if (currentSettings == null) {
            currentSettings = new MXMLNamespaceMappingList(namespaceMappings.size());
        }
        currentSettings.addAll(namespaceMappings);
        this.isConfigurationDirty = true;
    }

    @Override
    public void optimize(boolean b) {
        this.args.put("--compiler.optimize", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void compress(boolean b) {
        this.args.put("--compiler.compress", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setServicesXMLPath(String path, String contextRoot) {
        if (path == null || contextRoot == null) {
            throw new NullPointerException("path and contenxtRoot may not be null.");
        }
        this.args.put("--compiler.services", new ServicesContextRoot(path, contextRoot));
        this.isConfigurationDirty = true;
    }

    @Override
    public void showActionScriptWarnings(boolean b) {
        this.args.put("--compiler.show-actionscript-warnings", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void showBindingWarnings(boolean b) {
        this.args.put("--compiler.show-binding-warnings", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void showDeprecationWarnings(boolean b) {
        this.args.put("--compiler.show-deprecation-warnings", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void showUnusedTypeSelectorWarnings(boolean b) {
        this.args.put("--compiler.show-unused-type-selector-warnings", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void showMultipleDefinitionWarnings(boolean b) {
        this.args.put("--show-multiple-definition-warnings", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setSourcePath(List<File> paths) {
        this.args.put("--compiler.source-path", paths);
        this.more.remove("--compiler.source-path");
        this.isConfigurationDirty = true;
    }

    @Override
    public void addSourcePath(Collection<File> paths) {
        this.addFiles("--compiler.source-path", paths);
        this.isConfigurationDirty = true;
    }

    @Override
    public void enableStrictChecking(boolean b) {
        this.args.put("--compiler.strict", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setTheme(List<File> files) {
        this.args.put("--compiler.theme", files);
        this.more.remove("--compiler.theme");
        this.isConfigurationDirty = true;
    }

    @Override
    public void addTheme(List<File> files) {
        this.addFiles("--compiler.theme", files);
        this.isConfigurationDirty = true;
    }

    @Override
    public void useResourceBundleMetaData(boolean b) {
        this.args.put("--compiler.use-resource-bundle-metadata", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    public void enableVerboseStacktraces(boolean b) {
        this.args.put("--compiler.verbose-stacktraces", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void removeUnusedRuntimeSharedLibraryPaths(boolean b) {
        this.args.put("--remove-unused-rsls", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void checkActionScriptWarning(int warningCode, boolean b) {
        String key = null;
        switch (warningCode) {
            case 1044: {
                key = "--compiler.warn-array-tostring-changes";
                break;
            }
            case 1100: {
                key = "--compiler.warn-assignment-within-conditional";
                break;
            }
            case 1112: {
                key = "--compiler.warn-bad-array-cast";
                break;
            }
            case 3590: {
                key = "--compiler.warn-bad-bool-assignment";
                break;
            }
            case 3575: {
                key = "--compiler.warn-bad-date-cast";
                break;
            }
            case 3594: {
                key = "--compiler.warn-bad-es3-type-method";
                break;
            }
            case 3592: {
                key = "--compiler.warn-bad-es3-type-prop";
                break;
            }
            case 1098: {
                key = "--compiler.warn-bad-nan-comparison";
                break;
            }
            case 1102: {
                key = "--compiler.warn-bad-null-assignment";
                break;
            }
            case 1096: {
                key = "--compiler.warn-bad-null-comparison";
                break;
            }
            case 1012: {
                key = "--compiler.warn-bad-undefined-comparison";
                break;
            }
            case 1034: {
                key = "--compiler.warn-boolean-constructor-with-no-args";
                break;
            }
            case 1066: {
                key = "--compiler.warn-changes-in-resolve";
                break;
            }
            case 1072: {
                key = "--compiler.warn-class-is-sealed";
                break;
            }
            case 1110: {
                key = "--compiler.warn-const-not-initialized";
                break;
            }
            case 1030: {
                key = "--compiler.warn-constructor-returns-value";
                break;
            }
            case 1090: {
                key = "--compiler.warn-deprecated-event-handler-error";
                break;
            }
            case 1060: {
                key = "--compiler.warn-deprecated-function-error";
                break;
            }
            case 1058: {
                key = "--compiler.warn-deprecated-property-error";
                break;
            }
            case 3583: {
                key = "--compiler.warn-duplicate-argument-names";
                break;
            }
            case 3596: {
                key = "--compiler.warn-duplicate-variable-def";
                break;
            }
            case 1086: {
                key = "--compiler.warn-for-var-in-changes";
                break;
            }
            case 3581: {
                key = "--compiler.warn-import-hides-class";
                break;
            }
            case 3555: {
                key = "--compiler.warn-instance-of-changes";
                break;
            }
            case 1088: {
                key = "--compiler.warn-internal-error";
                break;
            }
            case 1070: {
                key = "--compiler.warn-level-not-supported";
                break;
            }
            case 1084: {
                key = "--compiler.warn-missing-namespace-decl";
                break;
            }
            case 1092: {
                key = "--compiler.warn-negative-uint-literal";
                break;
            }
            case 1104: {
                key = "--compiler.warn-no-constructor";
                break;
            }
            case 1114: {
                key = "--compiler.warn-no-explicit-super-call-in-constructor";
                break;
            }
            case 1008: {
                key = "--compiler.warn-no-type-decl";
                break;
            }
            case 1038: {
                key = "--compiler.warn-number-from-string-changes";
                break;
            }
            case 1082: {
                key = "--compiler.warn-scoping-change-in-this";
                break;
            }
            case 3551: {
                key = "--compiler.warn-slow-text-field-addition";
                break;
            }
            case 3553: {
                key = "--compiler.warn-unlikely-function-value";
                break;
            }
            case 3573: {
                key = "--compiler.warn-xml-class-has-changed";
            }
        }
        if (key != null) {
            this.args.put(key, b ? Boolean.TRUE : Boolean.FALSE);
            this.isConfigurationDirty = true;
        }
    }

    public void setDefaultBackgroundColor(int color) {
        this.args.put("--default-background-color", new Integer(color));
        this.isConfigurationDirty = true;
    }

    public void setDefaultFrameRate(int rate) {
        this.args.put("--default-frame-rate", new Integer(rate));
        this.isConfigurationDirty = true;
    }

    public void setDefaultScriptLimits(int maxRecursionDepth, int maxExecutionTime) {
        this.args.put("--default-script-limits", new int[]{maxRecursionDepth, maxExecutionTime});
        this.isConfigurationDirty = true;
    }

    public void setDefaultSize(int width, int height) {
        this.args.put("--default-size", new int[]{width, height});
        this.isConfigurationDirty = true;
    }

    @Override
    public void setExterns(Collection<String> definitions) {
        this.args.put("--externs", definitions);
        this.more.remove("--externs");
        this.isConfigurationDirty = true;
    }

    public void addExterns(Collection<String> definitions) {
        this.addStrings("--externs", definitions);
        this.isConfigurationDirty = true;
    }

    public void setConfiguration(File file) {
        this.args.put("--load-config", file);
        this.more.remove("--load-config");
        this.isConfigurationDirty = true;
    }

    public void addConfiguration(File file) {
        this.addFiles("--load-config", Collections.singleton(file));
        this.isConfigurationDirty = true;
    }

    public void setConfiguration(String[] args, String defaultVariable) {
        this.setConfiguration(args, defaultVariable, true);
    }

    public void setConfiguration(String[] args, String defaultVariable, boolean argsRequireDefaultVariable) {
        this.extras = args;
        this.extrasRequireDefaultVariable = argsRequireDefaultVariable;
        this.configurationDefaultVariable = defaultVariable;
        this.isConfigurationDirty = true;
    }

    public void setLoadExterns(Collection<File> files) {
        this.args.put("--load-externs", files);
        this.more.remove("--load-externs");
        this.isConfigurationDirty = true;
    }

    public void addLoadExterns(Collection<File> files) {
        this.addFiles("--load-externs", files);
        this.isConfigurationDirty = true;
    }

    public void setFrameLabel(String label, Collection<String> classNames) {
        if (!this.args.containsKey("--frames.frame")) {
            this.args.put("--frames.frame", new TreeMap());
        }
        Map map = (Map)this.args.get("--frames.frame");
        map.put(label, classNames);
        this.isConfigurationDirty = true;
    }

    public void setIncludes(Collection<String> definitions) {
        this.args.put("--includes", definitions);
        this.more.remove("--includes");
        this.isConfigurationDirty = true;
    }

    public void addIncludes(Collection<String> definitions) {
        this.addStrings("--includes", definitions);
        this.isConfigurationDirty = true;
    }

    public void setLicense(String productName, String serialNumber) {
        if (!this.args.containsKey("--licenses.license")) {
            this.args.put("--licenses.license", new TreeMap());
        }
        Map map = (Map)this.args.get("--licenses.license");
        map.put(productName, serialNumber);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setSWFMetadata(int field, Object value) {
        switch (field) {
            case 1: {
                this.args.put("--metadata.contributor", value);
                break;
            }
            case 2: {
                this.args.put("--metadata.creator", value);
                break;
            }
            case 4: {
                this.args.put("--metadata.date", value);
                break;
            }
            case 8: {
                this.args.put("--metadata.localized-description", value);
                break;
            }
            case 16: {
                this.args.put("--metadata.localized-title", value);
                break;
            }
            case 32: {
                this.args.put("--metadata.language", value);
                break;
            }
            case 64: {
                this.args.put("--metadata.publisher", value);
            }
        }
        this.args.remove("--raw-metadata");
        this.isConfigurationDirty = true;
    }

    @Override
    public void setSWFMetadata(String xml) {
        this.args.put("--raw-metadata", xml);
        this.args.remove("--metadata.contributor");
        this.args.remove("--metadata.creator");
        this.args.remove("--metadata.date");
        this.args.remove("--metadata.localized-description");
        this.args.remove("--metadata.localized-title");
        this.args.remove("--metadata.language");
        this.args.remove("--metadata.publisher");
        this.isConfigurationDirty = true;
    }

    @Override
    public void setRuntimeSharedLibraries(List<String> libraries) {
        this.args.put("--runtime-shared-libraries", libraries);
        this.more.remove("--runtime-shared-libraries");
        this.isConfigurationDirty = true;
    }

    public void addRuntimeSharedLibraries(List<String> libraries) {
        this.addStrings("--runtime-shared-libraries", libraries);
        this.isConfigurationDirty = true;
    }

    public void useNetwork(boolean b) {
        this.args.put("--use-network", b ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setToken(String name, String value) {
        this.tokens.put(name, value);
        this.isConfigurationDirty = true;
    }

    public void setMainDefinition(String name) {
        this.mainDefinition = name;
        this.isConfigurationDirty = true;
    }

    private void addFiles(String key, Collection<File> files) {
        this.addFiles(this.more, key, files);
    }

    private void addFiles(Map<String, Object> more, String key, Collection<File> files) {
        Collection existing = null;
        if (more.containsKey(key)) {
            Object obj = more.get(key);
            existing = (Collection)obj;
        }
        if (existing != null) {
            existing.addAll(files);
            files = existing;
        }
        more.put(key, files);
    }

    private void addStrings(String key, Collection<String> strings) {
        this.addStrings(this.more, key, strings);
    }

    private void addStrings(Map<String, Object> more, String key, Collection<String> strings) {
        Collection existing = null;
        if (more.containsKey(key)) {
            existing = (Collection)more.get(key);
        }
        if (existing != null) {
            existing.addAll(strings);
            strings = existing;
        }
        more.put(key, strings);
    }

    public String toString() {
        String[] options;
        try {
            options = this.getOptions(this.args, this.more, this.processExtras(this.extras));
        }
        catch (ConfigurationException e) {
            options = new String[]{};
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < options.length; ++i) {
            b.append(options[i]);
            b.append(' ');
        }
        return b.toString();
    }

    private String toCommaSeparatedString(Collection<?> values) {
        StringBuilder b = new StringBuilder();
        int length = values.size();
        int i = 0;
        for (Object value : values) {
            String valueString = null;
            if (value instanceof String) {
                valueString = (String)value;
            } else if (value instanceof File) {
                valueString = ((File)value).getPath();
            }
            if (valueString != null) {
                b.append(valueString);
            }
            if (i++ >= length - 1) continue;
            b.append(COMMA_STRING);
        }
        return b.toString();
    }

    @Override
    public void setTargetPlayer(int major, int minor, int revision) {
        this.args.put("--target-player", major + "." + minor + "." + revision);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setCompatibilityVersion(int major, int minor, int revision) {
        if (major != 0 || minor != 0 || revision != 0) {
            this.args.put("--compiler.mxml.compatibility-version", major + "." + minor + "." + revision);
        }
        this.isConfigurationDirty = true;
    }

    @Override
    public void enableDigestVerification(boolean verify) {
        this.args.put("--verify-digests", verify ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setDefineDirectives(Map<String, String> defines) {
        if (defines == null) {
            this.args.remove("--compiler.define");
        } else {
            CompilerDefinitionMap defs = new CompilerDefinitionMap();
            defs.putAll(defines);
            this.args.put("--compiler.define", defs);
        }
        this.isConfigurationDirty = true;
    }

    public Map<String, List<String>> getExtensions() {
        if (!this.args.containsKey("--compiler.extensions.extension")) {
            this.args.put("--compiler.extensions.extension", new LinkedHashMap());
        }
        return (Map)this.args.get("--compiler.extensions.extension");
    }

    public void addExtensionLibraries(File extension, List<String> parameter) {
        this.getExtensions().put(extension.getAbsolutePath(), parameter);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setExtensionLibraries(Map<File, List<String>> extensions) {
        this.getExtensions().clear();
        Set<File> keys = extensions.keySet();
        for (File key : keys) {
            this.addExtensionLibraries(key, extensions.get(key));
        }
        this.isConfigurationDirty = true;
    }

    public Configurator clone() {
        Configurator cloneConfig;
        try {
            cloneConfig = (Configurator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        cloneConfig.args = new LinkedHashMap<String, Object>(this.args);
        cloneConfig.more = new LinkedHashMap<String, Object>(this.more);
        cloneConfig.tokens = new LinkedHashMap<String, String>(this.tokens);
        cloneConfig.configurationClass = this.configurationClass;
        cloneConfig.keepLinkReport = this.keepLinkReport;
        cloneConfig.keepSizeReport = this.keepSizeReport;
        cloneConfig.keepConfigurationReport = this.keepConfigurationReport;
        cloneConfig.reportMissingLibraries = this.reportMissingLibraries;
        cloneConfig.warnOnFlexOnlyOptionUsage = this.warnOnFlexOnlyOptionUsage;
        cloneConfig.mainDefinition = this.mainDefinition;
        cloneConfig.isConfigurationDirty = true;
        if (this.extras != null) {
            cloneConfig.extras = new String[this.extras.length];
            System.arraycopy(this.extras, 0, cloneConfig.extras, 0, this.extras.length);
        }
        return cloneConfig;
    }

    @Override
    public void setRuntimeSharedLibraryPath(List<RSLSettings> rslSettings) {
        this.args.put("--runtime-shared-library-path", rslSettings != null ? new RSLSettingsList((Collection<? extends RSLSettings>)rslSettings) : null);
        this.more.remove("--runtime-shared-library-path");
        this.isConfigurationDirty = true;
    }

    @Override
    public void addRuntimeSharedLibraryPath(List<RSLSettings> rslSettings) {
        RSLSettingsList currentSettings = (RSLSettingsList)this.more.get("--runtime-shared-library-path");
        if (currentSettings == null) {
            currentSettings = new RSLSettingsList(rslSettings.size());
        }
        currentSettings.addAll(rslSettings);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setLocales(Collection<String> locales) {
        this.args.put("--compiler.locale", locales);
        this.more.remove("--compiler.locale");
        this.isConfigurationDirty = true;
    }

    @Override
    public void addLocales(Collection<String> locales) {
        this.addStrings("--compiler.locale", locales);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setOutput(File output) {
        this.args.put("--output", output);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setIncludeClasses(Collection<String> classes) {
        this.args.put("--include-classes", classes);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setIncludeFiles(Map<String, File> files) {
        this.args.put("--include-file", files);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setIncludeNamespaces(Collection<String> namespaces) {
        this.args.put("--include-namespaces", namespaces);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setIncludeSources(Collection<File> sources) {
        this.args.put("--include-sources", sources);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setIncludeStyleSheet(Map<String, File> styleSheets) {
        this.args.put("--include-stylesheet", styleSheets);
        this.isConfigurationDirty = true;
    }

    @Override
    public void enableIncludeLookupOnly(boolean include) {
        this.args.put("--include-lookup-only", include ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setFlex(boolean value) {
        this.args.put("--flex", value ? Boolean.TRUE : Boolean.FALSE);
        this.isConfigurationDirty = true;
    }

    @Override
    public void setExcludeNativeJSLibraries(boolean value) {
        this.args.put("--exclude-native-js-libraries", value ? Boolean.TRUE : Boolean.TRUE);
    }

    static {
        excludes.add("output");
        excludes.add("warnings");
        excludes.add("compiler.debug");
        excludes.add("compiler.profile");
        excludes.add("compiler.accessible");
        excludes.add("compiler.strict");
        excludes.add("compiler.show-actionscript-warnings");
        excludes.add("compiler.show-unused-type-selector-warnings");
        excludes.add("compiler.show-deprecation-warnings");
        excludes.add("compiler.show-shadowed-device-font-warnings");
        excludes.add("compiler.show-binding-warnings");
        excludes.add("compiler.verbose-stacktraces");
        excludes.add("flex");
    }

    static class FrameLabelMap
    extends TreeMap<String, List<String>> {
        private static final long serialVersionUID = 0L;

        FrameLabelMap() {
        }
    }

    static class ServicesContextRoot {
        public String path;
        public String contextRoot;

        public ServicesContextRoot(String path, String contextRoot) {
            this.path = path;
            this.contextRoot = contextRoot;
        }
    }

    static class MXMLNamespaceMappingList
    extends ArrayList<IMXMLNamespaceMapping> {
        private static final long serialVersionUID = 0L;

        public MXMLNamespaceMappingList(int size) {
            super(size);
        }

        public MXMLNamespaceMappingList(Collection<? extends IMXMLNamespaceMapping> namespaceMappings) {
            super(namespaceMappings);
        }
    }

    static class ApplicationDomainsList
    extends ArrayList<String[]> {
        private static final long serialVersionUID = 0L;

        ApplicationDomainsList() {
        }
    }

    static class CompilerDefinitionMap
    extends TreeMap<String, String> {
        private static final long serialVersionUID = 0L;

        CompilerDefinitionMap() {
        }
    }

    static class RSLSettingsList
    extends ArrayList<RSLSettings> {
        private static final long serialVersionUID = 0L;

        public RSLSettingsList(int size) {
            super(size);
        }

        public RSLSettingsList(Collection<? extends RSLSettings> c) {
            super(c);
        }
    }
}

