/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.as.codegen;

import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.flex.abc.ABCConstants;
import org.apache.flex.abc.ABCEmitter;
import org.apache.flex.abc.instructionlist.InstructionList;
import org.apache.flex.abc.semantics.MethodBodyInfo;
import org.apache.flex.abc.semantics.MethodInfo;
import org.apache.flex.abc.semantics.Name;
import org.apache.flex.abc.semantics.PooledValue;
import org.apache.flex.abc.visitors.IMethodBodyVisitor;
import org.apache.flex.abc.visitors.IMethodVisitor;
import org.apache.flex.abc.visitors.IScriptVisitor;
import org.apache.flex.abc.visitors.IVisitor;
import org.apache.flex.compiler.exceptions.BURMAbortException;
import org.apache.flex.compiler.exceptions.CodegenInterruptedException;
import org.apache.flex.compiler.exceptions.MissingBuiltinException;
import org.apache.flex.compiler.internal.as.codegen.ABCGeneratingReducer;
import org.apache.flex.compiler.internal.as.codegen.CmcEmitter;
import org.apache.flex.compiler.internal.as.codegen.DumpBURMState;
import org.apache.flex.compiler.internal.as.codegen.GenerateFunctionInParallelResult;
import org.apache.flex.compiler.internal.as.codegen.GlobalDirectiveProcessor;
import org.apache.flex.compiler.internal.as.codegen.GlobalLexicalScope;
import org.apache.flex.compiler.internal.as.codegen.ICodeGenerator;
import org.apache.flex.compiler.internal.as.codegen.ICodeGeneratorFactory;
import org.apache.flex.compiler.internal.as.codegen.InstructionListNode;
import org.apache.flex.compiler.internal.as.codegen.LexicalScope;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.definitions.ParameterDefinition;
import org.apache.flex.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.flex.compiler.internal.embedding.EmbedData;
import org.apache.flex.compiler.internal.semantics.SemanticUtils;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.units.EmbedCompilationUnitFactory;
import org.apache.flex.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.flex.compiler.problems.CodegenInternalProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.MissingBuiltinProblem;
import org.apache.flex.compiler.problems.NonConstantParamInitializerProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFileNodeAccumulator;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IParameterNode;
import org.apache.flex.compiler.units.requests.IABCBytesRequestResult;

public class ABCGenerator
implements ICodeGenerator {
    private static boolean DEFINITION_NORMALIZATION_DISABLED = false;

    @Override
    public ABCBytesRequestResult generate(String synthetic_name_prefix, IASNode root_node, ICompilerProject project) throws InterruptedException {
        return this.generate(null, false, synthetic_name_prefix, root_node, project, DEFINITION_NORMALIZATION_DISABLED, Collections.<String, String>emptyMap());
    }

    @Override
    public ABCBytesRequestResult generate(ExecutorService executorService, boolean useParallelCodegen, String synthetic_name_prefix, IASNode root_node, ICompilerProject project, boolean inInvisibleCompilationUnit, Map<String, String> encodedDebugFiles) throws InterruptedException {
        GlobalLexicalScope global_scope = new GlobalLexicalScope(project, this, synthetic_name_prefix, inInvisibleCompilationUnit, useParallelCodegen, encodedDebugFiles);
        ABCEmitter emitter = (ABCEmitter)global_scope.getEmitter();
        emitter.visit(46, 16);
        IScriptVisitor sv = emitter.visitScript();
        sv.visit();
        MethodInfo init_method = new MethodInfo();
        sv.visitInit(init_method);
        MethodBodyInfo init_body = new MethodBodyInfo();
        init_body.setMethodInfo(init_method);
        IMethodVisitor mv = emitter.visitMethod(init_method);
        mv.visit();
        IMethodBodyVisitor mbv = mv.visitBody(init_body);
        mbv.visit();
        global_scope.traitsVisitor = sv.visitTraits();
        global_scope.setMethodInfo(init_method);
        global_scope.methodBodyVisitor = mbv;
        global_scope.setInitialControlFlowRegionNode(root_node);
        GlobalDirectiveProcessor top_level_processor = new GlobalDirectiveProcessor(executorService, useParallelCodegen, global_scope, emitter);
        boolean fatal_error_encountered = false;
        try {
            top_level_processor.traverse(root_node);
        }
        catch (MissingBuiltinException e) {
            global_scope.addProblem(new MissingBuiltinProblem(root_node, e.getBuiltinName()));
            fatal_error_encountered = true;
        }
        catch (CodegenInterruptedException e) {
            throw e.getException();
        }
        top_level_processor.finish();
        byte[] generatedBytes = IABCBytesRequestResult.ZEROBYTES;
        if (!fatal_error_encountered) {
            InstructionList script_init_insns = new InstructionList();
            script_init_insns.addInstruction(208);
            script_init_insns.addInstruction(48);
            script_init_insns.addAll(global_scope.getInitInstructions());
            script_init_insns.addAll(top_level_processor.directiveInsns);
            if (script_init_insns.canFallThrough() || script_init_insns.hasPendingLabels()) {
                script_init_insns.addInstruction(71);
            }
            global_scope.initializeTempRegisters(1);
            global_scope.callVisitEnds();
            mbv.visitInstructionList(script_init_insns);
            mbv.visitEnd();
            mv.visitEnd();
            global_scope.traitsVisitor.visitEnd();
            sv.visitEnd();
            try {
                generatedBytes = emitter.emit();
            }
            catch (Exception e) {
                global_scope.addProblem(new CodegenInternalProblem(root_node, e));
            }
        }
        Set<EmbedData> embeds = global_scope.getEmbeds();
        EmbedCompilationUnitFactory.collectEmbedDatas(project, (IFileNodeAccumulator)((Object)root_node), embeds, global_scope.getProblems());
        ICompilerProblem[] problemsArray = global_scope.getProblems().toArray(IABCBytesRequestResult.ZEROPROBLEMS);
        return new ABCBytesRequestResult(generatedBytes, problemsArray, embeds);
    }

    @Override
    public InstructionList generateInstructions(IASNode subtree, int goal_state, LexicalScope scope) {
        return this.generateInstructions(subtree, goal_state, scope, null);
    }

    public InstructionList generateInstructions(IASNode subtree, int goal_state, LexicalScope scope, InstructionList instance_init_insns) {
        CmcEmitter burm = new CmcEmitter();
        burm.reducer = new ABCGeneratingReducer();
        burm.reducer.setCurrentscope(scope);
        burm.reducer.setInstanceInitializers(instance_init_insns);
        try {
            burm.burm(subtree, goal_state);
            return (InstructionList)burm.getResult();
        }
        catch (Exception cant_reduce) {
            this.handleBurmError(burm, subtree, cant_reduce, scope);
            return new InstructionList();
        }
    }

    @Override
    public MethodInfo generateFunction(FunctionNode func, LexicalScope enclosing_scope, InstructionList instance_init_insns, Name alternate_name) {
        MethodInfo mi = this.createMethodInfo(enclosing_scope, func, alternate_name);
        if (mi.isNative()) {
            this.generateNativeMethod(func, mi, enclosing_scope);
        } else {
            this.generateMethodBodyForFunction(mi, func, enclosing_scope, instance_init_insns);
        }
        func.discardFunctionBody();
        return mi;
    }

    @Override
    public GenerateFunctionInParallelResult generateFunctionInParallel(ExecutorService executorService, FunctionNode func, LexicalScope enclosing_scope) {
        MethodInfo mi = this.createMethodInfo(enclosing_scope, func, null);
        if (mi.isNative()) {
            this.generateNativeMethod(func, mi, enclosing_scope);
            return new GenerateFunctionInParallelResult((Future<?>)Futures.immediateFuture(null), mi, Collections.<IVisitor>emptyList());
        }
        GenerateFunctionRunnable runnable = new GenerateFunctionRunnable(mi, func, enclosing_scope);
        Future<?> future = executorService.submit(runnable);
        return new GenerateFunctionInParallelResult(future, mi, runnable.getDeferredVisitEndsList());
    }

    void generateNativeMethod(FunctionNode func, MethodInfo mi, LexicalScope enclosing_scope) {
        enclosing_scope.getMethodBodySemanticChecker().checkNativeMethod(func);
        IMethodVisitor mv = enclosing_scope.getEmitter().visitMethod(mi);
        mv.visit();
        String returnType = func.getReturnType();
        mi.setReturnType(new Name(returnType));
        mv.visitEnd();
    }

    @Override
    public void generateMethodBodyForFunction(MethodInfo mi, IASNode node, LexicalScope enclosing_scope, InstructionList instance_init_insns) {
        LinkedList<IVisitor> deferredVisitEnds = new LinkedList<IVisitor>();
        this.generateMethodBodyForFunction(deferredVisitEnds, mi, node, enclosing_scope, instance_init_insns);
        for (IVisitor v : deferredVisitEnds) {
            v.visitEnd();
        }
    }

    private void generateMethodBodyForFunction(List<IVisitor> deferredVisitEnds, MethodInfo mi, IASNode node, LexicalScope enclosing_scope, InstructionList instance_init_insns) {
        assert (node != null);
        boolean is_constructor = SemanticUtils.isInConstructor(node);
        LexicalScope function_scope = enclosing_scope.pushFrame();
        if (instance_init_insns != null) {
            function_scope.transferInitializerData();
        }
        IMethodVisitor mv = function_scope.getEmitter().visitMethod(mi);
        mv.visit();
        MethodBodyInfo mbi = new MethodBodyInfo();
        mbi.setMethodInfo(mi);
        IMethodBodyVisitor mbv = mv.visitBody(mbi);
        mbv.visit();
        function_scope.methodBodyVisitor = mbv;
        function_scope.traitsVisitor = mbv.visitTraits();
        function_scope.setMethodInfo(mi);
        if (is_constructor) {
            function_scope.getMethodBodySemanticChecker().enterConstructor();
        }
        InstructionList insns = null;
        if (node instanceof IFunctionNode) {
            function_scope.setInitialControlFlowRegionNode(((IFunctionNode)node).getScopedNode());
        } else {
            function_scope.setInitialControlFlowRegionNode(node);
        }
        insns = this.generateInstructions(node, 11, function_scope, instance_init_insns);
        if (is_constructor) {
            function_scope.getMethodBodySemanticChecker().leaveConstructor();
        }
        assert (insns != null);
        function_scope.addVisitEndsToList(deferredVisitEnds);
        mbv.visitInstructionList(insns);
        deferredVisitEnds.add(function_scope.traitsVisitor);
        deferredVisitEnds.add(mbv);
        deferredVisitEnds.add(mv);
        function_scope.getMethodBodySemanticChecker().checkControlFlow(node, mi, mbi);
    }

    @Override
    public void generateMXMLDataBindingSetterFunction(MethodInfo mi, IExpressionNode setterExpression, LexicalScope enclosing_scope) {
        IMethodVisitor methodVisitor = enclosing_scope.getEmitter().visitMethod(mi);
        methodVisitor.visit();
        MethodBodyInfo methodBodyInfo = new MethodBodyInfo();
        methodBodyInfo.setMethodInfo(mi);
        IMethodBodyVisitor methodBodyVisitor = methodVisitor.visitBody(methodBodyInfo);
        methodBodyVisitor.visit();
        LexicalScope function_scope = enclosing_scope.pushFrame();
        function_scope.methodBodyVisitor = methodBodyVisitor;
        function_scope.traitsVisitor = methodBodyVisitor.visitTraits();
        function_scope.setMethodInfo(mi);
        InstructionList functionBody = setterExpression instanceof InstructionListNode ? ((InstructionListNode)setterExpression).getInstructions() : this.generateInstructions(setterExpression, 35, function_scope, null);
        functionBody.addInstruction(71);
        methodBodyVisitor.visitInstructionList(functionBody);
        methodBodyVisitor.visitEnd();
        methodVisitor.visitEnd();
    }

    @Override
    public void generateMXMLDataBindingGetterFunction(MethodInfo mi, List<IExpressionNode> nodes, LexicalScope enclosing_scope) {
        IMethodVisitor methodVisitor = enclosing_scope.getEmitter().visitMethod(mi);
        methodVisitor.visit();
        MethodBodyInfo methodBodyInfo = new MethodBodyInfo();
        methodBodyInfo.setMethodInfo(mi);
        IMethodBodyVisitor methodBodyVisitor = methodVisitor.visitBody(methodBodyInfo);
        methodBodyVisitor.visit();
        LexicalScope function_scope = enclosing_scope.pushFrame();
        function_scope.methodBodyVisitor = methodBodyVisitor;
        function_scope.traitsVisitor = methodBodyVisitor.visitTraits();
        function_scope.setMethodInfo(mi);
        InstructionList functionBody = null;
        for (IExpressionNode expressionNode : nodes) {
            InstructionList instructionsForExpression = this.generateInstructions(expressionNode, 18, function_scope, null);
            if (functionBody == null) {
                functionBody = instructionsForExpression;
                continue;
            }
            functionBody.addAll(instructionsForExpression);
            functionBody.addInstruction(160);
        }
        functionBody.addInstruction(72);
        methodBodyVisitor.visitInstructionList(functionBody);
        function_scope.traitsVisitor.visitEnd();
        methodBodyVisitor.visitEnd();
        methodVisitor.visitEnd();
    }

    @Override
    public MethodInfo createMethodInfo(LexicalScope scope, FunctionNode func, Name alternate_name) {
        return ABCGenerator.createMethodInfoWithOptionalDefaultArgumentValues(scope, func, false, alternate_name);
    }

    @Override
    public MethodInfo createMethodInfoWithDefaultArgumentValues(LexicalScope scope, FunctionNode func) {
        return ABCGenerator.createMethodInfoWithOptionalDefaultArgumentValues(scope, func, true, null);
    }

    private static MethodInfo createMethodInfoWithOptionalDefaultArgumentValues(LexicalScope scope, FunctionNode func, boolean addDefalutValues, Name alternate_name) {
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(alternate_name != null ? alternate_name.getBaseName() : func.getName());
        FunctionDefinition funcDef = func.getDefinition();
        ParameterDefinition[] args = funcDef.getParameters();
        ArrayList<String> param_names = new ArrayList<String>();
        ICompilerProject project = scope.getProject();
        if (args.length > 0) {
            Vector<Name> method_args = new Vector<Name>();
            for (ParameterDefinition arg : args) {
                Name type_name;
                TypeDefinitionBase arg_type = arg.resolveType(project);
                Name name = type_name = arg_type != null ? arg_type.getMName(project) : null;
                if (arg.isRest()) {
                    mi.setFlags((byte)(mi.getFlags() | 4));
                } else {
                    method_args.add(type_name);
                    param_names.add(arg.getBaseName());
                }
                if (!addDefalutValues || !arg.hasDefaultValue()) continue;
                Object initValue = arg.resolveInitialValue(project);
                if (initValue == null) {
                    IParameterNode paramNode = arg.getNode();
                    scope.addProblem(new NonConstantParamInitializerProblem(paramNode.getAssignedValueNode()));
                    initValue = ABCConstants.UNDEFINED_VALUE;
                }
                mi.addDefaultValue(new PooledValue(initValue));
            }
            mi.setParamTypes(method_args);
            mi.setParamNames(param_names);
        }
        if (func.getDefinition().isNative()) {
            mi.setFlags((byte)(mi.getFlags() | 0x20));
        }
        return mi;
    }

    @Override
    public ICodeGenerator.IConstantValue generateConstantValue(IASNode subtree, ICompilerProject project) {
        ConstantValue result = null;
        GlobalLexicalScope scope = new GlobalLexicalScope(project, this);
        if (subtree != null) {
            try {
                Object value = this.reduceSubtree(subtree, scope, 27);
                result = new ConstantValue(value, ((LexicalScope)scope).getProblems());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Object reduceSubtree(IASNode subtree, LexicalScope scope, int goal) throws Exception {
        CmcEmitter burm = new CmcEmitter();
        burm.reducer = new ABCGeneratingReducer();
        burm.reducer.setCurrentscope(scope);
        burm.burm(subtree, 27);
        return burm.getResult();
    }

    private void handleBurmError(CmcEmitter burm, IASNode n, Exception ex, LexicalScope scope) {
        if (ex instanceof CodegenInterruptedException) {
            scope.getProblems().clear();
            return;
        }
        if (!(ex instanceof BURMAbortException)) {
            scope.addProblem(new CodegenInternalProblem(n, ex));
        }
        DumpBURMState.dump(burm, n);
    }

    public static ICodeGeneratorFactory getABCGeneratorFactory() {
        return new ICodeGeneratorFactory(){

            @Override
            public ICodeGenerator get() {
                return new ABCGenerator();
            }
        };
    }

    public static final class ConstantValue
    implements ICodeGenerator.IConstantValue {
        private final Object value;
        private final Collection<ICompilerProblem> problems;

        public ConstantValue(Object value, Collection<ICompilerProblem> problems) {
            this.value = value;
            this.problems = problems;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Collection<ICompilerProblem> getProblems() {
            return this.problems;
        }
    }

    private class GenerateFunctionRunnable
    implements Runnable {
        private final MethodInfo methodInfo;
        private final FunctionNode functionNode;
        private final LexicalScope enclosingScope;
        private final List<IVisitor> deferredVisitEnds;

        GenerateFunctionRunnable(MethodInfo methodInfo, FunctionNode func, LexicalScope enclosing_scope) {
            this.methodInfo = methodInfo;
            this.functionNode = func;
            this.enclosingScope = enclosing_scope;
            this.deferredVisitEnds = new LinkedList<IVisitor>();
        }

        @Override
        public void run() {
            assert (!this.methodInfo.isNative()) : "Native methods should be handled in the main thread and not be dispatched to a background thread!";
            this.functionNode.parseFunctionBody(this.enclosingScope.getProblems());
            ABCGenerator.this.generateMethodBodyForFunction(this.deferredVisitEnds, this.methodInfo, this.functionNode, this.enclosingScope, null);
        }

        public List<IVisitor> getDeferredVisitEndsList() {
            return this.deferredVisitEnds;
        }
    }
}

