/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.apache.flink.runtime.state.IterableStateSnapshot;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyValueStateIterator;
import org.apache.flink.runtime.state.ListDelimitedSerializer;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredPriorityQueueStateBackendMetaInfo;
import org.apache.flink.runtime.state.SerializedCompositeKeyBuilder;
import org.apache.flink.runtime.state.StateEntry;
import org.apache.flink.runtime.state.StateSnapshot;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueStateSnapshot;
import org.apache.flink.runtime.state.heap.StateUID;
import org.apache.flink.util.Preconditions;

@Internal
@NotThreadSafe
public final class HeapKeyValueStateIterator
implements KeyValueStateIterator {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final Map<StateUID, Integer> stateNamesToId;
    private final Map<StateUID, StateSnapshot> stateStableSnapshots;
    private final int keyGroupPrefixBytes;
    private boolean isValid;
    private boolean newKeyGroup;
    private boolean newKVState;
    private byte[] currentKey;
    private byte[] currentValue;
    private final Iterator<Integer> keyGroupIterator;
    private int currentKeyGroup;
    private Iterator<StateUID> statesIterator;
    private StateUID currentState;
    private SingleStateIterator currentStateIterator;
    private final DataOutputSerializer valueOut = new DataOutputSerializer(64);
    private final ListDelimitedSerializer listDelimitedSerializer = new ListDelimitedSerializer();
    private final SerializedCompositeKeyBuilder<Object> compositeKeyBuilder;

    public HeapKeyValueStateIterator(@Nonnull KeyGroupRange keyGroupRange, @Nonnull TypeSerializer<?> keySerializer, @Nonnegative int totalKeyGroups, @Nonnull Map<StateUID, Integer> stateNamesToId, @Nonnull Map<StateUID, StateSnapshot> stateSnapshots) throws IOException {
        Preconditions.checkNotNull(keyGroupRange);
        Preconditions.checkNotNull(keySerializer);
        this.stateNamesToId = Preconditions.checkNotNull(stateNamesToId);
        this.stateStableSnapshots = Preconditions.checkNotNull(stateSnapshots);
        this.statesIterator = stateSnapshots.keySet().iterator();
        this.keyGroupIterator = keyGroupRange.iterator();
        this.keyGroupPrefixBytes = CompositeKeySerializationUtils.computeRequiredBytesInKeyGroupPrefix(totalKeyGroups);
        this.compositeKeyBuilder = new SerializedCompositeKeyBuilder(HeapKeyValueStateIterator.castToType(keySerializer), this.keyGroupPrefixBytes, 32);
        if (!this.keyGroupIterator.hasNext() || !this.statesIterator.hasNext()) {
            this.isValid = false;
        } else {
            this.currentKeyGroup = this.keyGroupIterator.next();
            this.next();
            this.newKeyGroup = true;
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean isNewKeyValueState() {
        return this.newKVState;
    }

    @Override
    public boolean isNewKeyGroup() {
        return this.newKeyGroup;
    }

    @Override
    public int keyGroup() {
        return this.currentKeyGroup;
    }

    @Override
    public int kvStateId() {
        return this.stateNamesToId.get(this.currentState);
    }

    @Override
    public void next() throws IOException {
        this.newKVState = false;
        this.newKeyGroup = false;
        boolean nextElementSet = false;
        do {
            boolean hasStateEntry;
            boolean hasNextState;
            if (this.currentState == null && !(hasNextState = this.moveToNextState())) {
                this.isValid = false;
                return;
            }
            boolean bl = hasStateEntry = this.currentStateIterator != null && this.currentStateIterator.hasNext();
            if (!hasStateEntry) {
                this.currentState = null;
            }
            if (!hasStateEntry) continue;
            nextElementSet = this.currentStateIterator.writeOutNext();
        } while (!nextElementSet);
        this.isValid = true;
    }

    private boolean moveToNextState() throws IOException {
        if (this.statesIterator.hasNext()) {
            this.currentState = this.statesIterator.next();
            this.newKVState = true;
        } else if (this.keyGroupIterator.hasNext()) {
            this.currentKeyGroup = this.keyGroupIterator.next();
            this.resetStates();
            this.newKeyGroup = true;
            this.newKVState = true;
        } else {
            return false;
        }
        StateSnapshot stateSnapshot = this.stateStableSnapshots.get(this.currentState);
        this.setCurrentStateIterator(stateSnapshot);
        return true;
    }

    private void resetStates() {
        this.statesIterator = this.stateStableSnapshots.keySet().iterator();
        this.currentState = this.statesIterator.next();
    }

    private void setCurrentStateIterator(StateSnapshot stateSnapshot) throws IOException {
        if (stateSnapshot instanceof IterableStateSnapshot) {
            RegisteredKeyValueStateBackendMetaInfo metaInfo = new RegisteredKeyValueStateBackendMetaInfo(stateSnapshot.getMetaInfoSnapshot());
            Iterator snapshotIterator = ((IterableStateSnapshot)stateSnapshot).getIterator(this.currentKeyGroup);
            this.currentStateIterator = new StateTableIterator(snapshotIterator, metaInfo);
        } else if (stateSnapshot instanceof HeapPriorityQueueStateSnapshot) {
            Iterator snapshotIterator = ((HeapPriorityQueueStateSnapshot)stateSnapshot).getIteratorForKeyGroup(this.currentKeyGroup);
            RegisteredPriorityQueueStateBackendMetaInfo metaInfo = new RegisteredPriorityQueueStateBackendMetaInfo(stateSnapshot.getMetaInfoSnapshot());
            this.currentStateIterator = new QueueIterator(snapshotIterator, metaInfo);
        } else {
            throw new IllegalStateException("Unknown snapshot type: " + stateSnapshot);
        }
    }

    @Nonnull
    private static <T> TypeSerializer<T> castToType(@Nonnull TypeSerializer<?> serializer) {
        return serializer;
    }

    @Override
    public byte[] key() {
        return this.currentKey;
    }

    @Override
    public byte[] value() {
        return this.currentValue;
    }

    @Override
    public void close() {
    }

    static /* synthetic */ byte[] access$402(HeapKeyValueStateIterator x0, byte[] x1) {
        x0.currentKey = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$502(HeapKeyValueStateIterator x0, byte[] x1) {
        x0.currentValue = x1;
        return x1;
    }

    private final class QueueIterator<T>
    implements SingleStateIterator {
        private final Iterator<T> elementsForKeyGroup;
        private final RegisteredPriorityQueueStateBackendMetaInfo<T> metaInfo;
        private final DataOutputSerializer keyOut = new DataOutputSerializer(128);
        private final int afterKeyMark;

        public QueueIterator(Iterator<T> elementsForKeyGroup, RegisteredPriorityQueueStateBackendMetaInfo<T> metaInfo) throws IOException {
            this.elementsForKeyGroup = elementsForKeyGroup;
            this.metaInfo = metaInfo;
            CompositeKeySerializationUtils.writeKeyGroup(HeapKeyValueStateIterator.this.keyGroup(), HeapKeyValueStateIterator.this.keyGroupPrefixBytes, this.keyOut);
            this.afterKeyMark = this.keyOut.length();
        }

        @Override
        public boolean hasNext() {
            return this.elementsForKeyGroup.hasNext();
        }

        @Override
        public boolean writeOutNext() throws IOException {
            HeapKeyValueStateIterator.access$502(HeapKeyValueStateIterator.this, EMPTY_BYTE_ARRAY);
            this.keyOut.setPosition(this.afterKeyMark);
            T next = this.elementsForKeyGroup.next();
            this.metaInfo.getElementSerializer().serialize(next, this.keyOut);
            HeapKeyValueStateIterator.access$402(HeapKeyValueStateIterator.this, this.keyOut.getCopyOfBuffer());
            return true;
        }
    }

    private final class MapStateIterator
    implements SingleStateIterator {
        private final Iterator<Map.Entry<Object, Object>> mapEntries;
        private final TypeSerializer<Object> userKeySerializer;
        private final TypeSerializer<Object> userValueSerializer;
        private final StateTableIterator parentIterator;

        private MapStateIterator(Map<Object, Object> mapEntries, TypeSerializer<Object> userKeySerializer, TypeSerializer<Object> userValueSerializer, StateTableIterator parentIterator) {
            assert (!mapEntries.isEmpty());
            this.mapEntries = mapEntries.entrySet().iterator();
            this.userKeySerializer = userKeySerializer;
            this.userValueSerializer = userValueSerializer;
            this.parentIterator = parentIterator;
        }

        @Override
        public boolean hasNext() {
            assert (this.mapEntries.hasNext());
            return true;
        }

        @Override
        public boolean writeOutNext() throws IOException {
            Map.Entry<Object, Object> entry = this.mapEntries.next();
            HeapKeyValueStateIterator.this.valueOut.clear();
            HeapKeyValueStateIterator.access$402(HeapKeyValueStateIterator.this, HeapKeyValueStateIterator.this.compositeKeyBuilder.buildCompositeKeyUserKey(entry.getKey(), this.userKeySerializer));
            Object userValue = entry.getValue();
            HeapKeyValueStateIterator.this.valueOut.writeBoolean(userValue == null);
            this.userValueSerializer.serialize(userValue, HeapKeyValueStateIterator.this.valueOut);
            HeapKeyValueStateIterator.access$502(HeapKeyValueStateIterator.this, HeapKeyValueStateIterator.this.valueOut.getCopyOfBuffer());
            if (!this.mapEntries.hasNext()) {
                HeapKeyValueStateIterator.this.currentStateIterator = this.parentIterator;
            }
            return true;
        }
    }

    private final class StateTableIterator
    implements SingleStateIterator {
        private final Iterator<? extends StateEntry<?, ?, ?>> entriesIterator;
        private final RegisteredKeyValueStateBackendMetaInfo<?, ?> stateSnapshot;

        private StateTableIterator(Iterator<? extends StateEntry<?, ?, ?>> entriesIterator, RegisteredKeyValueStateBackendMetaInfo<?, ?> stateSnapshot) {
            this.entriesIterator = entriesIterator;
            this.stateSnapshot = stateSnapshot;
        }

        @Override
        public boolean hasNext() {
            return this.entriesIterator.hasNext();
        }

        @Override
        public boolean writeOutNext() throws IOException {
            StateEntry<?, ?, ?> currentEntry = this.entriesIterator.next();
            HeapKeyValueStateIterator.this.valueOut.clear();
            HeapKeyValueStateIterator.this.compositeKeyBuilder.setKeyAndKeyGroup(currentEntry.getKey(), HeapKeyValueStateIterator.this.keyGroup());
            HeapKeyValueStateIterator.this.compositeKeyBuilder.setNamespace(currentEntry.getNamespace(), HeapKeyValueStateIterator.castToType(this.stateSnapshot.getNamespaceSerializer()));
            TypeSerializer<?> stateSerializer = this.stateSnapshot.getStateSerializer();
            switch (this.stateSnapshot.getStateType()) {
                case AGGREGATING: 
                case REDUCING: 
                case FOLDING: 
                case VALUE: {
                    return this.writeOutValue(currentEntry, stateSerializer);
                }
                case LIST: {
                    return this.writeOutList(currentEntry, stateSerializer);
                }
                case MAP: {
                    return this.writeOutMap(currentEntry, stateSerializer);
                }
            }
            throw new IllegalStateException("");
        }

        private boolean writeOutValue(StateEntry<?, ?, ?> currentEntry, TypeSerializer<?> stateSerializer) throws IOException {
            HeapKeyValueStateIterator.access$402(HeapKeyValueStateIterator.this, HeapKeyValueStateIterator.this.compositeKeyBuilder.build());
            HeapKeyValueStateIterator.castToType(stateSerializer).serialize(currentEntry.getState(), HeapKeyValueStateIterator.this.valueOut);
            HeapKeyValueStateIterator.access$502(HeapKeyValueStateIterator.this, HeapKeyValueStateIterator.this.valueOut.getCopyOfBuffer());
            return true;
        }

        private boolean writeOutList(StateEntry<?, ?, ?> currentEntry, TypeSerializer<?> stateSerializer) throws IOException {
            List state = (List)currentEntry.getState();
            if (state.isEmpty()) {
                return false;
            }
            ListSerializer listSerializer = (ListSerializer)stateSerializer;
            HeapKeyValueStateIterator.access$402(HeapKeyValueStateIterator.this, HeapKeyValueStateIterator.this.compositeKeyBuilder.build());
            HeapKeyValueStateIterator.access$502(HeapKeyValueStateIterator.this, HeapKeyValueStateIterator.this.listDelimitedSerializer.serializeList(state, listSerializer.getElementSerializer()));
            return true;
        }

        private boolean writeOutMap(StateEntry<?, ?, ?> currentEntry, TypeSerializer<?> stateSerializer) throws IOException {
            Map state = (Map)currentEntry.getState();
            if (state.isEmpty()) {
                return false;
            }
            MapSerializer mapSerializer = (MapSerializer)stateSerializer;
            HeapKeyValueStateIterator.this.currentStateIterator = new MapStateIterator(state, mapSerializer.getKeySerializer(), mapSerializer.getValueSerializer(), this);
            return HeapKeyValueStateIterator.this.currentStateIterator.writeOutNext();
        }
    }

    private static interface SingleStateIterator {
        public boolean hasNext();

        public boolean writeOutNext() throws IOException;
    }
}

