/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;

public class OffsetRowData
implements RowData {
    private final int arity;
    private final int offset;
    private RowData row;

    public OffsetRowData(int arity, int offset) {
        this.arity = arity;
        this.offset = offset;
    }

    public OffsetRowData replace(RowData row) {
        this.row = row;
        return this;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.row.isNullAt(this.offset + pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.row.getBoolean(this.offset + pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.row.getByte(this.offset + pos);
    }

    @Override
    public short getShort(int pos) {
        return this.row.getShort(this.offset + pos);
    }

    @Override
    public int getInt(int pos) {
        return this.row.getInt(this.offset + pos);
    }

    @Override
    public long getLong(int pos) {
        return this.row.getLong(this.offset + pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.row.getFloat(this.offset + pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.row.getDouble(this.offset + pos);
    }

    @Override
    public StringData getString(int pos) {
        return this.row.getString(this.offset + pos);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        return this.row.getDecimal(this.offset + pos, precision, scale);
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        return this.row.getTimestamp(this.offset + pos, precision);
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        return this.row.getRawValue(this.offset + pos);
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.row.getBinary(this.offset + pos);
    }

    @Override
    public ArrayData getArray(int pos) {
        return this.row.getArray(this.offset + pos);
    }

    @Override
    public MapData getMap(int pos) {
        return this.row.getMap(this.offset + pos);
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        return this.row.getRow(this.offset + pos, numFields);
    }
}

