/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal.command;

import java.io.IOException;
import java.util.HashSet;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.cq.internal.command.BaseCQCommand;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;

public class StopCQ
extends BaseCQCommand {
    private static final StopCQ singleton = new StopCQ();

    public static Command getCommand() {
        return singleton;
    }

    private StopCQ() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        ClientProxyMembershipID id = serverConnection.getProxyID();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        start = DistributionStats.getStatTime();
        String cqName = clientMessage.getPart(0).getString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received stop CQ request from {} cqName: {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)cqName);
        }
        if (cqName == null) {
            String err = "The cqName for the cq stop request is null";
            this.sendCqResponse(47, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
            String serverCqName = cqName;
            if (id != null) {
                serverCqName = cqService.constructServerCqName(cqName, id);
            }
            InternalCqQuery cqQuery = cqService.getCq(serverCqName);
            securityService.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.MANAGE, ResourcePermission.Target.QUERY);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                String queryStr = null;
                HashSet<String> cqRegionNames = null;
                if (cqQuery != null) {
                    queryStr = cqQuery.getQueryString();
                    cqRegionNames = new HashSet<String>();
                    cqRegionNames.add(cqQuery.getRegionName());
                }
                authzRequest.stopCQAuthorize(cqName, queryStr, cqRegionNames);
            }
            cqService.stopCq(cqName, id);
            if (cqQuery != null) {
                serverConnection.removeCq(cqName, cqQuery.isDurable());
            }
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", clientMessage.getTransactionId(), cqe, serverConnection);
            return;
        }
        catch (Exception e) {
            String err = String.format("Exception while stopping CQ named %s :", cqName);
            this.sendCqResponse(50, err, clientMessage.getTransactionId(), e, serverConnection);
            return;
        }
        this.sendCqResponse(6, "cq stopped successfully.", clientMessage.getTransactionId(), null, serverConnection);
        serverConnection.setAsTrue(1);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessStopCqTime(start - oldStart);
    }
}

