/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.geronimo.connector.outbound.connectionmanagerconfig;

import org.apache.geronimo.connector.outbound.ConnectionInterceptor;

/**
 *
 *
 * @version $Rev$ $Date$
 *
 * */
public class NoPool implements PoolingSupport {
    private static final long serialVersionUID = -7871656583080873750L;

    public ConnectionInterceptor addPoolingInterceptors(ConnectionInterceptor tail) {
        return tail;
    }

    public int getPartitionCount() {
        return 0;
    }

    public int getIdleConnectionCount() {
        return 0;
    }

    public int getConnectionCount() {
        return 0;
    }

    public int getPartitionMaxSize() {
        return 0;
    }

    public void setPartitionMaxSize(int maxSize) {

    }

    public int getPartitionMinSize() {
        return 0;
    }

    public void setPartitionMinSize(int minSize) {

    }

    public int getBlockingTimeoutMilliseconds() {
        return 0;
    }

    public void setBlockingTimeoutMilliseconds(int timeoutMilliseconds) {

    }

    public int getIdleTimeoutMinutes() {
        return 0;
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {

    }
}
