/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.command.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.grails.cli.command.archive.ArchiveCommand;
import org.grails.cli.command.archive.ResourceMatcher;
import org.springframework.boot.loader.tools.JarWriter;
import org.springframework.boot.loader.tools.Layouts;
import org.springframework.boot.loader.tools.LibraryScope;

public class WarCommand
extends ArchiveCommand {
    public WarCommand() {
        super("war", "Create a self-contained executable war file from a Spring Groovy script", new WarOptionHandler());
    }

    private static final class WarOptionHandler
    extends ArchiveCommand.ArchiveOptionHandler {
        WarOptionHandler() {
            super("war", new Layouts.War());
        }

        @Override
        protected LibraryScope getLibraryScope(File file) {
            String fileName = file.getName();
            if (fileName.contains("tomcat-embed") || fileName.contains("spring-boot-starter-tomcat")) {
                return LibraryScope.PROVIDED;
            }
            return LibraryScope.COMPILE;
        }

        @Override
        protected void addCliClasses(JarWriter writer) throws IOException {
            this.addClass(writer, null, "org.grails.cli.boot.SpringApplicationWebApplicationInitializer");
            super.addCliClasses(writer);
        }

        @Override
        protected void writeClasspathEntry(JarWriter writer, ResourceMatcher.MatchedResource entry) throws IOException {
            writer.writeEntry(this.getLayout().getClassesLocation() + entry.getName(), new FileInputStream(entry.getFile()));
        }
    }
}

