/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.rest.auth.DecoratedUserContext;
import org.apache.guacamole.rest.event.ListenerService;
import org.apache.guacamole.tunnel.UserTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuacamoleSession {
    private static final Logger logger = LoggerFactory.getLogger(GuacamoleSession.class);
    private AuthenticatedUser authenticatedUser;
    private List<DecoratedUserContext> userContexts;
    private final Map<String, UserTunnel> tunnels = new ConcurrentHashMap();
    private final ListenerService listenerService;
    private long lastAccessedTime = System.currentTimeMillis();

    public GuacamoleSession(ListenerService listenerService, AuthenticatedUser authenticatedUser, List<DecoratedUserContext> userContexts) throws GuacamoleException {
        this.listenerService = listenerService;
        this.authenticatedUser = authenticatedUser;
        this.userContexts = userContexts;
    }

    public AuthenticatedUser getAuthenticatedUser() {
        this.access();
        return this.authenticatedUser;
    }

    public void setAuthenticatedUser(AuthenticatedUser authenticatedUser) {
        this.access();
        this.authenticatedUser = authenticatedUser;
    }

    public List<DecoratedUserContext> getUserContexts() {
        this.access();
        return Collections.unmodifiableList(this.userContexts);
    }

    public boolean isValid() {
        return !this.userContexts.stream().anyMatch(userContext -> !userContext.isValid());
    }

    public DecoratedUserContext getUserContext(String authProviderIdentifier) throws GuacamoleException {
        for (DecoratedUserContext userContext : this.getUserContexts()) {
            AuthenticationProvider authProvider = userContext.getAuthenticationProvider();
            if (!authProvider.getIdentifier().equals(authProviderIdentifier)) continue;
            return userContext;
        }
        throw new GuacamoleResourceNotFoundException("Session not associated with authentication provider \"" + authProviderIdentifier + "\".");
    }

    public void setUserContexts(List<DecoratedUserContext> userContexts) {
        this.access();
        this.userContexts = userContexts;
    }

    public boolean hasTunnels() {
        return !this.tunnels.isEmpty();
    }

    public Map<String, UserTunnel> getTunnels() {
        this.access();
        return this.tunnels;
    }

    public void addTunnel(UserTunnel tunnel) {
        this.access();
        this.tunnels.put(tunnel.getUUID().toString(), tunnel);
    }

    public boolean removeTunnel(String uuid) {
        this.access();
        return this.tunnels.remove(uuid) != null;
    }

    public void access() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void invalidate() {
        for (GuacamoleTunnel tunnel : this.tunnels.values()) {
            try {
                tunnel.close();
            }
            catch (GuacamoleException e) {
                logger.debug("Unable to close tunnel.", (Throwable)e);
            }
        }
        for (UserContext userContext : this.userContexts) {
            userContext.invalidate();
        }
        this.authenticatedUser.invalidate();
        try {
            this.listenerService.handleEvent((Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (GuacamoleException e) {
            logger.error("An extension listening for session invalidation failed: {}", (Object)e.getMessage());
            logger.debug("Extension failed internally while handling the session invalidation event.", (Throwable)e);
        }
    }

    static /* synthetic */ AuthenticatedUser access$000(GuacamoleSession x0) {
        return x0.authenticatedUser;
    }
}

