/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.sdk.annotations.Experimental;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.METRICS)
public class MetricsLogger
extends MetricsContainerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsLogger.class);
    Lock reportingLocK = new ReentrantLock();
    AtomicLong lastReportedMillis = new AtomicLong(System.currentTimeMillis());
    @Nullable MetricsContainerImpl lastMetricsSnapshot = null;

    public MetricsLogger(@Nullable String stepName) {
        super(stepName);
    }

    public String generateLogMessage(String header, Set<String> allowedMetricUrns, long lastReported) {
        MetricsContainerImpl nextMetricsSnapshot = new MetricsContainerImpl(this.stepName);
        nextMetricsSnapshot.update(this);
        MetricsContainerImpl deltaContainer = MetricsContainerImpl.deltaContainer(this.lastMetricsSnapshot, nextMetricsSnapshot);
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(header);
        logMessage.append(deltaContainer.getCumulativeString(allowedMetricUrns));
        logMessage.append(String.format("(last reported at %s)%n", new Date(lastReported)));
        this.lastMetricsSnapshot = nextMetricsSnapshot;
        return logMessage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryLoggingMetrics(String header, Set<String> allowedMetricUrns, long minimumLoggingFrequencyMillis) {
        if (this.reportingLocK.tryLock()) {
            try {
                long currentTimeMillis = System.currentTimeMillis();
                long lastReported = this.lastReportedMillis.get();
                if (currentTimeMillis - lastReported > minimumLoggingFrequencyMillis) {
                    LOG.info(this.generateLogMessage(header, allowedMetricUrns, lastReported));
                    this.lastReportedMillis.set(currentTimeMillis);
                }
            }
            finally {
                this.reportingLocK.unlock();
            }
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof MetricsLogger) {
            return super.equals(object);
        }
        return false;
    }
}

