/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.auth;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.extensions.gcp.auth.CredentialFactory;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GcpCredentialFactory
implements CredentialFactory {
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/cloud-platform", "https://www.googleapis.com/auth/devstorage.full_control", "https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/datastore", "https://www.googleapis.com/auth/bigquery", "https://www.googleapis.com/auth/bigquery.insertdata", "https://www.googleapis.com/auth/pubsub");
    private @Nullable List<String> impersonateServiceAccountChain;

    private GcpCredentialFactory(@Nullable List<String> impersonateServiceAccountChain) {
        if (impersonateServiceAccountChain != null) {
            Preconditions.checkArgument((impersonateServiceAccountChain.size() > 0 ? 1 : 0) != 0);
        }
        this.impersonateServiceAccountChain = impersonateServiceAccountChain;
    }

    public static GcpCredentialFactory fromOptions(PipelineOptions options) {
        @Nullable String impersonateServiceAccountArg = ((GcpOptions)options.as(GcpOptions.class)).getImpersonateServiceAccount();
        @Nullable List<String> impersonateServiceAccountChain = impersonateServiceAccountArg == null ? null : Arrays.asList(impersonateServiceAccountArg.split(","));
        return new GcpCredentialFactory(impersonateServiceAccountChain);
    }

    @Override
    public @Nullable Credentials getCredential() {
        try {
            GoogleCredentials applicationDefaultCredentials = GoogleCredentials.getApplicationDefault().createScoped(SCOPES);
            if (this.impersonateServiceAccountChain == null) {
                return applicationDefaultCredentials;
            }
            String targetPrincipal = this.impersonateServiceAccountChain.get(this.impersonateServiceAccountChain.size() - 1);
            List<String> delegationChain = this.impersonateServiceAccountChain.subList(0, this.impersonateServiceAccountChain.size() - 1);
            ImpersonatedCredentials impersonationCredentials = ImpersonatedCredentials.create((GoogleCredentials)applicationDefaultCredentials, (String)targetPrincipal, delegationChain, SCOPES, (int)0);
            return impersonationCredentials;
        }
        catch (IOException e) {
            return null;
        }
    }
}

