/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.base.IBaseMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.IAttributes;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.attributes.AttributesUtil;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginLoaderException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.IRowDistribution;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.RowDistributionPluginType;
import org.apache.hop.pipeline.transform.TransformErrorMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.missing.Missing;
import org.apache.hop.resource.IResourceExport;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransformMeta
implements Cloneable,
Comparable<TransformMeta>,
IGuiPosition,
ICheckResultSource,
IResourceExport,
IResourceHolder,
IAttributes,
IBaseMeta {
    private static final Class<?> PKG = TransformMeta.class;
    public static final String XML_TAG = "transform";
    public static final String STRING_ID_MAPPING = "Mapping";
    public static final String STRING_ID_SINGLE_THREADER = "SingleThreader";
    public static final String STRING_ID_ETL_META_INJECT = "MetaInject";
    public static final String STRING_ID_WORKFLOW_EXECUTOR = "WorkflowExecutor";
    public static final String STRING_ID_MAPPING_INPUT = "MappingInput";
    public static final String STRING_ID_MAPPING_OUTPUT = "MappingOutput";
    private String transformPluginId;
    private String name;
    private ITransformMeta transform;
    private boolean selected;
    private boolean distributes;
    private boolean isDeprecated;
    private String suggestion;
    private IRowDistribution rowDistribution;
    private String copiesString;
    private Point location;
    private String description;
    private boolean terminator;
    private TransformPartitioningMeta transformPartitioningMeta;
    private TransformPartitioningMeta targetTransformPartitioningMeta;
    private TransformErrorMeta transformErrorMeta;
    private PipelineMeta parentPipelineMeta;
    private Integer copiesCache;
    protected Map<String, Map<String, String>> attributesMap;

    public TransformMeta(String transformId, String transformName, ITransformMeta transform) {
        this(transformName, transform);
        if (this.transformPluginId == null) {
            this.transformPluginId = transformId;
        }
    }

    public TransformMeta(String transformName, ITransformMeta transform) {
        this.suggestion = "";
        this.copiesCache = null;
        if (transform != null) {
            PluginRegistry registry = PluginRegistry.getInstance();
            this.transformPluginId = registry.getPluginId(TransformPluginType.class, (Object)transform);
            if (this.transformPluginId == null) {
                System.err.println("WARNING: transform plugin class '" + transform.getClass().getName() + "' couldn't be found in the plugin registry. Check the classpath.");
            }
        }
        this.name = transformName;
        this.setTransform(transform);
        this.selected = false;
        this.distributes = true;
        this.copiesString = "1";
        this.location = new Point(0, 0);
        this.description = null;
        this.transformPartitioningMeta = new TransformPartitioningMeta();
        this.targetTransformPartitioningMeta = null;
        this.attributesMap = new HashMap<String, Map<String, String>>();
    }

    public TransformMeta() {
        this(null, null, null);
    }

    public String getXml() throws HopException {
        StringBuilder xml = new StringBuilder(200);
        xml.append("  ").append(XmlHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("    ").append(XmlHandler.addTagValue((String)"name", (String)this.getName()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"type", (String)this.getTransformPluginId()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"description", (String)this.description));
        xml.append("    ").append(XmlHandler.addTagValue((String)"distribute", (boolean)this.distributes));
        xml.append("    ").append(XmlHandler.addTagValue((String)"custom_distribution", this.rowDistribution == null ? null : this.rowDistribution.getCode()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"copies", (String)this.copiesString));
        xml.append(this.transformPartitioningMeta.getXml());
        if (this.targetTransformPartitioningMeta != null) {
            xml.append(XmlHandler.openTag((String)"target_transform_partitioning")).append(this.targetTransformPartitioningMeta.getXml()).append(XmlHandler.closeTag((String)"target_transform_partitioning"));
        }
        xml.append(this.transform.getXml());
        xml.append(AttributesUtil.getAttributesXml(this.attributesMap));
        xml.append("    ").append(XmlHandler.openTag((String)"GUI")).append(Const.CR);
        xml.append("      ").append(XmlHandler.addTagValue((String)"xloc", (int)this.location.x));
        xml.append("      ").append(XmlHandler.addTagValue((String)"yloc", (int)this.location.y));
        xml.append("    ").append(XmlHandler.closeTag((String)"GUI")).append(Const.CR);
        xml.append("    ").append(XmlHandler.closeTag((String)XML_TAG)).append(Const.CR).append(Const.CR);
        return xml.toString();
    }

    public TransformMeta(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException, HopPluginLoaderException {
        block13: {
            this();
            PluginRegistry registry = PluginRegistry.getInstance();
            try {
                int y;
                int x;
                this.name = XmlHandler.getTagValue((Node)transformNode, (String)"name");
                this.transformPluginId = XmlHandler.getTagValue((Node)transformNode, (String)"type");
                IPlugin transformPlugin = registry.findPluginWithId(TransformPluginType.class, this.transformPluginId, true);
                if (transformPlugin == null) {
                    this.setTransform(new Missing(this.name, this.transformPluginId));
                } else {
                    this.setTransform((ITransformMeta)registry.loadClass(transformPlugin));
                }
                if (this.transform == null) break block13;
                if (transformPlugin != null) {
                    this.transformPluginId = transformPlugin.getIds()[0];
                    this.suggestion = Const.NVL((String)transformPlugin.getSuggestion(), (String)"");
                }
                if (this.transform != null) {
                    this.transform.loadXml(transformNode, metadataProvider);
                }
                this.description = XmlHandler.getTagValue((Node)transformNode, (String)"description");
                this.copiesString = XmlHandler.getTagValue((Node)transformNode, (String)"copies");
                String sdistri = XmlHandler.getTagValue((Node)transformNode, (String)"distribute");
                this.distributes = "Y".equalsIgnoreCase(sdistri);
                if (sdistri == null) {
                    this.distributes = true;
                }
                this.attributesMap = AttributesUtil.loadAttributes(XmlHandler.getSubNode((Node)transformNode, (String)"attributes"));
                String rowDistributionCode = XmlHandler.getTagValue((Node)transformNode, (String)"custom_distribution");
                this.rowDistribution = (IRowDistribution)PluginRegistry.getInstance().loadClass(RowDistributionPluginType.class, rowDistributionCode, IRowDistribution.class);
                String xloc = XmlHandler.getTagValue((Node)transformNode, (String)"GUI", (String)"xloc");
                String yloc = XmlHandler.getTagValue((Node)transformNode, (String)"GUI", (String)"yloc");
                try {
                    x = Integer.parseInt(xloc);
                }
                catch (Exception e) {
                    x = 0;
                }
                try {
                    y = Integer.parseInt(yloc);
                }
                catch (Exception e) {
                    y = 0;
                }
                this.location = new Point(x, y);
                Node partNode = XmlHandler.getSubNode((Node)transformNode, (String)"partitioning");
                this.transformPartitioningMeta = new TransformPartitioningMeta(partNode, metadataProvider);
                Node targetPartNode = XmlHandler.getSubNode((Node)transformNode, (String)"target_transform_partitioning");
                partNode = XmlHandler.getSubNode((Node)targetPartNode, (String)"partitioning");
                if (partNode != null) {
                    this.targetTransformPartitioningMeta = new TransformPartitioningMeta(partNode, metadataProvider);
                }
            }
            catch (HopPluginLoaderException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HopXmlException(BaseMessages.getString(PKG, (String)"TransformMeta.Exception.UnableToLoadTransformMeta", (String[])new String[0]) + e.toString(), (Throwable)e);
            }
        }
    }

    public static TransformMeta fromXml(String metaXml) {
        try {
            Document doc = XmlHandler.loadXmlString((String)metaXml);
            Node transformNode = XmlHandler.getSubNode((Node)doc, (String)XML_TAG);
            return new TransformMeta(transformNode, null);
        }
        catch (HopPluginLoaderException | HopXmlException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCopies(int c) {
        this.setChanged();
        this.copiesString = Integer.toString(c);
        this.copiesCache = c;
    }

    public int getCopies(IVariables variables) {
        List<String> partitionIDs;
        if (this.isPartitioned() && this.getTransformPartitioningMeta().getPartitionSchema() != null && (partitionIDs = this.getTransformPartitioningMeta().getPartitionSchema().calculatePartitionIds(variables)) != null && partitionIDs.size() > 0) {
            return partitionIDs.size();
        }
        if (this.copiesCache != null) {
            return this.copiesCache;
        }
        this.copiesCache = this.parentPipelineMeta != null ? Integer.valueOf(Const.toInt((String)variables.resolve(this.copiesString), (int)-1)) : Integer.valueOf(Const.toInt((String)this.copiesString, (int)1));
        return this.copiesCache;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TransformMeta transformMeta = (TransformMeta)obj;
        return this.getName().equalsIgnoreCase(transformMeta.getName());
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    @Override
    public int compareTo(TransformMeta o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean hasChanged() {
        ITransformMeta meta = this.getTransform();
        return meta != null ? meta.hasChanged() : false;
    }

    public void setChanged(boolean ch) {
        BaseTransformMeta meta = (BaseTransformMeta)this.getTransform();
        if (meta != null) {
            meta.setChanged(ch);
        }
    }

    public void setChanged() {
        ITransformMeta meta = this.getTransform();
        if (meta != null) {
            meta.setChanged();
        }
    }

    public boolean chosesTargetTransforms() {
        if (this.getTransform() != null) {
            List<IStream> targetStreams = this.getTransform().getTransformIOMeta().getTargetStreams();
            return targetStreams.isEmpty();
        }
        return false;
    }

    public Object clone() {
        TransformMeta transformMeta = new TransformMeta();
        transformMeta.replaceMeta(this);
        return transformMeta;
    }

    public void replaceMeta(TransformMeta transformMeta) {
        this.transformPluginId = transformMeta.transformPluginId;
        this.name = transformMeta.name;
        if (transformMeta.transform != null) {
            this.setTransform((ITransformMeta)transformMeta.transform.clone());
        } else {
            this.transform = null;
        }
        this.selected = transformMeta.selected;
        this.distributes = transformMeta.distributes;
        this.setRowDistribution(transformMeta.getRowDistribution());
        this.copiesString = transformMeta.copiesString;
        this.copiesCache = null;
        this.location = transformMeta.location != null ? new Point(transformMeta.location.x, transformMeta.location.y) : null;
        this.description = transformMeta.description;
        this.terminator = transformMeta.terminator;
        this.transformPartitioningMeta = transformMeta.transformPartitioningMeta != null ? transformMeta.transformPartitioningMeta.clone() : null;
        if (transformMeta.transformErrorMeta != null) {
            this.transformErrorMeta = transformMeta.transformErrorMeta.clone();
        }
        this.attributesMap = TransformMeta.copyStringMap(transformMeta.attributesMap);
        this.setChanged(true);
    }

    private static Map<String, Map<String, String>> copyStringMap(Map<String, Map<String, String>> map) {
        if (map == null) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(map.size());
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            Map<String, String> value = entry.getValue();
            HashMap<String, String> copy = value == null ? null : new HashMap<String, String>(value);
            result.put(entry.getKey(), copy);
        }
        return result;
    }

    public ITransformMeta getTransform() {
        return this.transform;
    }

    public void setTransform(ITransformMeta transform) {
        this.transform = transform;
        if (transform != null) {
            this.transform.setParentTransformMeta(this);
            Deprecated deprecated = transform.getClass().getDeclaredAnnotation(Deprecated.class);
            if (deprecated != null) {
                this.isDeprecated = true;
            }
        }
    }

    public String getTransformPluginId() {
        return this.transformPluginId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String sname) {
        this.name = sname;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setTerminator() {
        this.setTerminator(true);
    }

    public void setTerminator(boolean t) {
        this.terminator = t;
    }

    public boolean hasTerminator() {
        return this.terminator;
    }

    public void setLocation(int x, int y) {
        int ny;
        int nx = x >= 0 ? x : 0;
        Point loc = new Point(nx, ny = y >= 0 ? y : 0);
        if (!loc.equals((Object)this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public void setLocation(Point loc) {
        if (loc != null && !loc.equals((Object)this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        this.transform.check(remarks, pipelineMeta, this, prev, input, output, info, variables, metadataProvider);
    }

    public String toString() {
        if (this.getName() == null) {
            return this.getClass().getName();
        }
        return this.getName();
    }

    public boolean isPartitioned() {
        return this.transformPartitioningMeta != null && this.transformPartitioningMeta.isPartitioned();
    }

    public boolean isTargetPartitioned() {
        return this.targetTransformPartitioningMeta != null && this.targetTransformPartitioningMeta.isPartitioned();
    }

    public TransformPartitioningMeta getTransformPartitioningMeta() {
        return this.transformPartitioningMeta;
    }

    public void setTransformPartitioningMeta(TransformPartitioningMeta transformPartitioningMeta) {
        this.transformPartitioningMeta = transformPartitioningMeta;
    }

    public boolean isDistributes() {
        return this.distributes;
    }

    public void setDistributes(boolean distributes) {
        if (this.distributes != distributes) {
            this.distributes = distributes;
            this.setChanged();
        }
    }

    public TransformErrorMeta getTransformErrorMeta() {
        return this.transformErrorMeta;
    }

    public void setTransformErrorMeta(TransformErrorMeta transformErrorMeta) {
        this.transformErrorMeta = transformErrorMeta;
    }

    public static final TransformMeta findTransform(List<TransformMeta> transforms, String transformName) {
        if (transforms == null) {
            return null;
        }
        for (TransformMeta transformMeta : transforms) {
            if (!transformMeta.getName().equalsIgnoreCase(transformName)) continue;
            return transformMeta;
        }
        return null;
    }

    public boolean supportsErrorHandling() {
        return this.transform.supportsErrorHandling();
    }

    public boolean isDoingErrorHandling() {
        return this.transform.supportsErrorHandling() && this.transformErrorMeta != null && this.transformErrorMeta.getTargetTransform() != null && this.transformErrorMeta.isEnabled();
    }

    public boolean isSendingErrorRowsToTransform(TransformMeta targetTransform) {
        return this.isDoingErrorHandling() && this.transformErrorMeta.getTargetTransform().equals(targetTransform);
    }

    @Override
    public String getTypeId() {
        return this.transformPluginId;
    }

    @Override
    public String getPluginId() {
        return this.transformPluginId;
    }

    public boolean isMapping() {
        return STRING_ID_MAPPING.equals(this.transformPluginId);
    }

    public boolean isSingleThreader() {
        return STRING_ID_SINGLE_THREADER.equals(this.transformPluginId);
    }

    public boolean isEtlMetaInject() {
        return STRING_ID_ETL_META_INJECT.equals(this.transformPluginId);
    }

    public boolean isWorkflowExecutor() {
        return STRING_ID_WORKFLOW_EXECUTOR.equals(this.transformPluginId);
    }

    public boolean isMappingInput() {
        return STRING_ID_MAPPING_INPUT.equals(this.transformPluginId);
    }

    public boolean isMappingOutput() {
        return STRING_ID_MAPPING_OUTPUT.equals(this.transformPluginId);
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables) {
        return this.transform.getResourceDependencies(variables, this);
    }

    @Override
    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        return this.transform.exportResources(variables, definitions, iResourceNaming, metadataProvider);
    }

    public TransformPartitioningMeta getTargetTransformPartitioningMeta() {
        return this.targetTransformPartitioningMeta;
    }

    public void setTargetTransformPartitioningMeta(TransformPartitioningMeta targetTransformPartitioningMeta) {
        this.targetTransformPartitioningMeta = targetTransformPartitioningMeta;
    }

    public boolean isRepartitioning() {
        if (!this.isPartitioned() && this.isTargetPartitioned()) {
            return true;
        }
        return this.isPartitioned() && this.isTargetPartitioned() && !this.transformPartitioningMeta.equals(this.targetTransformPartitioningMeta);
    }

    public void setTransformPluginId(String transformPluginId) {
        this.transformPluginId = transformPluginId;
    }

    public void setParentPipelineMeta(PipelineMeta parentPipelineMeta) {
        this.parentPipelineMeta = parentPipelineMeta;
    }

    public PipelineMeta getParentPipelineMeta() {
        return this.parentPipelineMeta;
    }

    public IRowDistribution getRowDistribution() {
        return this.rowDistribution;
    }

    public void setRowDistribution(IRowDistribution rowDistribution) {
        this.rowDistribution = rowDistribution;
        if (rowDistribution != null) {
            this.setDistributes(true);
        }
        this.setChanged(true);
    }

    public String getCopiesString() {
        return this.copiesString;
    }

    public void setCopiesString(String copiesString) {
        this.copiesString = copiesString;
        this.copiesCache = null;
    }

    public void setAttributesMap(Map<String, Map<String, String>> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public Map<String, Map<String, String>> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttribute(String groupName, String key, String value) {
        Map<String, String> attributes = this.getAttributes(groupName);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            this.attributesMap.put(groupName, attributes);
        }
        attributes.put(key, value);
    }

    public void setAttributes(String groupName, Map<String, String> attributes) {
        this.attributesMap.put(groupName, attributes);
    }

    public Map<String, String> getAttributes(String groupName) {
        return this.attributesMap.get(groupName);
    }

    public String getAttribute(String groupName, String key) {
        Map<String, String> attributes = this.attributesMap.get(groupName);
        if (attributes == null) {
            return null;
        }
        return attributes.get(key);
    }

    public boolean isMissing() {
        return this.transform instanceof Missing;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public String getSuggestion() {
        return this.suggestion;
    }
}

