/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.metrics;

import com.google.bigtable.repackaged.io.opencensus.internal.Utils;
import com.google.bigtable.repackaged.io.opencensus.metrics.AutoValue_MetricOptions;
import com.google.bigtable.repackaged.io.opencensus.metrics.LabelKey;
import com.google.bigtable.repackaged.io.opencensus.metrics.LabelValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class MetricOptions {
    public abstract String getDescription();

    public abstract String getUnit();

    public abstract List<LabelKey> getLabelKeys();

    public abstract Map<LabelKey, LabelValue> getConstantLabels();

    public static Builder builder() {
        return new AutoValue_MetricOptions.Builder().setDescription("").setUnit("1").setLabelKeys(Collections.emptyList()).setConstantLabels(Collections.emptyMap());
    }

    MetricOptions() {
    }

    public static abstract class Builder {
        public abstract Builder setDescription(String var1);

        public abstract Builder setUnit(String var1);

        public abstract Builder setLabelKeys(List<LabelKey> var1);

        public abstract Builder setConstantLabels(Map<LabelKey, LabelValue> var1);

        abstract Map<LabelKey, LabelValue> getConstantLabels();

        abstract List<LabelKey> getLabelKeys();

        abstract MetricOptions autoBuild();

        public MetricOptions build() {
            this.setLabelKeys(Collections.unmodifiableList(new ArrayList<LabelKey>(this.getLabelKeys())));
            this.setConstantLabels(Collections.unmodifiableMap(new LinkedHashMap<LabelKey, LabelValue>(this.getConstantLabels())));
            MetricOptions options = this.autoBuild();
            Utils.checkListElementNotNull(options.getLabelKeys(), "labelKeys elements");
            Utils.checkMapElementNotNull(options.getConstantLabels(), "constantLabels elements");
            HashSet<String> labelKeyNamesMap = new HashSet<String>();
            for (LabelKey labelKey : options.getLabelKeys()) {
                if (labelKeyNamesMap.contains(labelKey.getKey())) {
                    throw new IllegalArgumentException("Invalid LabelKey in labelKeys");
                }
                labelKeyNamesMap.add(labelKey.getKey());
            }
            for (Map.Entry entry : options.getConstantLabels().entrySet()) {
                if (labelKeyNamesMap.contains(((LabelKey)entry.getKey()).getKey())) {
                    throw new IllegalArgumentException("Invalid LabelKey in constantLabels");
                }
                labelKeyNamesMap.add(((LabelKey)entry.getKey()).getKey());
            }
            return options;
        }

        Builder() {
        }
    }
}

