/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.util;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;

@InternalApi(value="For internal usage only")
public class TimestampConverter {
    private static final long FACTOR = 1000L;
    @VisibleForTesting
    static final long BIGTABLE_MAX_TIMESTAMP = 9223372036854775000L;
    @VisibleForTesting
    static final long HBASE_EFFECTIVE_MAX_TIMESTAMP = 9223372036854775L;

    public static long hbase2bigtable(long timestamp) {
        if (timestamp < 9223372036854775L) {
            return timestamp * 1000L;
        }
        return 9223372036854775000L;
    }

    public static long bigtable2hbase(long timestamp) {
        if (timestamp >= 9223372036854775000L) {
            return Long.MAX_VALUE;
        }
        return timestamp / 1000L;
    }
}

