/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.Utils;

public class DeleteAclsRequest
extends AbstractRequest {
    private static final String FILTERS = "filters";
    private static final Schema DELETE_ACLS_REQUEST_V0 = new Schema(new Field("filters", new ArrayOf(new Schema(CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME_FILTER, CommonFields.PRINCIPAL_FILTER, CommonFields.HOST_FILTER, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE))));
    private static final Schema DELETE_ACLS_REQUEST_V1 = new Schema(new Field("filters", new ArrayOf(new Schema(CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME_FILTER, CommonFields.RESOURCE_PATTERN_TYPE_FILTER, CommonFields.PRINCIPAL_FILTER, CommonFields.HOST_FILTER, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE))));
    private final List<AclBindingFilter> filters;

    public static Schema[] schemaVersions() {
        return new Schema[]{DELETE_ACLS_REQUEST_V0, DELETE_ACLS_REQUEST_V1};
    }

    DeleteAclsRequest(short version, List<AclBindingFilter> filters) {
        super(ApiKeys.DELETE_ACLS, version);
        this.filters = filters;
        this.validate(version, filters);
    }

    public DeleteAclsRequest(Struct struct, short version) {
        super(ApiKeys.DELETE_ACLS, version);
        this.filters = new ArrayList<AclBindingFilter>();
        for (Object filterStructObj : struct.getArray(FILTERS)) {
            Struct filterStruct = (Struct)filterStructObj;
            ResourcePatternFilter resourceFilter = RequestUtils.resourcePatternFilterFromStructFields(filterStruct);
            AccessControlEntryFilter aceFilter = RequestUtils.aceFilterFromStructFields(filterStruct);
            this.filters.add(new AclBindingFilter(resourceFilter, aceFilter));
        }
    }

    public List<AclBindingFilter> filters() {
        return this.filters;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DELETE_ACLS.requestSchema(this.version()));
        ArrayList<Struct> filterStructs = new ArrayList<Struct>();
        for (AclBindingFilter filter : this.filters) {
            Struct filterStruct = struct.instance(FILTERS);
            RequestUtils.resourcePatternFilterSetStructFields(filter.patternFilter(), filterStruct);
            RequestUtils.aceFilterSetStructFields(filter.entryFilter(), filterStruct);
            filterStructs.add(filterStruct);
        }
        struct.set(FILTERS, (Object)filterStructs.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                ArrayList<DeleteAclsResponse.AclFilterResponse> responses = new ArrayList<DeleteAclsResponse.AclFilterResponse>();
                for (int i = 0; i < this.filters.size(); ++i) {
                    responses.add(new DeleteAclsResponse.AclFilterResponse(ApiError.fromThrowable(throwable), Collections.emptySet()));
                }
                return new DeleteAclsResponse(throttleTimeMs, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.DELETE_ACLS.latestVersion()));
    }

    public static DeleteAclsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteAclsRequest(ApiKeys.DELETE_ACLS.parseRequest(version, buffer), version);
    }

    private void validate(short version, List<AclBindingFilter> filters) {
        boolean unsupported;
        if (version == 0 && (unsupported = filters.stream().map(AclBindingFilter::patternFilter).map(ResourcePatternFilter::patternType).anyMatch(patternType -> patternType != PatternType.LITERAL && patternType != PatternType.ANY))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        boolean unknown = filters.stream().anyMatch(AclBindingFilter::isUnknown);
        if (unknown) {
            throw new IllegalArgumentException("Filters contain UNKNOWN elements");
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteAclsRequest> {
        private final List<AclBindingFilter> filters;

        public Builder(List<AclBindingFilter> filters) {
            super(ApiKeys.DELETE_ACLS);
            this.filters = filters;
        }

        @Override
        public DeleteAclsRequest build(short version) {
            return new DeleteAclsRequest(version, this.filters);
        }

        public String toString() {
            return "(type=DeleteAclsRequest, filters=" + Utils.join(this.filters, ", ") + ")";
        }
    }
}

