/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.chm.ChmAccessor;
import org.apache.tika.parser.microsoft.chm.ChmAssert;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmParsingException;

public class ChmPmgiHeader
implements ChmAccessor<ChmPmgiHeader> {
    private static final long serialVersionUID = -2092282339894303701L;
    private byte[] signature = "PMGI".getBytes(StandardCharsets.UTF_8);
    private long free_space;
    private int dataRemained;
    private int currentPlace = 0;

    private int getDataRemained() {
        return this.dataRemained;
    }

    private void setDataRemained(int dataRemained) {
        this.dataRemained = dataRemained;
    }

    private int getCurrentPlace() {
        return this.currentPlace;
    }

    private void setCurrentPlace(int currentPlace) {
        this.currentPlace = currentPlace;
    }

    private void unmarshalCharArray(byte[] data, ChmPmgiHeader chmPmgiHeader, int count) throws ChmParsingException {
        int index = -1;
        ChmAssert.assertByteArrayNotNull(data);
        ChmAssert.assertChmAccessorNotNull(chmPmgiHeader);
        ChmAssert.assertPositiveInt(count);
        this.setDataRemained(data.length);
        index = ChmCommons.indexOf(data, "PMGI".getBytes(StandardCharsets.UTF_8));
        if (index >= 0) {
            System.arraycopy(data, index, chmPmgiHeader.getSignature(), 0, count);
        }
        this.setCurrentPlace(this.getCurrentPlace() + count);
        this.setDataRemained(this.getDataRemained() - count);
    }

    private long unmarshalUInt32(byte[] data, long dest) throws ChmParsingException {
        ChmAssert.assertByteArrayNotNull(data);
        if (4 > this.getDataRemained()) {
            throw new ChmParsingException("4 > dataLenght");
        }
        dest = data[this.getCurrentPlace()] & 0xFF | (data[this.getCurrentPlace() + 1] & 0xFF) << 8 | (data[this.getCurrentPlace() + 2] & 0xFF) << 16 | (data[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setDataRemained(this.getDataRemained() - 4);
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        return dest;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public long getFreeSpace() {
        return this.free_space;
    }

    protected void setFreeSpace(long free_space) {
        this.free_space = free_space;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("signature:=").append(new String(this.getSignature(), StandardCharsets.UTF_8)).append(", ");
        sb.append("free space:=").append(this.getFreeSpace()).append(System.getProperty("line.separator"));
        return sb.toString();
    }

    @Override
    public void parse(byte[] data, ChmPmgiHeader chmPmgiHeader) throws TikaException {
        if (data.length < 8) {
            throw new TikaException("we only know how to deal with a 0x8 byte structures");
        }
        chmPmgiHeader.unmarshalCharArray(data, chmPmgiHeader, 4);
        chmPmgiHeader.setFreeSpace(chmPmgiHeader.unmarshalUInt32(data, chmPmgiHeader.getFreeSpace()));
        if (!Arrays.equals(chmPmgiHeader.getSignature(), "PMGI".getBytes(StandardCharsets.UTF_8))) {
            throw new TikaException("it does not seem to be valid a PMGI signature, check ChmItsp index_root if it was -1, means no PMGI, use PMGL insted");
        }
    }
}

