/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.BooleanColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;

@Internal
public class BooleanSummaryAggregator
implements Aggregator<Boolean, BooleanColumnSummary> {
    private long trueCount = 0L;
    private long falseCount = 0L;
    private long nullCount = 0L;

    @Override
    public void aggregate(Boolean value) {
        if (value == null) {
            ++this.nullCount;
        } else if (value.booleanValue()) {
            ++this.trueCount;
        } else {
            ++this.falseCount;
        }
    }

    @Override
    public void combine(Aggregator<Boolean, BooleanColumnSummary> otherSameType) {
        BooleanSummaryAggregator other = (BooleanSummaryAggregator)otherSameType;
        this.trueCount += other.trueCount;
        this.falseCount += other.falseCount;
        this.nullCount += other.nullCount;
    }

    @Override
    public BooleanColumnSummary result() {
        return new BooleanColumnSummary(this.trueCount, this.falseCount, this.nullCount);
    }
}

