/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.FromRowUsingCreator;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public abstract class GetterBasedSchemaProvider
implements SchemaProvider {
    public abstract List<FieldValueGetter> fieldValueGetters(Class<?> var1, Schema var2);

    public abstract List<FieldValueTypeInformation> fieldValueTypeInformations(Class<?> var1, Schema var2);

    public abstract SchemaUserTypeCreator schemaTypeCreator(Class<?> var1, Schema var2);

    @Override
    public <T> SerializableFunction<T, Row> toRowFunction(TypeDescriptor<T> typeDescriptor) {
        Schema schema = this.schemaFor(typeDescriptor);
        return new ToRowWithValueGetters(schema);
    }

    @Override
    public <T> SerializableFunction<Row, T> fromRowFunction(TypeDescriptor<T> typeDescriptor) {
        Class clazz = (Class)typeDescriptor.getType();
        return new FromRowUsingCreator(clazz, this);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }

    private static class RowValueGettersFactory
    implements Factory<List<FieldValueGetter>> {
        private final Factory<List<FieldValueGetter>> gettersFactory;
        private final Factory<List<FieldValueGetter>> cachingGettersFactory;
        private static final FieldValueGetter IDENTITY = new FieldValueGetter(){

            public @Nullable Object get(Object object) {
                return object;
            }

            @Override
            public String name() {
                return null;
            }
        };

        static Factory<List<FieldValueGetter>> of(Factory<List<FieldValueGetter>> gettersFactory) {
            return new RowValueGettersFactory(gettersFactory).cachingGettersFactory;
        }

        RowValueGettersFactory(Factory<List<FieldValueGetter>> gettersFactory) {
            this.gettersFactory = gettersFactory;
            this.cachingGettersFactory = new CachingFactory<List<FieldValueGetter>>(this);
        }

        @Override
        public List<FieldValueGetter> create(Class<?> clazz, Schema schema) {
            List<FieldValueGetter> getters = this.gettersFactory.create(clazz, schema);
            ArrayList<FieldValueGetter> rowGetters = new ArrayList<FieldValueGetter>(getters.size());
            for (int i = 0; i < getters.size(); ++i) {
                rowGetters.add(this.rowValueGetter(getters.get(i), schema.getField(i).getType()));
            }
            return rowGetters;
        }

        static boolean needsConversion(Schema.FieldType type) {
            Schema.TypeName typeName = type.getTypeName();
            return typeName.equals((Object)Schema.TypeName.ROW) || typeName.isLogicalType() || (typeName.equals((Object)Schema.TypeName.ARRAY) || typeName.equals((Object)Schema.TypeName.ITERABLE)) && RowValueGettersFactory.needsConversion(type.getCollectionElementType()) || typeName.equals((Object)Schema.TypeName.MAP) && (RowValueGettersFactory.needsConversion(type.getMapKeyType()) || RowValueGettersFactory.needsConversion(type.getMapValueType()));
        }

        FieldValueGetter rowValueGetter(FieldValueGetter base, Schema.FieldType type) {
            Schema.TypeName typeName = type.getTypeName();
            if (!RowValueGettersFactory.needsConversion(type)) {
                return base;
            }
            if (typeName.equals((Object)Schema.TypeName.ROW)) {
                return new GetRow(base, type.getRowSchema(), this.cachingGettersFactory);
            }
            if (typeName.equals((Object)Schema.TypeName.ARRAY)) {
                Schema.FieldType elementType = type.getCollectionElementType();
                return elementType.getTypeName().equals((Object)Schema.TypeName.ROW) ? new GetEagerCollection(base, this.converter(elementType)) : new GetCollection(base, this.converter(elementType));
            }
            if (typeName.equals((Object)Schema.TypeName.ITERABLE)) {
                return new GetIterable(base, this.converter(type.getCollectionElementType()));
            }
            if (typeName.equals((Object)Schema.TypeName.MAP)) {
                return new GetMap(base, this.converter(type.getMapKeyType()), this.converter(type.getMapValueType()));
            }
            if (type.isLogicalType("OneOf")) {
                OneOfType oneOfType = type.getLogicalType(OneOfType.class);
                Schema oneOfSchema = oneOfType.getOneOfSchema();
                Map<String, Integer> values = oneOfType.getCaseEnumType().getValuesMap();
                HashMap converters = Maps.newHashMapWithExpectedSize((int)values.size());
                for (Map.Entry<String, Integer> kv : values.entrySet()) {
                    Schema.FieldType fieldType = oneOfSchema.getField(kv.getKey()).getType();
                    FieldValueGetter converter = this.converter(fieldType);
                    converters.put(kv.getValue(), converter);
                }
                return new GetOneOf(base, converters, oneOfType);
            }
            if (typeName.isLogicalType()) {
                return new GetLogicalInputType(base, type.getLogicalType());
            }
            return base;
        }

        FieldValueGetter converter(Schema.FieldType type) {
            return this.rowValueGetter(IDENTITY, type);
        }

        static abstract class Converter<T>
        implements FieldValueGetter {
            final FieldValueGetter getter;

            public Converter(FieldValueGetter getter) {
                this.getter = getter;
            }

            abstract Object convert(T var1);

            public @Nullable Object get(Object object) {
                Object value = this.getter.get(object);
                if (value == null) {
                    return null;
                }
                return this.convert(value);
            }

            public @Nullable Object getRaw(Object object) {
                return this.getter.getRaw(object);
            }

            @Override
            public String name() {
                return this.getter.name();
            }
        }

        static class GetOneOf
        extends Converter<OneOfType.Value> {
            final OneOfType oneOfType;
            final Map<Integer, FieldValueGetter> converters;

            GetOneOf(FieldValueGetter getter, Map<Integer, FieldValueGetter> converters, OneOfType oneOfType) {
                super(getter);
                this.converters = converters;
                this.oneOfType = oneOfType;
            }

            @Override
            Object convert(OneOfType.Value value) {
                EnumerationType.Value caseType = value.getCaseType();
                FieldValueGetter converter = this.converters.get(caseType.getValue());
                Preconditions.checkState((converter != null ? 1 : 0) != 0, (String)"Missing OneOf converter for case %s.", (Object)caseType);
                return this.oneOfType.createValue(caseType, converter.get(value.getValue()));
            }
        }

        static class GetLogicalInputType
        extends Converter<Object> {
            final Schema.LogicalType logicalType;

            GetLogicalInputType(FieldValueGetter getter, Schema.LogicalType logicalType) {
                super(getter);
                this.logicalType = logicalType;
            }

            @Override
            Object convert(Object value) {
                return this.logicalType.toInputType(value);
            }
        }

        static class GetMap
        extends Converter<Map<?, ?>> {
            final FieldValueGetter keyConverter;
            final FieldValueGetter valueConverter;

            GetMap(FieldValueGetter getter, FieldValueGetter keyConverter, FieldValueGetter valueConverter) {
                super(getter);
                this.keyConverter = keyConverter;
                this.valueConverter = valueConverter;
            }

            @Override
            Object convert(Map<?, ?> value) {
                HashMap returnMap = Maps.newHashMapWithExpectedSize((int)value.size());
                for (Map.Entry<?, ?> entry : value.entrySet()) {
                    returnMap.put(this.keyConverter.get(entry.getKey()), this.valueConverter.get(entry.getValue()));
                }
                return returnMap;
            }
        }

        static class GetIterable
        extends Converter<Iterable> {
            final FieldValueGetter converter;

            GetIterable(FieldValueGetter getter, FieldValueGetter converter) {
                super(getter);
                this.converter = converter;
            }

            @Override
            Object convert(Iterable value) {
                return Iterables.transform((Iterable)value, this.converter::get);
            }
        }

        static class GetCollection
        extends Converter<Collection> {
            final FieldValueGetter converter;

            GetCollection(FieldValueGetter getter, FieldValueGetter converter) {
                super(getter);
                this.converter = converter;
            }

            @Override
            Object convert(Collection collection) {
                if (collection instanceof List) {
                    return Lists.transform((List)((List)collection), this.converter::get);
                }
                return Collections2.transform((Collection)collection, this.converter::get);
            }
        }

        static class GetEagerCollection
        extends Converter<Collection> {
            final FieldValueGetter converter;

            GetEagerCollection(FieldValueGetter getter, FieldValueGetter converter) {
                super(getter);
                this.converter = converter;
            }

            @Override
            Object convert(Collection collection) {
                ArrayList newList = new ArrayList(collection.size());
                for (Object obj : collection) {
                    newList.add(this.converter.get(obj));
                }
                return newList;
            }
        }

        static class GetRow
        extends Converter<Object> {
            final Schema schema;
            final Factory<List<FieldValueGetter>> factory;

            GetRow(FieldValueGetter getter, Schema schema, Factory<List<FieldValueGetter>> factory) {
                super(getter);
                this.schema = schema;
                this.factory = factory;
            }

            @Override
            Object convert(Object value) {
                return Row.withSchema(this.schema).withFieldValueGetters(this.factory, value);
            }
        }
    }

    private class ToRowWithValueGetters<T>
    implements SerializableFunction<T, Row> {
        private final Schema schema;
        private final Factory<List<FieldValueGetter>> getterFactory;

        public ToRowWithValueGetters(Schema schema) {
            this.schema = schema;
            this.getterFactory = RowValueGettersFactory.of(GetterBasedSchemaProvider.this::fieldValueGetters);
        }

        @Override
        public Row apply(T input) {
            return Row.withSchema(this.schema).withFieldValueGetters(this.getterFactory, input);
        }

        private GetterBasedSchemaProvider getOuter() {
            return GetterBasedSchemaProvider.this;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToRowWithValueGetters that = (ToRowWithValueGetters)o;
            return this.getOuter().equals(that.getOuter()) && this.schema.equals(that.schema);
        }

        public int hashCode() {
            return Objects.hash(GetterBasedSchemaProvider.this, this.schema);
        }
    }
}

