/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;

public class DateTime
implements Schema.LogicalType<LocalDateTime, Row> {
    public static final String DATE_FIELD_NAME = "Date";
    public static final String TIME_FIELD_NAME = "Time";
    public static final Schema DATETIME_SCHEMA = Schema.builder().addInt64Field("Date").addInt64Field("Time").build();

    @Override
    public String getIdentifier() {
        return "beam:logical_type:datetime:v1";
    }

    @Override
    public Schema.FieldType getArgumentType() {
        return Schema.FieldType.STRING;
    }

    @Override
    public String getArgument() {
        return "";
    }

    @Override
    public Schema.FieldType getBaseType() {
        return Schema.FieldType.row(DATETIME_SCHEMA);
    }

    @Override
    public Row toBaseType(LocalDateTime input) {
        return input == null ? null : Row.withSchema(DATETIME_SCHEMA).addValues(input.toLocalDate().toEpochDay(), input.toLocalTime().toNanoOfDay()).build();
    }

    @Override
    public LocalDateTime toInputType(Row base) {
        return base == null ? null : LocalDateTime.of(LocalDate.ofEpochDay(base.getInt64(DATE_FIELD_NAME)), LocalTime.ofNanoOfDay(base.getInt64(TIME_FIELD_NAME)));
    }
}

