/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.setvalueconstant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.setvalueconstant.SetValueConstantMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SetValueConstantDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SetValueConstantMeta.class;
    private final SetValueConstantMeta input;
    private final Map<String, Integer> inputFields;
    private TableView wFields;
    private ColumnInfo[] colinf;
    private Button wUseVars;

    public SetValueConstantDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (SetValueConstantMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        ModifyListener oldlsMod = lsMod;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SetValueConstantDialog.Shell.Title", (String[])new String[0]));
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"SetValueConstantDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlUseVars = new Label((Composite)this.shell, 131072);
        wlUseVars.setText(BaseMessages.getString(PKG, (String)"SetValueConstantDialog.useVars.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUseVars);
        FormData fdlUseVars = new FormData();
        fdlUseVars.left = new FormAttachment(0, 0);
        fdlUseVars.right = new FormAttachment(middle, -margin);
        fdlUseVars.top = new FormAttachment((Control)this.wTransformName, 2 * margin);
        wlUseVars.setLayoutData((Object)fdlUseVars);
        this.wUseVars = new Button((Composite)this.shell, 32);
        this.wUseVars.setToolTipText(BaseMessages.getString(PKG, (String)"SetValueConstantDialog.useVars.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wUseVars);
        FormData fdUseVars = new FormData();
        fdUseVars.left = new FormAttachment(middle, 0);
        fdUseVars.top = new FormAttachment((Control)wlUseVars, 0, 0x1000000);
        fdUseVars.right = new FormAttachment(100, 0);
        this.wUseVars.setLayoutData((Object)fdUseVars);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"SetValueConstantDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wUseVars, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int fieldsCols = 4;
        int FieldsRows = this.input.getFields().size();
        this.colinf = new ColumnInfo[fieldsCols];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SetValueConstantDialog.Fieldname.Column", (String[])new String[0]), 2, new String[0], false);
        this.colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SetValueConstantDialog.Value.Column", (String[])new String[0]), 1, false);
        this.colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SetValueConstantDialog.Value.ConversionMask", (String[])new String[0]), 2, Const.getDateFormats());
        this.colinf[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SetValueConstantDialog.Value.SetEmptyString", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])});
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, FieldsRows, oldlsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            if (r != null) {
                ITableItemInsertListener insertListener = (tableItem, v) -> true;
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)insertListener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData() {
        this.wUseVars.setSelection(this.input.isUseVars());
        Table table = this.wFields.table;
        if (this.input.getFields().size() > 0) {
            table.removeAll();
        }
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            SetValueConstantMeta.Field field = this.input.getField(i);
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            if (field.getFieldName() != null) {
                ti.setText(1, field.getFieldName());
            }
            if (field.getReplaceValue() != null) {
                ti.setText(2, field.getReplaceValue());
            }
            if (field.getReplaceMask() != null) {
                ti.setText(3, field.getReplaceMask());
            }
            ti.setText(4, field.isEmptyString() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
        }
        this.wFields.setRowNums();
        this.wFields.removeEmptyRows();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setUseVars(this.wUseVars.getSelection());
        int count = this.wFields.nrNonEmpty();
        ArrayList<SetValueConstantMeta.Field> fields = new ArrayList<SetValueConstantMeta.Field>();
        for (int i = 0; i < count; ++i) {
            TableItem ti = this.wFields.getNonEmpty(i);
            SetValueConstantMeta.Field field = new SetValueConstantMeta.Field();
            field.setFieldName(ti.getText(1));
            field.setEmptyString(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(ti.getText(4)));
            field.setReplaceValue(field.isEmptyString() ? "" : ti.getText(2));
            field.setReplaceMask(field.isEmptyString() ? "" : ti.getText(3));
            fields.add(field);
        }
        this.input.setFields(fields);
        this.dispose();
    }
}

