/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow.delegates;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.DefaultLogLevel;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.server.HopServer;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.workflow.dialog.WorkflowExecutionConfigurationDialog;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class HopGuiWorkflowRunDelegate {
    private static final Class<?> PKG = HopGui.class;
    private HopGuiWorkflowGraph workflowGraph;
    private HopGui hopGui;
    private WorkflowExecutionConfiguration workflowExecutionConfiguration;
    private List<WorkflowMeta> workflowMap;

    public HopGuiWorkflowRunDelegate(HopGui hopGui, HopGuiWorkflowGraph workflowGraph) {
        this.hopGui = hopGui;
        this.workflowGraph = workflowGraph;
        this.workflowExecutionConfiguration = new WorkflowExecutionConfiguration();
        this.workflowExecutionConfiguration.setGatheringMetrics(true);
        this.workflowMap = new ArrayList<WorkflowMeta>();
    }

    public void executeWorkflow(IVariables variables, WorkflowMeta workflowMeta, String startActionName) throws HopException {
        if (workflowMeta == null) {
            return;
        }
        WorkflowExecutionConfiguration executionConfiguration = this.getWorkflowExecutionConfiguration();
        HashMap variableMap = new HashMap();
        variableMap.putAll(executionConfiguration.getVariablesMap());
        executionConfiguration.setVariablesMap(variableMap);
        executionConfiguration.getUsedVariables(workflowMeta, variables);
        executionConfiguration.setStartActionName(startActionName);
        executionConfiguration.setLogLevel(DefaultLogLevel.getLogLevel());
        WorkflowExecutionConfigurationDialog dialog = this.newWorkflowExecutionConfigurationDialog(executionConfiguration, workflowMeta);
        if (!workflowMeta.isShowDialog() || dialog.open()) {
            this.workflowGraph.workflowLogDelegate.addWorkflowLog();
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)this.workflowGraph.getVariables(), (String)HopExtensionPoint.HopGuiWorkflowExecutionConfiguration.id, (Object)executionConfiguration);
            this.workflowGraph.start(executionConfiguration);
        }
    }

    @VisibleForTesting
    WorkflowExecutionConfigurationDialog newWorkflowExecutionConfigurationDialog(WorkflowExecutionConfiguration executionConfiguration, WorkflowMeta workflowMeta) {
        return new WorkflowExecutionConfigurationDialog(this.hopGui.getShell(), executionConfiguration, workflowMeta);
    }

    private static void showSaveJobBeforeRunningDialog(Shell shell) {
        MessageBox m = new MessageBox(shell, 40);
        m.setText(BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.SaveJobBeforeRunning.Title", (String[])new String[0]));
        m.setMessage(BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.SaveJobBeforeRunning.Message", (String[])new String[0]));
        m.open();
    }

    private void monitorRemoteJob(WorkflowMeta workflowMeta, String serverObjectId, HopServer remoteHopServer) {
        Thread thread = new Thread(() -> remoteHopServer.monitorRemoteWorkflow(this.hopGui.getVariables(), this.hopGui.getLog(), serverObjectId, workflowMeta.toString()));
        thread.setName("Monitor remote workflow '" + workflowMeta.getName() + "', carte object id=" + serverObjectId + ", hop server: " + remoteHopServer.getName());
        thread.start();
    }

    public HopGuiWorkflowGraph getWorkflowGraph() {
        return this.workflowGraph;
    }

    public void setWorkflowGraph(HopGuiWorkflowGraph workflowGraph) {
        this.workflowGraph = workflowGraph;
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    public WorkflowExecutionConfiguration getWorkflowExecutionConfiguration() {
        return this.workflowExecutionConfiguration;
    }

    public void setWorkflowExecutionConfiguration(WorkflowExecutionConfiguration workflowExecutionConfiguration) {
        this.workflowExecutionConfiguration = workflowExecutionConfiguration;
    }

    public List<WorkflowMeta> getWorkflowMap() {
        return this.workflowMap;
    }

    public void setWorkflowMap(List<WorkflowMeta> jobMap) {
        this.workflowMap = jobMap;
    }
}

