/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.processfiles;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.processfiles.ProcessFilesMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProcessFilesDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ProcessFilesMeta.class;
    private CCombo wSourceFileNameField;
    private Label wlTargetFileNameField;
    private CCombo wTargetFileNameField;
    private Button wAddResult;
    private Label wlAddResult;
    private Button wOverwriteTarget;
    private Label wlOverwriteTarget;
    private Button wCreateParentFolder;
    private Label wlCreateParentFolder;
    private Button wSimulate;
    private final ProcessFilesMeta input;
    private CCombo wOperation;
    private boolean gotPreviousFields = false;

    public ProcessFilesDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ProcessFilesMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsButtonChanged = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessFilesDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Group wSettingsGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)wSettingsGroup);
        wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.wSettingsGroup.Label", (String[])new String[0]));
        FormLayout settingGroupLayout = new FormLayout();
        settingGroupLayout.marginWidth = 10;
        settingGroupLayout.marginHeight = 10;
        wSettingsGroup.setLayout((Layout)settingGroupLayout);
        Label wlOperation = new Label((Composite)wSettingsGroup, 131072);
        wlOperation.setText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.Operation.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOperation);
        FormData fdlOperation = new FormData();
        fdlOperation.left = new FormAttachment(0, 0);
        fdlOperation.right = new FormAttachment(middle, -margin);
        fdlOperation.top = new FormAttachment((Control)this.wTransformName, margin);
        wlOperation.setLayoutData((Object)fdlOperation);
        this.wOperation = new CCombo((Composite)wSettingsGroup, 2056);
        this.props.setLook((Control)this.wOperation);
        this.wOperation.addModifyListener(lsMod);
        FormData fdOperation = new FormData();
        fdOperation.left = new FormAttachment(middle, 0);
        fdOperation.top = new FormAttachment((Control)this.wTransformName, margin);
        fdOperation.right = new FormAttachment(100, -margin);
        this.wOperation.setLayoutData((Object)fdOperation);
        this.wOperation.setItems(ProcessFilesMeta.operationTypeDesc);
        this.wOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessFilesDialog.this.updateOperation();
            }
        });
        this.wlCreateParentFolder = new Label((Composite)wSettingsGroup, 131072);
        this.wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.CreateParentFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCreateParentFolder);
        FormData fdlCreateParentFolder = new FormData();
        fdlCreateParentFolder.left = new FormAttachment(0, 0);
        fdlCreateParentFolder.top = new FormAttachment((Control)this.wOperation, margin);
        fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        this.wlCreateParentFolder.setLayoutData((Object)fdlCreateParentFolder);
        this.wCreateParentFolder = new Button((Composite)wSettingsGroup, 32);
        this.props.setLook((Control)this.wCreateParentFolder);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.CreateParentFolder.Tooltip", (String[])new String[0]));
        this.wCreateParentFolder.addSelectionListener((SelectionListener)lsButtonChanged);
        FormData fdCreateParentFolder = new FormData();
        fdCreateParentFolder.left = new FormAttachment(middle, 0);
        fdCreateParentFolder.top = new FormAttachment((Control)this.wlCreateParentFolder, 0, 0x1000000);
        this.wCreateParentFolder.setLayoutData((Object)fdCreateParentFolder);
        this.wlOverwriteTarget = new Label((Composite)wSettingsGroup, 131072);
        this.wlOverwriteTarget.setText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.OverwriteTarget.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOverwriteTarget);
        FormData fdlOverwriteTarget = new FormData();
        fdlOverwriteTarget.left = new FormAttachment(0, 0);
        fdlOverwriteTarget.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        fdlOverwriteTarget.right = new FormAttachment(middle, -margin);
        this.wlOverwriteTarget.setLayoutData((Object)fdlOverwriteTarget);
        this.wOverwriteTarget = new Button((Composite)wSettingsGroup, 32);
        this.props.setLook((Control)this.wOverwriteTarget);
        this.wOverwriteTarget.setToolTipText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.OverwriteTarget.Tooltip", (String[])new String[0]));
        this.wOverwriteTarget.addSelectionListener((SelectionListener)lsButtonChanged);
        FormData fdOverwriteTarget = new FormData();
        fdOverwriteTarget.left = new FormAttachment(middle, 0);
        fdOverwriteTarget.top = new FormAttachment((Control)this.wlOverwriteTarget, 0, 0x1000000);
        this.wOverwriteTarget.setLayoutData((Object)fdOverwriteTarget);
        this.wlAddResult = new Label((Composite)wSettingsGroup, 131072);
        this.wlAddResult.setText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.AddResult.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)this.wOverwriteTarget, margin);
        fdlAddResult.right = new FormAttachment(middle, -margin);
        this.wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)wSettingsGroup, 32);
        this.props.setLook((Control)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.AddResult.Tooltip", (String[])new String[0]));
        this.wAddResult.addSelectionListener((SelectionListener)lsButtonChanged);
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(middle, 0);
        fdAddResult.top = new FormAttachment((Control)this.wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        Label wlSimulate = new Label((Composite)wSettingsGroup, 131072);
        wlSimulate.setText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.Simulate.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSimulate);
        FormData fdlSimulate = new FormData();
        fdlSimulate.left = new FormAttachment(0, 0);
        fdlSimulate.top = new FormAttachment((Control)this.wAddResult, margin);
        fdlSimulate.right = new FormAttachment(middle, -margin);
        wlSimulate.setLayoutData((Object)fdlSimulate);
        this.wSimulate = new Button((Composite)wSettingsGroup, 32);
        this.props.setLook((Control)this.wSimulate);
        this.wSimulate.setToolTipText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.Simulate.Tooltip", (String[])new String[0]));
        this.wSimulate.addSelectionListener((SelectionListener)lsButtonChanged);
        FormData fdSimulate = new FormData();
        fdSimulate.left = new FormAttachment(middle, 0);
        fdSimulate.top = new FormAttachment((Control)wlSimulate, 0, 0x1000000);
        this.wSimulate.setLayoutData((Object)fdSimulate);
        FormData fdSettingsGroup = new FormData();
        fdSettingsGroup.left = new FormAttachment(0, margin);
        fdSettingsGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSettingsGroup.right = new FormAttachment(100, -margin);
        wSettingsGroup.setLayoutData((Object)fdSettingsGroup);
        Label wlSourceFileNameField = new Label((Composite)this.shell, 131072);
        wlSourceFileNameField.setText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.SourceFileNameField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSourceFileNameField);
        FormData fdlSourceFileNameField = new FormData();
        fdlSourceFileNameField.left = new FormAttachment(0, 0);
        fdlSourceFileNameField.right = new FormAttachment(middle, -margin);
        fdlSourceFileNameField.top = new FormAttachment((Control)wSettingsGroup, 2 * margin);
        wlSourceFileNameField.setLayoutData((Object)fdlSourceFileNameField);
        this.wSourceFileNameField = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wSourceFileNameField);
        this.wSourceFileNameField.setEditable(true);
        this.wSourceFileNameField.addModifyListener(lsMod);
        FormData fdSourceFileNameField = new FormData();
        fdSourceFileNameField.left = new FormAttachment(middle, 0);
        fdSourceFileNameField.top = new FormAttachment((Control)wSettingsGroup, 2 * margin);
        fdSourceFileNameField.right = new FormAttachment(100, -margin);
        this.wSourceFileNameField.setLayoutData((Object)fdSourceFileNameField);
        this.wSourceFileNameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ProcessFilesDialog.this.shell.getDisplay(), 1);
                ProcessFilesDialog.this.shell.setCursor(busy);
                ProcessFilesDialog.this.get();
                ProcessFilesDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlTargetFileNameField = new Label((Composite)this.shell, 131072);
        this.wlTargetFileNameField.setText(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.TargetFileNameField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTargetFileNameField);
        FormData fdlTargetFileNameField = new FormData();
        fdlTargetFileNameField.left = new FormAttachment(0, 0);
        fdlTargetFileNameField.right = new FormAttachment(middle, -margin);
        fdlTargetFileNameField.top = new FormAttachment((Control)this.wSourceFileNameField, margin);
        this.wlTargetFileNameField.setLayoutData((Object)fdlTargetFileNameField);
        this.wTargetFileNameField = new CCombo((Composite)this.shell, 2056);
        this.wTargetFileNameField.setEditable(true);
        this.props.setLook((Control)this.wTargetFileNameField);
        this.wTargetFileNameField.addModifyListener(lsMod);
        FormData fdTargetFileNameField = new FormData();
        fdTargetFileNameField.left = new FormAttachment(middle, 0);
        fdTargetFileNameField.top = new FormAttachment((Control)this.wSourceFileNameField, margin);
        fdTargetFileNameField.right = new FormAttachment(100, -margin);
        this.wTargetFileNameField.setLayoutData((Object)fdTargetFileNameField);
        this.wTargetFileNameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ProcessFilesDialog.this.shell.getDisplay(), 1);
                ProcessFilesDialog.this.shell.setCursor(busy);
                ProcessFilesDialog.this.get();
                ProcessFilesDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wTargetFileNameField);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.updateOperation();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void updateOperation() {
        this.wlOverwriteTarget.setEnabled(ProcessFilesMeta.getOperationTypeByDesc(this.wOperation.getText()) != 2);
        this.wOverwriteTarget.setEnabled(ProcessFilesMeta.getOperationTypeByDesc(this.wOperation.getText()) != 2);
        this.wlAddResult.setEnabled(ProcessFilesMeta.getOperationTypeByDesc(this.wOperation.getText()) != 2);
        this.wAddResult.setEnabled(ProcessFilesMeta.getOperationTypeByDesc(this.wOperation.getText()) != 2);
        this.wlTargetFileNameField.setEnabled(ProcessFilesMeta.getOperationTypeByDesc(this.wOperation.getText()) != 2);
        this.wTargetFileNameField.setEnabled(ProcessFilesMeta.getOperationTypeByDesc(this.wOperation.getText()) != 2);
        this.wlCreateParentFolder.setEnabled(ProcessFilesMeta.getOperationTypeByDesc(this.wOperation.getText()) != 2);
        this.wCreateParentFolder.setEnabled(ProcessFilesMeta.getOperationTypeByDesc(this.wOperation.getText()) != 2);
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ProcessFilesDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getSourceFilenameField() != null) {
            this.wSourceFileNameField.setText(this.input.getSourceFilenameField());
        }
        if (this.input.getTargetFilenameField() != null) {
            this.wTargetFileNameField.setText(this.input.getTargetFilenameField());
        }
        this.wOperation.setText(ProcessFilesMeta.getOperationTypeDesc(this.input.getOperationType()));
        this.wAddResult.setSelection(this.input.isAddResultFilenames());
        this.wOverwriteTarget.setSelection(this.input.isOverwriteTargetFile());
        this.wCreateParentFolder.setSelection(this.input.isCreateParentFolder());
        this.wSimulate.setSelection(this.input.isSimulate());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setSourceFilenameField(this.wSourceFileNameField.getText());
        this.input.setTargetFilenameField(this.wTargetFileNameField.getText());
        this.input.setOperationType(ProcessFilesMeta.getOperationTypeByDesc(this.wOperation.getText()));
        this.input.setAddResultFilenames(this.wAddResult.getSelection());
        this.input.setOverwriteTargetFile(this.wOverwriteTarget.getSelection());
        this.input.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        this.input.setSimulate(this.wSimulate.getSelection());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            try {
                String source = this.wSourceFileNameField.getText();
                String target = this.wTargetFileNameField.getText();
                this.wSourceFileNameField.removeAll();
                this.wTargetFileNameField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wSourceFileNameField.setItems(r.getFieldNames());
                    this.wTargetFileNameField.setItems(r.getFieldNames());
                    if (source != null) {
                        this.wSourceFileNameField.setText(source);
                    }
                    if (target != null) {
                        this.wTargetFileNameField.setText(target);
                    }
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ProcessFilesDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ProcessFilesDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

