/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.engines.flink;

import java.util.Arrays;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.hop.beam.engines.BeamPipelineRunConfiguration;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.metadata.RunnerType;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

@GuiPlugin
public class BeamFlinkPipelineRunConfiguration
extends BeamPipelineRunConfiguration
implements IBeamPipelineEngineRunConfiguration,
IVariables,
Cloneable {
    @GuiWidgetElement(order="20010-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="The Flink master", toolTip="Address of the Flink Master where the Pipeline should be executed. Can either be of the form \"host:port\" or one of the special values [local], [collection] or [auto].")
    @HopMetadataProperty
    private String flinkMaster;
    @GuiWidgetElement(order="20020-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Parallelism", toolTip="The degree of parallelism to be used when distributing operations onto workers. If the parallelism is not set, the configured Flink default is used, or 1 if none can be found.")
    @HopMetadataProperty
    private String flinkParallelism;
    @GuiWidgetElement(order="20030-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Checkpointing interval", toolTip="The interval in milliseconds at which to trigger checkpoints of the running pipeline. Default: No checkpointing.")
    @HopMetadataProperty
    private String flinkCheckpointingInterval;
    @GuiWidgetElement(order="20040-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Checkpointing mode", toolTip="The checkpointing mode that defines consistency guarantee.")
    @HopMetadataProperty
    private String flinkCheckpointingMode;
    @GuiWidgetElement(order="20050-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Checkpointing timeout (ms)", toolTip="The maximum time in milliseconds that a checkpoint may take before being discarded.")
    @HopMetadataProperty
    private String flinkCheckpointTimeoutMillis;
    @GuiWidgetElement(order="20060-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Minimum pause between checkpoints", toolTip="The minimal pause in milliseconds before the next checkpoint is triggered.")
    @HopMetadataProperty
    private String flinkMinPauseBetweenCheckpoints;
    @GuiWidgetElement(order="20070-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Fail on checkpointing errors?", toolTip="Sets the expected behaviour for tasks in case that they encounter an error in their checkpointing procedure. If this is set to true, the task will fail on checkpointing error. If this is set to false, the task will only decline a the checkpoint and continue running. ")
    @HopMetadataProperty
    private String flinkFailingOnCheckpointingErrors;
    @GuiWidgetElement(order="20080-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Number of execution retries", toolTip="Sets the number of times that failed tasks are re-executed. A value of zero effectively disables fault tolerance. A value of -1 indicates that the system default value (as defined in the configuration) should be used.")
    @HopMetadataProperty
    private String flinkNumberOfExecutionRetries;
    @GuiWidgetElement(order="20090-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Execution retry delay (ms)", toolTip="Sets the delay in milliseconds between executions. A value of -1indicates that the default value should be used.")
    @HopMetadataProperty
    private String flinkExecutionRetryDelay;
    @GuiWidgetElement(order="20100-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Object re-use", toolTip="Sets the behavior of reusing objects.")
    @HopMetadataProperty
    private String flinkObjectReuse;
    @GuiWidgetElement(order="20110-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Disable metrics", toolTip="Disable Beam metrics in Flink Runner")
    @HopMetadataProperty
    private String flinkDisableMetrics;
    @GuiWidgetElement(order="20120-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Disable externalized checkpoints", toolTip="Enables or disables externalized checkpoints. Works in conjunction with CheckpointingInterval")
    @HopMetadataProperty
    private String flinkExternalizedCheckpointsEnabled;
    @GuiWidgetElement(order="20130-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Retain externalized checkpoints on cancellation", toolTip="Sets the behavior of externalized checkpoints on cancellation.")
    @HopMetadataProperty
    private String flinkRetainExternalizedCheckpointsOnCancellation;
    @GuiWidgetElement(order="20140-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Maximum bundle size", toolTip="The maximum number of elements in a bundle.")
    @HopMetadataProperty
    private String flinkMaxBundleSize;
    @GuiWidgetElement(order="20150-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Maximum bundle time (ms)", toolTip="The maximum time to wait before finalising a bundle (in milliseconds).")
    @HopMetadataProperty
    private String flinkMaxBundleTimeMills;
    @GuiWidgetElement(order="20160-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Shutdown sources on final watermark", toolTip="Shuts down sources which have been idle for the configured time of milliseconds. Once a source has been shut down, checkpointing is not possible anymore. Shutting down the sources eventually leads to pipeline shutdown (=Flink job finishes) once all input has been processed. Unless explicitly set, this will default to Long.MAX_VALUE when checkpointing is enabled and to 0 when checkpointing is disabled. See https://issues.apache.org/jira/browse/FLINK-2491 for progress on this issue.")
    @HopMetadataProperty
    private String flinkShutdownSourcesAfterIdleMs;
    @GuiWidgetElement(order="20170-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Latency tracking interval", toolTip="Interval in milliseconds for sending latency tracking marks from the sources to the sinks. Interval value <= 0 disables the feature.")
    @HopMetadataProperty
    private String flinkLatencyTrackingInterval;
    @GuiWidgetElement(order="20180-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Auto watermark interval", toolTip="The interval in milliseconds for automatic watermark emission.")
    @HopMetadataProperty
    private String flinkAutoWatermarkInterval;
    @GuiWidgetElement(order="20190-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Batch execution mode", toolTip="Flink mode for data exchange of batch pipelines. Set this to BATCH_FORCED if pipelines get blocked, see https://issues.apache.org/jira/browse/FLINK-10672")
    @HopMetadataProperty
    private String flinkExecutionModeForBatch;

    public BeamFlinkPipelineRunConfiguration() {
        this.tempLocation = "file://" + System.getProperty("java.io.tmpdir");
    }

    public BeamFlinkPipelineRunConfiguration(String flinkMaster, String flinkParallelism) {
        this();
        this.flinkMaster = flinkMaster;
        this.flinkParallelism = flinkParallelism;
    }

    public BeamFlinkPipelineRunConfiguration(BeamFlinkPipelineRunConfiguration config) {
        super(config);
        this.flinkMaster = config.flinkMaster;
        this.flinkParallelism = config.flinkParallelism;
        this.flinkCheckpointingInterval = config.flinkCheckpointingInterval;
        this.flinkCheckpointingMode = config.flinkCheckpointingMode;
        this.flinkCheckpointTimeoutMillis = config.flinkCheckpointTimeoutMillis;
        this.flinkMinPauseBetweenCheckpoints = config.flinkMinPauseBetweenCheckpoints;
        this.flinkFailingOnCheckpointingErrors = config.flinkFailingOnCheckpointingErrors;
        this.flinkNumberOfExecutionRetries = config.flinkNumberOfExecutionRetries;
        this.flinkExecutionRetryDelay = config.flinkExecutionRetryDelay;
        this.flinkObjectReuse = config.flinkObjectReuse;
        this.flinkDisableMetrics = config.flinkDisableMetrics;
        this.flinkExternalizedCheckpointsEnabled = config.flinkExternalizedCheckpointsEnabled;
        this.flinkRetainExternalizedCheckpointsOnCancellation = config.flinkRetainExternalizedCheckpointsOnCancellation;
        this.flinkMaxBundleSize = config.flinkMaxBundleSize;
        this.flinkMaxBundleTimeMills = config.flinkMaxBundleTimeMills;
        this.flinkShutdownSourcesAfterIdleMs = config.flinkShutdownSourcesAfterIdleMs;
        this.flinkLatencyTrackingInterval = config.flinkLatencyTrackingInterval;
        this.flinkAutoWatermarkInterval = config.flinkAutoWatermarkInterval;
        this.flinkExecutionModeForBatch = config.flinkExecutionModeForBatch;
    }

    public BeamFlinkPipelineRunConfiguration clone() {
        return new BeamFlinkPipelineRunConfiguration(this);
    }

    @Override
    public RunnerType getRunnerType() {
        return RunnerType.Flink;
    }

    @Override
    public PipelineOptions getPipelineOptions() throws HopException {
        try {
            CheckpointingMode mode;
            int value;
            FlinkPipelineOptions options = (FlinkPipelineOptions)PipelineOptionsFactory.as(FlinkPipelineOptions.class);
            if (StringUtils.isNotEmpty((String)this.getFlinkMaster())) {
                options.setFlinkMaster(this.resolve(this.getFlinkMaster()));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkParallelism()) && (value = Const.toInt((String)this.resolve(this.getFlinkParallelism()), (int)-1)) > 0) {
                options.setParallelism(Integer.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkCheckpointingInterval()) && (value = Const.toLong((String)this.resolve(this.getFlinkCheckpointingInterval()), (long)-1L)) > 0L) {
                options.setCheckpointingInterval(Long.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkCheckpointingMode())) {
                String modeString = this.resolve(this.getFlinkCheckpointingMode());
                try {
                    mode = CheckpointingMode.valueOf((String)modeString);
                    options.setCheckpointingMode(modeString);
                }
                catch (Exception e) {
                    throw new HopException("Unable to parse flink check pointing mode '" + modeString + "'", (Throwable)e);
                }
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkCheckpointTimeoutMillis()) && (value = Const.toLong((String)this.resolve(this.getFlinkCheckpointTimeoutMillis()), (long)-1L)) > 0L) {
                options.setCheckpointTimeoutMillis(Long.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkMinPauseBetweenCheckpoints()) && (value = Const.toLong((String)this.resolve(this.getFlinkMinPauseBetweenCheckpoints()), (long)-1L)) > 0L) {
                options.setMinPauseBetweenCheckpoints(Long.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkNumberOfExecutionRetries()) && (value = Const.toInt((String)this.resolve(this.getFlinkNumberOfExecutionRetries()), (int)-1)) >= 0) {
                options.setNumberOfExecutionRetries(Integer.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkExecutionRetryDelay()) && (value = Const.toLong((String)this.resolve(this.getFlinkExecutionRetryDelay()), (long)-1L)) > 0L) {
                options.setExecutionRetryDelay(Long.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkObjectReuse())) {
                String str = this.resolve(this.getFlinkObjectReuse());
                boolean value2 = "Y".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str);
                options.setObjectReuse(Boolean.valueOf(value2));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkDisableMetrics())) {
                String str = this.resolve(this.getFlinkDisableMetrics());
                boolean value3 = "Y".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str);
                options.setDisableMetrics(Boolean.valueOf(!value3));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkExternalizedCheckpointsEnabled())) {
                String str = this.resolve(this.getFlinkExternalizedCheckpointsEnabled());
                boolean value4 = "Y".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str);
                options.setExternalizedCheckpointsEnabled(Boolean.valueOf(value4));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkRetainExternalizedCheckpointsOnCancellation())) {
                String str = this.resolve(this.getFlinkRetainExternalizedCheckpointsOnCancellation());
                boolean value5 = "Y".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str);
                options.setRetainExternalizedCheckpointsOnCancellation(Boolean.valueOf(value5));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkMaxBundleSize()) && (value = Const.toLong((String)this.resolve(this.getFlinkMaxBundleSize()), (long)-1L)) > 0L) {
                options.setMaxBundleSize(Long.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkMaxBundleTimeMills()) && (value = Const.toLong((String)this.resolve(this.getFlinkMaxBundleTimeMills()), (long)-1L)) > 0L) {
                options.setMaxBundleSize(Long.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkFailingOnCheckpointingErrors())) {
                String str = this.resolve(this.getFlinkFailingOnCheckpointingErrors());
                boolean value6 = "Y".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str);
                options.setFailOnCheckpointingErrors(Boolean.valueOf(value6));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkShutdownSourcesAfterIdleMs())) {
                String str = this.resolve(this.getFlinkShutdownSourcesAfterIdleMs());
                long value7 = Const.toLong((String)str, (long)-1L);
                options.setShutdownSourcesAfterIdleMs(Long.valueOf(value7));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkLatencyTrackingInterval()) && (value = Const.toLong((String)this.resolve(this.getFlinkLatencyTrackingInterval()), (long)-1L)) > 0L) {
                options.setLatencyTrackingInterval(Long.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkAutoWatermarkInterval()) && (value = Const.toLong((String)this.resolve(this.getFlinkAutoWatermarkInterval()), (long)-1L)) > 0L) {
                options.setAutoWatermarkInterval(Long.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkExecutionModeForBatch())) {
                String modeString = this.resolve(this.getFlinkExecutionModeForBatch());
                mode = ExecutionMode.valueOf((String)modeString);
                try {
                    options.setExecutionModeForBatch(modeString);
                }
                catch (Exception e) {
                    throw new HopException("Unable to parse flink execution mode for batch '" + modeString + "'", (Throwable)e);
                }
            }
            if (StringUtils.isNotEmpty((String)this.getFatJar())) {
                options.setFilesToStage(Arrays.asList(this.resolve(this.fatJar)));
            }
            return options;
        }
        catch (Throwable e) {
            throw new HopException("Error building Flink pipeline options", e);
        }
    }

    @Override
    public boolean isRunningAsynchronous() {
        return true;
    }

    public String getFlinkMaster() {
        return this.flinkMaster;
    }

    public void setFlinkMaster(String flinkMaster) {
        this.flinkMaster = flinkMaster;
    }

    public String getFlinkParallelism() {
        return this.flinkParallelism;
    }

    public void setFlinkParallelism(String flinkParallelism) {
        this.flinkParallelism = flinkParallelism;
    }

    public String getFlinkCheckpointingInterval() {
        return this.flinkCheckpointingInterval;
    }

    public void setFlinkCheckpointingInterval(String flinkCheckpointingInterval) {
        this.flinkCheckpointingInterval = flinkCheckpointingInterval;
    }

    public String getFlinkCheckpointingMode() {
        return this.flinkCheckpointingMode;
    }

    public void setFlinkCheckpointingMode(String flinkCheckpointingMode) {
        this.flinkCheckpointingMode = flinkCheckpointingMode;
    }

    public String getFlinkCheckpointTimeoutMillis() {
        return this.flinkCheckpointTimeoutMillis;
    }

    public void setFlinkCheckpointTimeoutMillis(String flinkCheckpointTimeoutMillis) {
        this.flinkCheckpointTimeoutMillis = flinkCheckpointTimeoutMillis;
    }

    public String getFlinkMinPauseBetweenCheckpoints() {
        return this.flinkMinPauseBetweenCheckpoints;
    }

    public void setFlinkMinPauseBetweenCheckpoints(String flinkMinPauseBetweenCheckpoints) {
        this.flinkMinPauseBetweenCheckpoints = flinkMinPauseBetweenCheckpoints;
    }

    public String getFlinkFailingOnCheckpointingErrors() {
        return this.flinkFailingOnCheckpointingErrors;
    }

    public void setFlinkFailingOnCheckpointingErrors(String flinkFailingOnCheckpointingErrors) {
        this.flinkFailingOnCheckpointingErrors = flinkFailingOnCheckpointingErrors;
    }

    public String getFlinkNumberOfExecutionRetries() {
        return this.flinkNumberOfExecutionRetries;
    }

    public void setFlinkNumberOfExecutionRetries(String flinkNumberOfExecutionRetries) {
        this.flinkNumberOfExecutionRetries = flinkNumberOfExecutionRetries;
    }

    public String getFlinkExecutionRetryDelay() {
        return this.flinkExecutionRetryDelay;
    }

    public void setFlinkExecutionRetryDelay(String flinkExecutionRetryDelay) {
        this.flinkExecutionRetryDelay = flinkExecutionRetryDelay;
    }

    public String getFlinkObjectReuse() {
        return this.flinkObjectReuse;
    }

    public void setFlinkObjectReuse(String flinkObjectReuse) {
        this.flinkObjectReuse = flinkObjectReuse;
    }

    public String getFlinkDisableMetrics() {
        return this.flinkDisableMetrics;
    }

    public void setFlinkDisableMetrics(String flinkDisableMetrics) {
        this.flinkDisableMetrics = flinkDisableMetrics;
    }

    public String getFlinkExternalizedCheckpointsEnabled() {
        return this.flinkExternalizedCheckpointsEnabled;
    }

    public void setFlinkExternalizedCheckpointsEnabled(String flinkExternalizedCheckpointsEnabled) {
        this.flinkExternalizedCheckpointsEnabled = flinkExternalizedCheckpointsEnabled;
    }

    public String getFlinkRetainExternalizedCheckpointsOnCancellation() {
        return this.flinkRetainExternalizedCheckpointsOnCancellation;
    }

    public void setFlinkRetainExternalizedCheckpointsOnCancellation(String flinkRetainExternalizedCheckpointsOnCancellation) {
        this.flinkRetainExternalizedCheckpointsOnCancellation = flinkRetainExternalizedCheckpointsOnCancellation;
    }

    public String getFlinkMaxBundleSize() {
        return this.flinkMaxBundleSize;
    }

    public void setFlinkMaxBundleSize(String flinkMaxBundleSize) {
        this.flinkMaxBundleSize = flinkMaxBundleSize;
    }

    public String getFlinkMaxBundleTimeMills() {
        return this.flinkMaxBundleTimeMills;
    }

    public void setFlinkMaxBundleTimeMills(String flinkMaxBundleTimeMills) {
        this.flinkMaxBundleTimeMills = flinkMaxBundleTimeMills;
    }

    public String getFlinkShutdownSourcesAfterIdleMs() {
        return this.flinkShutdownSourcesAfterIdleMs;
    }

    public void setFlinkShutdownSourcesAfterIdleMs(String flinkShutdownSourcesAfterIdleMs) {
        this.flinkShutdownSourcesAfterIdleMs = flinkShutdownSourcesAfterIdleMs;
    }

    public String getFlinkLatencyTrackingInterval() {
        return this.flinkLatencyTrackingInterval;
    }

    public void setFlinkLatencyTrackingInterval(String flinkLatencyTrackingInterval) {
        this.flinkLatencyTrackingInterval = flinkLatencyTrackingInterval;
    }

    public String getFlinkAutoWatermarkInterval() {
        return this.flinkAutoWatermarkInterval;
    }

    public void setFlinkAutoWatermarkInterval(String flinkAutoWatermarkInterval) {
        this.flinkAutoWatermarkInterval = flinkAutoWatermarkInterval;
    }

    public String getFlinkExecutionModeForBatch() {
        return this.flinkExecutionModeForBatch;
    }

    public void setFlinkExecutionModeForBatch(String flinkExecutionModeForBatch) {
        this.flinkExecutionModeForBatch = flinkExecutionModeForBatch;
    }
}

