/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.pipeline.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.synthetic.SyntheticBoundedSource;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.beam.sdk.io.synthetic.SyntheticUnboundedSource;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.StaticHopRowFn;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.pipeline.handler.BeamBaseTransformHandler;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rowgenerator.RowGenerator;
import org.apache.hop.pipeline.transforms.rowgenerator.RowGeneratorMeta;

public class BeamRowGeneratorTransformHandler
extends BeamBaseTransformHandler
implements IBeamPipelineTransformHandler {
    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        PCollection afterInput;
        String rowDataXml;
        RowGeneratorMeta meta = new RowGeneratorMeta();
        this.loadTransformMetadata((ITransformMeta)meta, transformMeta, metadataProvider, pipelineMeta);
        ArrayList remarks = new ArrayList();
        RowMetaAndData rowMetaAndData = RowGenerator.buildRow((RowGeneratorMeta)meta, remarks, (String)"");
        if (!remarks.isEmpty()) {
            String message = "There are " + remarks.size() + " remarks concerning the generated rows:" + Const.CR;
            for (ICheckResult remark : remarks) {
                message = message + remark.getText() + Const.CR;
            }
            throw new HopException(message);
        }
        String rowMetaJson = JsonRowMeta.toJson((IRowMeta)rowMetaAndData.getRowMeta());
        try {
            rowDataXml = rowMetaAndData.getRowMeta().getDataXml(rowMetaAndData.getData());
        }
        catch (IOException e) {
            throw new HopException("Error encoding row as XML", (Throwable)e);
        }
        long intervalMs = Const.toLong((String)variables.resolve(meta.getIntervalInMs()), (long)-1L);
        if (intervalMs < 0L) {
            throw new HopException("The interval in milliseconds is expected to be >= 0, not '" + meta.getIntervalInMs() + "'");
        }
        if (meta.isNeverEnding()) {
            SyntheticSourceOptions options;
            String json = "{\"numRecords\" : 9223372036854775807, \"delayDistribution\" : { \"type\" : \"const\", \"const\" : " + intervalMs + "}, \"forceNumInitialBundles\" : " + transformMeta.getCopies(variables) + "}";
            try {
                options = (SyntheticSourceOptions)SyntheticSourceOptions.fromJsonString((String)json, SyntheticSourceOptions.class);
            }
            catch (Exception e) {
                throw new HopException("Unable to parse options for the Beam unbounded synthetic source, JSON: " + json, (Throwable)e);
            }
            SyntheticUnboundedSource unboundedSource = new SyntheticUnboundedSource(options);
            Read.Unbounded unboundedReader = Read.from((UnboundedSource)unboundedSource);
            PCollection sourceInput = (PCollection)pipeline.apply((PTransform)unboundedReader);
            String currentTimeField = variables.resolve(meta.getRowTimeField());
            int currentTimeFieldIndex = rowMeta.indexOfValue(currentTimeField);
            String previousTimeField = variables.resolve(meta.getLastTimeField());
            int previousTimeFieldIndex = rowMeta.indexOfValue(previousTimeField);
            afterInput = (PCollection)sourceInput.apply((PTransform)ParDo.of((DoFn)new StaticHopRowFn(transformMeta.getName(), rowMetaJson, rowDataXml, true, currentTimeFieldIndex, previousTimeFieldIndex, transformPluginClasses, xpPluginClasses)));
        } else {
            SyntheticSourceOptions options;
            long numRecords = Const.toLong((String)variables.resolve(meta.getRowLimit()), (long)-1L);
            if (numRecords < 0L) {
                throw new HopException("Please specify a valid number of records to generate, not '" + meta.getRowLimit() + "'");
            }
            String json = "{\"numRecords\" : " + numRecords + ", \"forceNumInitialBundles\" : " + transformMeta.getCopies(variables) + "}";
            try {
                options = (SyntheticSourceOptions)SyntheticSourceOptions.fromJsonString((String)json, SyntheticSourceOptions.class);
            }
            catch (Exception e) {
                throw new HopException("Unable to parse options for the Beam unbounded synthetic source, JSON: " + json, (Throwable)e);
            }
            SyntheticBoundedSource boundedSource = new SyntheticBoundedSource(options);
            Read.Bounded boundedReader = Read.from((BoundedSource)boundedSource);
            PCollection sourceInput = (PCollection)pipeline.apply((PTransform)boundedReader);
            afterInput = (PCollection)sourceInput.apply((PTransform)ParDo.of((DoFn)new StaticHopRowFn(transformMeta.getName(), rowMetaJson, rowDataXml, false, -1, -1, transformPluginClasses, xpPluginClasses)));
        }
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)afterInput);
        log.logBasic("Handled transform (ROW GENERATOR) : " + transformMeta.getName());
    }
}

