/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapred.IFileInputStream;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.IFileWrappedMapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class InMemoryMapOutput<K, V>
extends IFileWrappedMapOutput<K, V> {
    private static final Log LOG = LogFactory.getLog(InMemoryMapOutput.class);
    private final byte[] memory;
    private BoundedByteArrayOutputStream byteStream;
    private final CompressionCodec codec;
    private final Decompressor decompressor;

    public InMemoryMapOutput(Configuration conf, TaskAttemptID mapId, MergeManagerImpl<K, V> merger, int size, CompressionCodec codec, boolean primaryMapOutput) {
        super(conf, merger, mapId, size, primaryMapOutput);
        this.codec = codec;
        this.byteStream = new BoundedByteArrayOutputStream(size);
        this.memory = this.byteStream.getBuffer();
        this.decompressor = codec != null ? CodecPool.getDecompressor(codec) : null;
    }

    public byte[] getMemory() {
        return this.memory;
    }

    public BoundedByteArrayOutputStream getArrayStream() {
        return this.byteStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doShuffle(MapHost host, IFileInputStream iFin, long compressedLength, long decompressedLength, ShuffleClientMetrics metrics, Reporter reporter) throws IOException {
        InputStream input = iFin;
        if (this.codec != null) {
            this.decompressor.reset();
            input = this.codec.createInputStream(input, this.decompressor);
        }
        try {
            IOUtils.readFully(input, this.memory, 0, this.memory.length);
            metrics.inputBytes(this.memory.length);
            reporter.progress();
            LOG.info((Object)("Read " + this.memory.length + " bytes from map-output for " + this.getMapId()));
            if (input.read() >= 0) {
                throw new IOException("Unexpected extra bytes from input stream for " + this.getMapId());
            }
        }
        finally {
            CodecPool.returnDecompressor(this.decompressor);
        }
    }

    @Override
    public void commit() throws IOException {
        this.getMerger().closeInMemoryFile(this);
    }

    @Override
    public void abort() {
        this.getMerger().unreserve(this.memory.length);
    }

    @Override
    public String getDescription() {
        return "MEMORY";
    }
}

