/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.row.IValueMeta;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;

public class ParquetValueConverter
extends PrimitiveConverter {
    private final RowMetaAndData group;
    private final IValueMeta valueMeta;
    private final int rowIndex;

    public ParquetValueConverter(RowMetaAndData group, int rowIndex) {
        this.group = group;
        this.valueMeta = group.getValueMeta(rowIndex);
        this.rowIndex = rowIndex;
    }

    public void addBinary(Binary value) {
        Object object;
        if (this.rowIndex < 0) {
            return;
        }
        switch (this.valueMeta.getType()) {
            case 2: {
                object = value.toStringUsingUTF8();
                break;
            }
            case 8: {
                object = value.getBytes();
                break;
            }
            case 6: {
                object = new BigDecimal(value.toStringUsingUTF8());
                break;
            }
            default: {
                throw new RuntimeException("Unable to convert Binary source data to type " + this.valueMeta.getTypeDesc());
            }
        }
        this.group.getData()[this.rowIndex] = object;
    }

    public void addLong(long value) {
        Object object;
        if (this.rowIndex < 0) {
            return;
        }
        switch (this.valueMeta.getType()) {
            case 5: {
                object = value;
                break;
            }
            case 2: {
                object = Long.toString(value);
                break;
            }
            case 3: {
                object = new Date(value);
                break;
            }
            case 6: {
                object = new BigDecimal(value);
                break;
            }
            default: {
                throw new RuntimeException("Unable to convert Long source data to type " + this.valueMeta.getTypeDesc());
            }
        }
        this.group.getData()[this.rowIndex] = object;
    }

    public void addDouble(double value) {
        Object object;
        if (this.rowIndex < 0) {
            return;
        }
        switch (this.valueMeta.getType()) {
            case 1: {
                object = value;
                break;
            }
            case 2: {
                object = Double.toString(value);
                break;
            }
            case 6: {
                object = BigDecimal.valueOf(value);
                break;
            }
            default: {
                throw new RuntimeException("Unable to convert Double/Float source data to type " + this.valueMeta.getTypeDesc());
            }
        }
        this.group.getData()[this.rowIndex] = object;
    }

    public void addBoolean(boolean value) {
        Object object;
        if (this.rowIndex < 0) {
            return;
        }
        switch (this.valueMeta.getType()) {
            case 4: {
                object = value;
                break;
            }
            case 2: {
                object = value ? "true" : "false";
                break;
            }
            case 5: {
                object = value ? 1L : 0L;
                break;
            }
            default: {
                throw new RuntimeException("Unable to convert Boolean source data to type " + this.valueMeta.getTypeDesc());
            }
        }
        this.group.getData()[this.rowIndex] = object;
    }

    public void addFloat(float value) {
        this.addDouble(value);
    }

    public void addInt(int value) {
        this.addLong(value);
    }
}

