/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.producer.Attempt;
import com.amazonaws.services.kinesis.producer.IKinesisProducer;
import com.amazonaws.services.kinesis.producer.KinesisProducerConfiguration;
import com.amazonaws.services.kinesis.producer.UserRecordFailedException;
import com.amazonaws.services.kinesis.producer.UserRecordResult;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Supplier;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.kinesis.AutoValue_KinesisIO_Read;
import org.apache.beam.sdk.io.kinesis.AutoValue_KinesisIO_Write;
import org.apache.beam.sdk.io.kinesis.BasicKinesisProvider;
import org.apache.beam.sdk.io.kinesis.KinesisPartitioner;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.KinesisRecordCoder;
import org.apache.beam.sdk.io.kinesis.KinesisSource;
import org.apache.beam.sdk.io.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Experimental(value=Experimental.Kind.SOURCE_SINK)
public final class KinesisIO {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisIO.class);
    private static final int DEFAULT_NUM_RETRIES = 6;

    public static Read<KinesisRecord> read() {
        return Read.newBuilder().setCoder((Coder<KinesisRecord>)KinesisRecordCoder.of()).build();
    }

    public static Read<byte[]> readData() {
        return Read.newBuilder(KinesisRecord::getDataAsBytes).setCoder(ByteArrayCoder.of()).build();
    }

    public static Write write() {
        return new AutoValue_KinesisIO_Write.Builder().setRetries(6).build();
    }

    static class KinesisWriteException
    extends IOException {
        KinesisWriteException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<byte[]>, PDone> {
        abstract @Nullable String getStreamName();

        abstract @Nullable String getPartitionKey();

        abstract @Nullable KinesisPartitioner getPartitioner();

        abstract @Nullable Properties getProducerProperties();

        abstract @Nullable AWSClientsProvider getAWSClientsProvider();

        abstract int getRetries();

        abstract Builder builder();

        public Write withStreamName(String streamName) {
            return this.builder().setStreamName(streamName).build();
        }

        public Write withPartitionKey(String partitionKey) {
            return this.builder().setPartitionKey(partitionKey).build();
        }

        public Write withPartitioner(KinesisPartitioner partitioner) {
            return this.builder().setPartitioner(partitioner).build();
        }

        public Write withProducerProperties(Properties properties) {
            return this.builder().setProducerProperties(properties).build();
        }

        public Write withAWSClientsProvider(AWSClientsProvider awsClientsProvider) {
            return this.builder().setAWSClientsProvider(awsClientsProvider).build();
        }

        public Write withAWSClientsProvider(AWSCredentialsProvider awsCredentialsProvider, Regions region) {
            return this.withAWSClientsProvider(awsCredentialsProvider, region, null);
        }

        public Write withAWSClientsProvider(String awsAccessKey, String awsSecretKey, Regions region) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, null);
        }

        public Write withAWSClientsProvider(AWSCredentialsProvider awsCredentialsProvider, Regions region, String serviceEndpoint) {
            return this.withAWSClientsProvider(awsCredentialsProvider, region, serviceEndpoint, true);
        }

        public Write withAWSClientsProvider(String awsAccessKey, String awsSecretKey, Regions region, String serviceEndpoint) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, serviceEndpoint, true);
        }

        public Write withAWSClientsProvider(AWSCredentialsProvider awsCredentialsProvider, Regions region, String serviceEndpoint, boolean verifyCertificate) {
            return this.withAWSClientsProvider(new BasicKinesisProvider(awsCredentialsProvider, region, serviceEndpoint, verifyCertificate));
        }

        public Write withAWSClientsProvider(String awsAccessKey, String awsSecretKey, Regions region, String serviceEndpoint, boolean verifyCertificate) {
            AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(awsAccessKey, awsSecretKey));
            return this.withAWSClientsProvider((AWSCredentialsProvider)awsCredentialsProvider, region, serviceEndpoint, verifyCertificate);
        }

        @VisibleForTesting
        Write withRetries(int retries) {
            return this.builder().setRetries(retries).build();
        }

        public PDone expand(PCollection<byte[]> input) {
            LOG.warn("You are using a deprecated IO for Kinesis. Please migrate to module 'org.apache.beam:beam-sdks-java-io-amazon-web-services2'.");
            Preconditions.checkArgument((this.getStreamName() != null ? 1 : 0) != 0, (Object)"withStreamName() is required");
            Preconditions.checkArgument((this.getPartitionKey() != null || this.getPartitioner() != null ? 1 : 0) != 0, (Object)"withPartitionKey() or withPartitioner() is required");
            Preconditions.checkArgument((this.getPartitionKey() == null || this.getPartitioner() == null ? 1 : 0) != 0, (Object)"only one of either withPartitionKey() or withPartitioner() is possible");
            Preconditions.checkArgument((this.getAWSClientsProvider() != null ? 1 : 0) != 0, (Object)"withAWSClientsProvider() is required");
            this.createProducerConfiguration();
            input.apply((PTransform)ParDo.of((DoFn)new KinesisWriterFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        private KinesisProducerConfiguration createProducerConfiguration() {
            Properties props = this.getProducerProperties();
            if (props == null) {
                props = new Properties();
            }
            return KinesisProducerConfiguration.fromProperties((Properties)props);
        }

        private static class KinesisWriterFn
        extends DoFn<byte[], Void> {
            private static final int MAX_NUM_FAILURES = 10;
            private static int producerRefCount = 0;
            private static IKinesisProducer producer;
            private final Write spec;
            private transient KinesisPartitioner partitioner;
            private transient LinkedBlockingDeque<KinesisWriteException> failures;
            private transient List<Future<UserRecordResult>> putFutures;

            KinesisWriterFn(Write spec) {
                this.spec = spec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setupSharedProducer() {
                Class<KinesisWriterFn> clazz = KinesisWriterFn.class;
                synchronized (KinesisWriterFn.class) {
                    if (producer == null) {
                        producer = this.spec.getAWSClientsProvider().createKinesisProducer(this.spec.createProducerConfiguration());
                        producerRefCount = 0;
                    }
                    ++producerRefCount;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void teardownSharedProducer() {
                IKinesisProducer obsolete = null;
                Class<KinesisWriterFn> clazz = KinesisWriterFn.class;
                synchronized (KinesisWriterFn.class) {
                    if (--producerRefCount == 0) {
                        obsolete = producer;
                        producer = null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    if (obsolete != null) {
                        obsolete.flushSync();
                        obsolete.destroy();
                    }
                    return;
                }
            }

            @DoFn.Setup
            public void setup() {
                this.setupSharedProducer();
                if (this.spec.getPartitioner() != null) {
                    this.partitioner = this.spec.getPartitioner();
                }
            }

            @DoFn.StartBundle
            public void startBundle() {
                this.putFutures = Collections.synchronizedList(new ArrayList());
                this.failures = new LinkedBlockingDeque(10);
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                ByteBuffer data = ByteBuffer.wrap((byte[])c.element());
                String partitionKey = this.spec.getPartitionKey();
                String explicitHashKey = null;
                if (this.partitioner != null) {
                    partitionKey = this.partitioner.getPartitionKey((byte[])c.element());
                    explicitHashKey = this.partitioner.getExplicitHashKey((byte[])c.element());
                }
                ListenableFuture f = producer.addUserRecord(this.spec.getStreamName(), partitionKey, explicitHashKey, data);
                this.putFutures.add((Future<UserRecordResult>)f);
            }

            @DoFn.FinishBundle
            public void finishBundle() throws Exception {
                this.flushBundle();
            }

            private void flushBundle() throws InterruptedException, ExecutionException, IOException {
                UserRecordResult result;
                int numFailedRecords;
                int retries = this.spec.getRetries();
                int retryTimeout = 1000;
                String message = "";
                do {
                    numFailedRecords = 0;
                    producer.flush();
                    for (Future<UserRecordResult> f : this.putFutures) {
                        result = f.get();
                        if (result.isSuccessful()) continue;
                        ++numFailedRecords;
                    }
                    Thread.sleep(retryTimeout);
                    retryTimeout *= 2;
                } while (numFailedRecords > 0 && retries-- > 0);
                if (numFailedRecords > 0) {
                    for (Future<UserRecordResult> f : this.putFutures) {
                        result = f.get();
                        if (result.isSuccessful()) continue;
                        this.failures.offer(new KinesisWriteException("Put record was not successful.", (Throwable)new UserRecordFailedException(result)));
                    }
                    LOG.error("After [{}] retries, number of failed records [{}] is still greater than 0", (Object)this.spec.getRetries(), (Object)numFailedRecords);
                }
                this.checkForFailures(message);
            }

            private void checkForFailures(String message) throws IOException {
                if (this.failures.isEmpty()) {
                    return;
                }
                StringBuilder logEntry = new StringBuilder();
                logEntry.append(message).append(System.lineSeparator());
                int i = 0;
                while (!this.failures.isEmpty()) {
                    ++i;
                    KinesisWriteException exc = this.failures.remove();
                    logEntry.append(System.lineSeparator()).append(exc.getMessage());
                    Throwable cause = exc.getCause();
                    if (cause == null) continue;
                    logEntry.append(": ").append(cause.getMessage());
                    if (!(cause instanceof UserRecordFailedException)) continue;
                    List attempts = ((UserRecordFailedException)cause).getResult().getAttempts();
                    for (Attempt attempt : attempts) {
                        if (attempt.getErrorMessage() == null) continue;
                        logEntry.append(System.lineSeparator()).append(attempt.getErrorMessage());
                    }
                }
                String errorMessage = String.format("Some errors occurred writing to Kinesis. First %d errors: %s", i, logEntry.toString());
                throw new IOException(errorMessage);
            }

            @DoFn.Teardown
            public void teardown() throws Exception {
                this.teardownSharedProducer();
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setStreamName(String var1);

            abstract Builder setPartitionKey(String var1);

            abstract Builder setPartitioner(KinesisPartitioner var1);

            abstract Builder setProducerProperties(Properties var1);

            abstract Builder setAWSClientsProvider(AWSClientsProvider var1);

            abstract Builder setRetries(int var1);

            abstract Write build();
        }
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable String getStreamName();

        abstract @Nullable StartingPoint getInitialPosition();

        abstract @Nullable AWSClientsProvider getAWSClientsProvider();

        abstract long getMaxNumRecords();

        abstract @Nullable Duration getMaxReadTime();

        abstract Duration getUpToDateThreshold();

        abstract @Nullable Integer getRequestRecordsLimit();

        abstract WatermarkPolicyFactory getWatermarkPolicyFactory();

        abstract RateLimitPolicyFactory getRateLimitPolicyFactory();

        abstract Integer getMaxCapacityPerShard();

        abstract Coder<T> getCoder();

        abstract @Nullable SerializableFunction<KinesisRecord, T> getParseFn();

        abstract Builder<T> toBuilder();

        static <T> Builder<T> newBuilder(SerializableFunction<KinesisRecord, T> parseFn) {
            return new AutoValue_KinesisIO_Read.Builder<T>().setParseFn(parseFn).setMaxNumRecords(Long.MAX_VALUE).setUpToDateThreshold(Duration.ZERO).setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy()).setRateLimitPolicyFactory(RateLimitPolicyFactory.withDefaultRateLimiter()).setMaxCapacityPerShard(10000);
        }

        static Builder<KinesisRecord> newBuilder() {
            return Read.newBuilder((SerializableFunction & Serializable)x -> x);
        }

        public Read<T> withStreamName(String streamName) {
            return this.toBuilder().setStreamName(streamName).build();
        }

        public Read<T> withInitialPositionInStream(InitialPositionInStream initialPosition) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialPosition)).build();
        }

        public Read<T> withInitialTimestampInStream(Instant initialTimestamp) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialTimestamp)).build();
        }

        public Read<T> withAWSClientsProvider(AWSClientsProvider awsClientsProvider) {
            return this.toBuilder().setAWSClientsProvider(awsClientsProvider).build();
        }

        public Read<T> withAWSClientsProvider(AWSCredentialsProvider awsCredentialsProvider, Regions region) {
            return this.withAWSClientsProvider(awsCredentialsProvider, region, null);
        }

        public Read<T> withAWSClientsProvider(String awsAccessKey, String awsSecretKey, Regions region) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, null);
        }

        public Read<T> withAWSClientsProvider(AWSCredentialsProvider awsCredentialsProvider, Regions region, String serviceEndpoint) {
            return this.withAWSClientsProvider(awsCredentialsProvider, region, serviceEndpoint, true);
        }

        public Read<T> withAWSClientsProvider(String awsAccessKey, String awsSecretKey, Regions region, String serviceEndpoint) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, serviceEndpoint, true);
        }

        public Read<T> withAWSClientsProvider(AWSCredentialsProvider awsCredentialsProvider, Regions region, String serviceEndpoint, boolean verifyCertificate) {
            return this.withAWSClientsProvider(new BasicKinesisProvider(awsCredentialsProvider, region, serviceEndpoint, verifyCertificate));
        }

        public Read<T> withAWSClientsProvider(String awsAccessKey, String awsSecretKey, Regions region, String serviceEndpoint, boolean verifyCertificate) {
            AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(awsAccessKey, awsSecretKey));
            return this.withAWSClientsProvider((AWSCredentialsProvider)awsCredentialsProvider, region, serviceEndpoint, verifyCertificate);
        }

        public Read<T> withMaxNumRecords(long maxNumRecords) {
            Preconditions.checkArgument((maxNumRecords > 0L ? 1 : 0) != 0, (String)"maxNumRecords must be positive, but was: %s", (long)maxNumRecords);
            return this.toBuilder().setMaxNumRecords(maxNumRecords).build();
        }

        public Read<T> withMaxReadTime(Duration maxReadTime) {
            Preconditions.checkArgument((maxReadTime != null ? 1 : 0) != 0, (Object)"maxReadTime can not be null");
            return this.toBuilder().setMaxReadTime(maxReadTime).build();
        }

        public Read<T> withUpToDateThreshold(Duration upToDateThreshold) {
            Preconditions.checkArgument((upToDateThreshold != null ? 1 : 0) != 0, (Object)"upToDateThreshold can not be null");
            return this.toBuilder().setUpToDateThreshold(upToDateThreshold).build();
        }

        public Read<T> withRequestRecordsLimit(int limit) {
            Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (String)"limit must be positive, but was: %s", (int)limit);
            Preconditions.checkArgument((limit <= 10000 ? 1 : 0) != 0, (String)"limit must be up to 10,000, but was: %s", (int)limit);
            return this.toBuilder().setRequestRecordsLimit(limit).build();
        }

        public Read<T> withArrivalTimeWatermarkPolicy() {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy()).build();
        }

        public Read<T> withArrivalTimeWatermarkPolicy(Duration watermarkIdleDurationThreshold) {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy(watermarkIdleDurationThreshold)).build();
        }

        public Read<T> withProcessingTimeWatermarkPolicy() {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withProcessingTimePolicy()).build();
        }

        public Read<T> withCustomWatermarkPolicy(WatermarkPolicyFactory watermarkPolicyFactory) {
            Preconditions.checkArgument((watermarkPolicyFactory != null ? 1 : 0) != 0, (Object)"watermarkPolicyFactory cannot be null");
            return this.toBuilder().setWatermarkPolicyFactory(watermarkPolicyFactory).build();
        }

        public Read<T> withFixedDelayRateLimitPolicy() {
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withFixedDelay()).build();
        }

        public Read<T> withFixedDelayRateLimitPolicy(Duration delay) {
            Preconditions.checkArgument((delay != null ? 1 : 0) != 0, (Object)"delay cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withFixedDelay(delay)).build();
        }

        public Read<T> withDynamicDelayRateLimitPolicy(Supplier<Duration> delay) {
            Preconditions.checkArgument((delay != null ? 1 : 0) != 0, (Object)"delay cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withDelay(delay)).build();
        }

        public Read<T> withCustomRateLimitPolicy(RateLimitPolicyFactory rateLimitPolicyFactory) {
            Preconditions.checkArgument((rateLimitPolicyFactory != null ? 1 : 0) != 0, (Object)"rateLimitPolicyFactory cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(rateLimitPolicyFactory).build();
        }

        public Read<T> withMaxCapacityPerShard(Integer maxCapacity) {
            Preconditions.checkArgument((maxCapacity > 0 ? 1 : 0) != 0, (String)"maxCapacity must be positive, but was: %s", (Object)maxCapacity);
            return this.toBuilder().setMaxCapacityPerShard(maxCapacity).build();
        }

        public PCollection<T> expand(PBegin input) {
            Read.Unbounded unbounded;
            LOG.warn("You are using a deprecated IO for Kinesis. Please migrate to module 'org.apache.beam:beam-sdks-java-io-amazon-web-services2'.");
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new KinesisSource(this.getAWSClientsProvider(), this.getStreamName(), this.getInitialPosition(), this.getUpToDateThreshold(), this.getWatermarkPolicyFactory(), this.getRateLimitPolicyFactory(), this.getRequestRecordsLimit(), this.getMaxCapacityPerShard()));
            if (this.getMaxNumRecords() < Long.MAX_VALUE || this.getMaxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.getMaxReadTime()).withMaxNumRecords(this.getMaxNumRecords());
            }
            return ((PCollection)((PCollection)input.apply((PTransform)transform)).apply((PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<T>(){}).via(this.getParseFn()))).setCoder(this.getCoder());
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setStreamName(String var1);

            abstract Builder<T> setInitialPosition(StartingPoint var1);

            abstract Builder<T> setAWSClientsProvider(AWSClientsProvider var1);

            abstract Builder<T> setMaxNumRecords(long var1);

            abstract Builder<T> setMaxReadTime(Duration var1);

            abstract Builder<T> setUpToDateThreshold(Duration var1);

            abstract Builder<T> setRequestRecordsLimit(Integer var1);

            abstract Builder<T> setWatermarkPolicyFactory(WatermarkPolicyFactory var1);

            abstract Builder<T> setRateLimitPolicyFactory(RateLimitPolicyFactory var1);

            abstract Builder<T> setMaxCapacityPerShard(Integer var1);

            abstract Builder<T> setParseFn(SerializableFunction<KinesisRecord, T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Read<T> build();
        }
    }
}

