/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class EnvironmentInfo
implements ResponseBody {
    private static final String FIELD_NAME_ENVIRONMENT_INFO = "environment";
    private static final String FIELD_NAME_JVM_INFO = "jvm";
    private static final String FIELD_NAME_CLASSPATH = "classpath";
    @JsonProperty(value="environment")
    private final List<EnvironmentVariableItem> environmentVariables;
    @JsonProperty(value="jvm")
    private final JVMInfo jvmInfo;
    @JsonProperty(value="classpath")
    private final List<String> classpath;

    @JsonCreator
    public EnvironmentInfo(@JsonProperty(value="environment") List<EnvironmentVariableItem> environmentVariables, @JsonProperty(value="jvm") JVMInfo jvmInfo, @JsonProperty(value="classpath") List<String> classpath) {
        this.environmentVariables = environmentVariables;
        this.jvmInfo = jvmInfo;
        this.classpath = classpath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentInfo that = (EnvironmentInfo)o;
        return this.environmentVariables.equals(that.environmentVariables) && this.jvmInfo.equals(that.jvmInfo) && this.classpath.equals(that.classpath);
    }

    public int hashCode() {
        return Objects.hash(this.environmentVariables, this.jvmInfo, this.classpath);
    }

    public static EnvironmentInfo create() {
        ArrayList<EnvironmentVariableItem> environmentVariableItems = new ArrayList<EnvironmentVariableItem>();
        System.getenv().forEach((key, value) -> environmentVariableItems.add(new EnvironmentVariableItem((String)key, (String)value)));
        return new EnvironmentInfo(environmentVariableItems, JVMInfo.create(), Arrays.asList(System.getProperty("java.class.path").split(":")));
    }

    private static class JVMInfo {
        private static final String FIELD_NAME_VERSION = "version";
        private static final String FIELD_NAME_ARCH = "arch";
        private static final String FIELD_NAME_OPTIONS = "options";
        @JsonProperty(value="version")
        private final String version;
        @JsonProperty(value="arch")
        private final String arch;
        @JsonProperty(value="options")
        private final List<String> options;

        @JsonCreator
        public JVMInfo(@JsonProperty(value="version") String version, @JsonProperty(value="arch") String arch, @JsonProperty(value="options") List<String> options) {
            this.version = version;
            this.arch = arch;
            this.options = options;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JVMInfo that = (JVMInfo)o;
            return this.version.equals(that.version) && this.arch.equals(that.arch) && this.options.equals(that.options);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.arch, this.options);
        }

        private static JVMInfo create() {
            return new JVMInfo(EnvironmentInformation.getJvmVersion(), System.getProperty("os.arch"), Arrays.asList(EnvironmentInformation.getJvmStartupOptionsArray()));
        }
    }

    private static class EnvironmentVariableItem {
        private static final String FIELD_NAME_KEY = "key";
        private static final String FIELD_NAME_VALUE = "value";
        @JsonProperty(value="key")
        private final String key;
        @JsonProperty(value="value")
        private final String value;

        @JsonCreator
        public EnvironmentVariableItem(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnvironmentVariableItem that = (EnvironmentVariableItem)o;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }
}

