/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.insertupdate;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateData;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateKeyField;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateMeta;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateValue;

public class InsertUpdate
extends BaseTransform<InsertUpdateMeta, InsertUpdateData> {
    private static final Class<?> PKG = InsertUpdateMeta.class;
    public static final String CONST_IS_NULL = "IS NULL";
    public static final String CONST_IS_NOT_NULL = "IS NOT NULL";
    public static final String CONST_INSERT_UPDATE_EXCEPTION_FIELD_REQUIRED = "InsertUpdate.Exception.FieldRequired";
    public static final String CONST_NULL = "= ~NULL";
    public static final String CONST_BETWEEN = "BETWEEN";

    public InsertUpdate(TransformMeta transformMeta, InsertUpdateMeta meta, InsertUpdateData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    protected synchronized void lookupValues(IRowMeta rowMeta, Object[] row) throws HopException {
        Object[] lookupRow = new Object[((InsertUpdateData)this.data).lookupParameterRowMeta.size()];
        int lookupIndex = 0;
        for (int i = 0; i < ((InsertUpdateData)this.data).keynrs.length; ++i) {
            if (((InsertUpdateData)this.data).keynrs[i] >= 0) {
                lookupRow[lookupIndex] = row[((InsertUpdateData)this.data).keynrs[i]];
                ++lookupIndex;
            }
            if (((InsertUpdateData)this.data).keynrs2[i] < 0) continue;
            lookupRow[lookupIndex] = row[((InsertUpdateData)this.data).keynrs2[i]];
            ++lookupIndex;
        }
        ((InsertUpdateData)this.data).db.setValues(((InsertUpdateData)this.data).lookupParameterRowMeta, lookupRow, ((InsertUpdateData)this.data).prepStatementLookup);
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.ValuesSetForLookup", (String[])new String[0]) + ((InsertUpdateData)this.data).lookupParameterRowMeta.getString(lookupRow));
        }
        Object[] add = ((InsertUpdateData)this.data).db.getLookup(((InsertUpdateData)this.data).prepStatementLookup);
        this.incrementLinesInput();
        if (add == null) {
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"InsertUpdate.InsertRow", (String[])new String[0]) + rowMeta.getString(row));
            }
            Object[] insertRow = new Object[((InsertUpdateData)this.data).valuenrs.length];
            for (int i = 0; i < ((InsertUpdateData)this.data).valuenrs.length; ++i) {
                insertRow[i] = row[((InsertUpdateData)this.data).valuenrs[i]];
            }
            ((InsertUpdateData)this.data).db.setValuesInsert(((InsertUpdateData)this.data).insertRowMeta, insertRow);
            ((InsertUpdateData)this.data).db.insertRow();
            this.incrementLinesOutput();
        } else if (!((InsertUpdateMeta)this.meta).isUpdateBypassed()) {
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.FoundRowForUpdate", (String[])new String[0]) + rowMeta.getString(row));
            }
            boolean update = false;
            for (int i = 0; i < ((InsertUpdateData)this.data).valuenrs.length; ++i) {
                Object rowvalue;
                Object retvalue;
                InsertUpdateValue valueField = ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().get(i);
                if (!valueField.isUpdate()) continue;
                IValueMeta valueMeta = rowMeta.getValueMeta(((InsertUpdateData)this.data).valuenrs[i]);
                IValueMeta retMeta = ((InsertUpdateData)this.data).db.getReturnRowMeta().getValueMeta(i);
                if (retMeta.compare(retvalue = add[i], valueMeta, rowvalue = row[((InsertUpdateData)this.data).valuenrs[i]]) == 0) continue;
                update = true;
            }
            if (update) {
                int i;
                Object[] updateRow = new Object[((InsertUpdateData)this.data).updateParameterRowMeta.size()];
                int j = 0;
                for (i = 0; i < ((InsertUpdateData)this.data).valuenrs.length; ++i) {
                    InsertUpdateValue valueField = ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().get(i);
                    if (!valueField.isUpdate()) continue;
                    updateRow[j] = row[((InsertUpdateData)this.data).valuenrs[i]];
                    ++j;
                }
                for (i = 0; i < lookupRow.length; ++i) {
                    updateRow[j + i] = lookupRow[i];
                }
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.UpdateRow", (String[])new String[0]) + ((InsertUpdateData)this.data).lookupParameterRowMeta.getString(lookupRow));
                }
                ((InsertUpdateData)this.data).db.setValues(((InsertUpdateData)this.data).updateParameterRowMeta, updateRow, ((InsertUpdateData)this.data).prepStatementUpdate);
                ((InsertUpdateData)this.data).db.insertRow(((InsertUpdateData)this.data).prepStatementUpdate);
                this.incrementLinesUpdated();
            } else {
                this.incrementLinesSkipped();
            }
        } else {
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.UpdateBypassed", (String[])new String[0]) + rowMeta.getString(row));
            }
            this.incrementLinesSkipped();
        }
    }

    public boolean processRow() throws HopException {
        block17: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                InsertUpdateValue valueField;
                int i;
                this.first = false;
                DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((InsertUpdateMeta)this.meta).getConnection(), this.variables);
                ((InsertUpdateData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((InsertUpdateMeta)this.meta).getFields(((InsertUpdateData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((InsertUpdateData)this.data).schemaTable = databaseMeta.getQuotedSchemaTableCombination((IVariables)this, ((InsertUpdateMeta)this.meta).getSchemaName(), ((InsertUpdateMeta)this.meta).getTableName());
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.CheckingRow", (String[])new String[0]) + this.getInputRowMeta().getString(r));
                }
                ArrayList<Integer> keynrs = new ArrayList<Integer>(((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getLookupKeys().size());
                ArrayList<Integer> keynrs2 = new ArrayList<Integer>(((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getLookupKeys().size());
                for (i = 0; i < ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getLookupKeys().size(); ++i) {
                    int keynr2;
                    InsertUpdateKeyField keyField = ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getLookupKeys().get(i);
                    int keynr = this.getInputRowMeta().indexOfValue(keyField.getKeyStream());
                    if (keynr < 0 && !CONST_IS_NULL.equalsIgnoreCase(keyField.getKeyCondition()) && !CONST_IS_NOT_NULL.equalsIgnoreCase(keyField.getKeyCondition())) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)CONST_INSERT_UPDATE_EXCEPTION_FIELD_REQUIRED, (String[])new String[]{keyField.getKeyStream()}));
                    }
                    keynrs.add(keynr);
                    if (CONST_NULL.equalsIgnoreCase(keyField.getKeyCondition())) {
                        keynrs.add(keynr);
                        keynrs2.add(-1);
                    }
                    if ((keynr2 = this.getInputRowMeta().indexOfValue(keyField.getKeyStream2())) < 0 && CONST_BETWEEN.equalsIgnoreCase(keyField.getKeyCondition())) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)CONST_INSERT_UPDATE_EXCEPTION_FIELD_REQUIRED, (String[])new String[]{keyField.getKeyStream2()}));
                    }
                    keynrs2.add(keynr2);
                    if (!this.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.FieldHasDataNumbers", (String[])new String[]{keyField.getKeyStream()}) + String.valueOf(keynrs.get(keynrs.size() - 1)));
                }
                ((InsertUpdateData)this.data).keynrs = ArrayUtils.toPrimitive((Integer[])keynrs.toArray(new Integer[0]));
                ((InsertUpdateData)this.data).keynrs2 = ArrayUtils.toPrimitive((Integer[])keynrs2.toArray(new Integer[0]));
                ((InsertUpdateData)this.data).valuenrs = new int[((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().size()];
                for (i = 0; i < ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().size(); ++i) {
                    valueField = ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().get(i);
                    ((InsertUpdateData)this.data).valuenrs[i] = this.getInputRowMeta().indexOfValue(valueField.getUpdateStream());
                    if (((InsertUpdateData)this.data).valuenrs[i] < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)CONST_INSERT_UPDATE_EXCEPTION_FIELD_REQUIRED, (String[])new String[]{valueField.getUpdateStream()}));
                    }
                    if (!this.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.FieldHasDataNumbers", (String[])new String[]{valueField.getUpdateStream()}) + ((InsertUpdateData)this.data).valuenrs[i]);
                }
                this.setLookup(this.getInputRowMeta());
                ((InsertUpdateData)this.data).insertRowMeta = new RowMeta();
                for (i = 0; i < ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().size(); ++i) {
                    valueField = ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().get(i);
                    IValueMeta insValue = ((InsertUpdateData)this.data).insertRowMeta.searchValueMeta(valueField.getUpdateLookup());
                    if (insValue != null) {
                        throw new HopTransformException("The same column can't be inserted into the target row twice: " + insValue.getName());
                    }
                    IValueMeta insertValue = this.getInputRowMeta().searchValueMeta(valueField.getUpdateStream()).clone();
                    insertValue.setName(valueField.getUpdateLookup());
                    ((InsertUpdateData)this.data).insertRowMeta.addValueMeta(insertValue);
                }
                ((InsertUpdateData)this.data).db.prepareInsert(((InsertUpdateData)this.data).insertRowMeta, this.resolve(((InsertUpdateMeta)this.meta).getSchemaName()), this.resolve(((InsertUpdateMeta)this.meta).getTableName()));
                if (!((InsertUpdateMeta)this.meta).isUpdateBypassed()) {
                    ArrayList<String> updateColumns = new ArrayList<String>();
                    for (int i2 = 0; i2 < ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().size(); ++i2) {
                        InsertUpdateValue valueField2 = ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().get(i2);
                        if (!valueField2.isUpdate()) continue;
                        updateColumns.add(valueField2.getUpdateLookup());
                    }
                    this.prepareUpdate(this.getInputRowMeta());
                }
            }
            try {
                this.lookupValues(this.getInputRowMeta(), r);
                this.putRow(((InsertUpdateData)this.data).outputRowMeta, r);
                if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.ErrorInTransform", (String[])new String[0]), e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block17;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ISU001");
            }
        }
        return true;
    }

    public void setLookup(IRowMeta rowMeta) throws HopDatabaseException {
        int i;
        ((InsertUpdateData)this.data).lookupParameterRowMeta = new RowMeta();
        ((InsertUpdateData)this.data).lookupReturnRowMeta = new RowMeta();
        DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((InsertUpdateMeta)this.meta).getConnection(), this.variables);
        Object sql = "SELECT ";
        for (i = 0; i < ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().size(); ++i) {
            InsertUpdateValue valueField = ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().get(i);
            if (i != 0) {
                sql = (String)sql + ", ";
            }
            sql = (String)sql + databaseMeta.quoteField(valueField.getUpdateLookup());
            ((InsertUpdateData)this.data).lookupReturnRowMeta.addValueMeta(rowMeta.searchValueMeta(valueField.getUpdateStream()).clone());
        }
        sql = (String)sql + " FROM " + ((InsertUpdateData)this.data).schemaTable + " WHERE ";
        for (i = 0; i < ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getLookupKeys().size(); ++i) {
            InsertUpdateKeyField keyField = ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getLookupKeys().get(i);
            if (i != 0) {
                sql = (String)sql + " AND ";
            }
            sql = (String)sql + " ( ( ";
            sql = (String)sql + databaseMeta.quoteField(keyField.getKeyLookup());
            if (CONST_BETWEEN.equalsIgnoreCase(keyField.getKeyCondition())) {
                sql = (String)sql + " BETWEEN ? AND ? ";
                ((InsertUpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyField.getKeyStream()));
                ((InsertUpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyField.getKeyStream2()));
            } else if (CONST_IS_NULL.equalsIgnoreCase(keyField.getKeyCondition()) || CONST_IS_NOT_NULL.equalsIgnoreCase(keyField.getKeyCondition())) {
                sql = (String)sql + " " + keyField.getKeyCondition() + " ";
            } else if (CONST_NULL.equalsIgnoreCase(keyField.getKeyCondition())) {
                sql = (String)sql + " IS NULL AND ";
                sql = databaseMeta.requiresCastToVariousForIsNull() ? (String)sql + " CAST(? AS VARCHAR(256)) IS NULL " : (String)sql + " ? IS NULL ";
                ((InsertUpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyField.getKeyStream()));
                sql = (String)sql + " ) OR ( " + databaseMeta.quoteField(keyField.getKeyLookup()) + " = ? ";
                ((InsertUpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyField.getKeyStream()).clone());
            } else {
                sql = (String)sql + " " + keyField.getKeyCondition() + " ? ";
                ((InsertUpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyField.getKeyStream()));
            }
            sql = (String)sql + " ) ) ";
        }
        try {
            if (this.isDetailed()) {
                this.logDetailed("Setting preparedStatement to [" + (String)sql + "]");
            }
            ((InsertUpdateData)this.data).prepStatementLookup = ((InsertUpdateData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR((String)sql));
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to prepare statement for SQL statement [" + (String)sql + "]", (Throwable)ex);
        }
    }

    public void prepareUpdate(IRowMeta rowMeta) throws HopDatabaseException {
        int i;
        DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((InsertUpdateMeta)this.meta).getConnection(), this.variables);
        ((InsertUpdateData)this.data).updateParameterRowMeta = new RowMeta();
        String sql = "UPDATE " + ((InsertUpdateData)this.data).schemaTable + Const.CR;
        sql = sql + "SET ";
        boolean comma = false;
        for (i = 0; i < ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().size(); ++i) {
            InsertUpdateValue valueField = ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getValueFields().get(i);
            if (!valueField.isUpdate()) continue;
            if (comma) {
                sql = sql + ",   ";
            } else {
                comma = true;
            }
            sql = sql + databaseMeta.quoteField(valueField.getUpdateLookup());
            sql = sql + " = ?" + Const.CR;
            ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(valueField.getUpdateStream()).clone());
        }
        sql = sql + "WHERE ";
        for (i = 0; i < ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getLookupKeys().size(); ++i) {
            InsertUpdateKeyField keyField = ((InsertUpdateMeta)this.meta).getInsertUpdateLookupField().getLookupKeys().get(i);
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + " ( ( ";
            sql = sql + databaseMeta.quoteField(keyField.getKeyLookup());
            if (CONST_BETWEEN.equalsIgnoreCase(keyField.getKeyCondition())) {
                sql = sql + " BETWEEN ? AND ? ";
                ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyField.getKeyStream()));
                ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyField.getKeyStream2()));
            } else if (CONST_IS_NULL.equalsIgnoreCase(keyField.getKeyCondition()) || CONST_IS_NOT_NULL.equalsIgnoreCase(keyField.getKeyCondition())) {
                sql = sql + " " + keyField.getKeyCondition() + " ";
            } else if (CONST_NULL.equalsIgnoreCase(keyField.getKeyCondition())) {
                sql = sql + " IS NULL AND ";
                sql = databaseMeta.requiresCastToVariousForIsNull() ? sql + "CAST(? AS VARCHAR(256)) IS NULL" : sql + "? IS NULL";
                ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyField.getKeyStream()));
                sql = sql + " ) OR ( " + databaseMeta.quoteField(keyField.getKeyLookup()) + " = ?";
                ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyField.getKeyStream()).clone());
            } else {
                sql = sql + " " + keyField.getKeyCondition() + " ? ";
                ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyField.getKeyStream()).clone());
            }
            sql = sql + " ) ) ";
        }
        try {
            if (this.isDetailed()) {
                this.logDetailed("Setting update preparedStatement to [" + sql + "]");
            }
            ((InsertUpdateData)this.data).prepStatementUpdate = ((InsertUpdateData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    public boolean init() {
        if (super.init()) {
            DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((InsertUpdateMeta)this.meta).getConnection(), this.variables);
            try {
                if (databaseMeta == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"InsertUpdate.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                    return false;
                }
                ((InsertUpdateData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
                ((InsertUpdateData)this.data).db.connect();
                ((InsertUpdateData)this.data).db.setCommit(((InsertUpdateMeta)this.meta).getCommitSizeVar((IVariables)this));
                return true;
            }
            catch (HopException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.ErrorOccurredDuringTransformInitialize", (String[])new String[0]) + ke.getMessage());
            }
        }
        return false;
    }

    public void batchComplete() throws HopException {
        this.commitBatch(false);
    }

    public void dispose() {
        this.commitBatch(true);
        super.dispose();
    }

    private void commitBatch(boolean dispose) {
        if (((InsertUpdateData)this.data).db != null) {
            try {
                if (!((InsertUpdateData)this.data).db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        ((InsertUpdateData)this.data).db.commit();
                    } else {
                        ((InsertUpdateData)this.data).db.rollback();
                    }
                }
                if (dispose) {
                    ((InsertUpdateData)this.data).db.closeUpdate();
                    ((InsertUpdateData)this.data).db.closeInsert();
                }
            }
            catch (HopDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.UnableToCommitConnection", (String[])new String[0]) + e.toString());
                this.setErrors(1L);
            }
            finally {
                if (dispose) {
                    ((InsertUpdateData)this.data).db.disconnect();
                    ((InsertUpdateData)this.data).db = null;
                }
            }
        }
    }
}

