/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.SystemUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.StreamReadConstraints;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.MapperFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;

public class ObjectMapperFactory {
    @SnowflakeJdbcInternalApi
    public static final int DEFAULT_MAX_JSON_STRING_LEN = 180000000;
    @SnowflakeJdbcInternalApi
    public static final String MAX_JSON_STRING_LENGTH_JVM = "net.snowflake.jdbc.objectMapper.maxJsonStringLength";

    public static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS, false);
        mapper.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, false);
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        int maxJsonStringLength = SystemUtil.convertSystemPropertyToIntValue(MAX_JSON_STRING_LENGTH_JVM, 180000000);
        mapper.getFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(maxJsonStringLength).build());
        return mapper;
    }
}

