/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.concurrent.LongAdder;

final class AtomicLongLongAdder
implements LongAdder {
    private final AtomicLong atomicLong = new AtomicLong();

    AtomicLongLongAdder() {
    }

    @Override
    public void add(long x) {
        long next;
        long current;
        while (!this.atomicLong.compareAndSet(current = this.atomicLong.get(), next = current + x)) {
        }
    }

    @Override
    public long sum() {
        return this.atomicLong.get();
    }

    @Override
    public void reset() {
        this.atomicLong.set(0L);
    }

    @Override
    public long sumThenReset() {
        long prev;
        while (!this.atomicLong.compareAndSet(prev = this.atomicLong.get(), 0L)) {
        }
        return prev;
    }

    public String toString() {
        return Long.toString(this.sum());
    }
}

