/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure.config;

import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.vfs.azure.config.AzureConfig;
import org.apache.hop.vfs.azure.config.AzureConfigSingleton;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="AzureConfigPlugin", description="i18n::AzureConfig.ConfigPlugin.Description", category="config")
@GuiPlugin(description="i18n::Azure.GuiPlugin.Description")
public class AzureConfigPlugin
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    private static final String WIDGET_ID_AZURE_ACCOUNT = "10000-azure-account";
    private static final String WIDGET_ID_AZURE_KEY = "10100-azure-key";
    private static final String WIDGET_ID_AZURE_LOCAL_EMULATOR_URL = "10300-azure-local-emulator-url";
    @GuiWidgetElement(id="10000-azure-account", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::AzureVFS.Account.Label", toolTip="i18n::AzureVFS.Account.Description")
    @CommandLine.Option(names={"-aza", "--azure-account"}, description={"The account to use for the Azure VFS"})
    private String account;
    @GuiWidgetElement(id="10100-azure-key", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, password=true, label="i18n::AzureVFS.AccountKey.Label", toolTip="i18n::AzureVFS.AccountKey.Description")
    @CommandLine.Option(names={"-azk", "--azure-key"}, description={"The key to use for the Azure VFS"})
    private String key;
    @GuiWidgetElement(id="10300-azure-local-emulator-url", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, password=false, label="i18n::AzureVFS.Url.Label", toolTip="i18n::AzureVFS.Url.Description")
    @CommandLine.Option(names={"-aze", "--azure-emulator"}, description={"The URL of an Azure emulator (Azurite) to be used for test and development goals instead of official Azure services"})
    private String localEmulatorUrl;

    public static AzureConfigPlugin getInstance() {
        AzureConfigPlugin instance = new AzureConfigPlugin();
        AzureConfig config = AzureConfigSingleton.getConfig();
        instance.account = config.getAccount();
        instance.key = config.getKey();
        instance.localEmulatorUrl = config.getEmulatorUrl();
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        AzureConfig config = AzureConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.account != null) {
                config.setAccount(this.account);
                log.logBasic("The Azure account is set to '" + this.account + "'");
                changed = true;
            }
            if (this.key != null) {
                config.setKey(this.key);
                log.logBasic("The Azure key is set to '" + this.key + "'");
                changed = true;
            }
            if (this.localEmulatorUrl != null) {
                config.setEmulatorUrl(this.localEmulatorUrl);
                log.logBasic("The Azure emulator URL is set to '" + this.localEmulatorUrl + "'");
            }
            if (changed) {
                AzureConfigSingleton.saveConfig();
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling Azure configuration options", (Throwable)e);
        }
    }

    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.persistContents(compositeWidgets);
    }

    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        for (String widgetId : compositeWidgets.getWidgetsMap().keySet()) {
            Control control = (Control)compositeWidgets.getWidgetsMap().get(widgetId);
            switch (widgetId) {
                case "10000-azure-account": {
                    this.account = ((TextVar)control).getText();
                    AzureConfigSingleton.getConfig().setAccount(this.account);
                    break;
                }
                case "10100-azure-key": {
                    this.key = ((TextVar)control).getText();
                    AzureConfigSingleton.getConfig().setKey(this.key);
                    break;
                }
                case "10300-azure-local-emulator-url": {
                    this.localEmulatorUrl = ((TextVar)control).getText();
                    AzureConfigSingleton.getConfig().setEmulatorUrl(this.localEmulatorUrl);
                }
            }
        }
        try {
            AzureConfigSingleton.saveConfig();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving option", e);
        }
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLocalEmulatorUrl() {
        return this.localEmulatorUrl;
    }

    public void setLocalEmulatorUrl(String localEmulatorUrl) {
        this.localEmulatorUrl = localEmulatorUrl;
    }
}

