/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.wire.Sequence;

class RollCycleEncodeSequence
implements Sequence {
    private final TwoLongValue writePositionAndSequence;
    private final int cycleShift;
    private final long sequenceMask;

    RollCycleEncodeSequence(LongValue writePositionAndSequence, int indexCount, int indexSpacing) {
        this.cycleShift = Math.max(32, Maths.intLog2(indexCount) * 2 + Maths.intLog2(indexSpacing));
        this.sequenceMask = (1L << this.cycleShift) - 1L;
        this.writePositionAndSequence = writePositionAndSequence instanceof TwoLongValue ? (TwoLongValue)writePositionAndSequence : null;
    }

    public void setSequence(long sequence, long position) {
        if (this.writePositionAndSequence == null) {
            return;
        }
        long value = this.toLongValue(position, sequence);
        this.writePositionAndSequence.setOrderedValue2(value);
    }

    public long toIndex(long headerNumber, long sequence) {
        long cycle = this.toLowerBitsWritePosition(headerNumber);
        return this.toLongValue(cycle, sequence);
    }

    public long getSequence(long forWritePosition) {
        long toLowerBitsWritePosition;
        if (this.writePositionAndSequence == null) {
            return -1L;
        }
        long sequenceValue = this.writePositionAndSequence.getVolatileValue2();
        if (sequenceValue == 0L) {
            return -1L;
        }
        long writePositionAsCycle = this.toLongValue(forWritePosition, 0L);
        long lowerBitsOfWp = this.toLowerBitsWritePosition(writePositionAsCycle);
        if (lowerBitsOfWp == (toLowerBitsWritePosition = this.toLowerBitsWritePosition(sequenceValue))) {
            return this.toSequenceNumber(sequenceValue);
        }
        return Long.MIN_VALUE;
    }

    private long toLongValue(long cycle, long sequenceNumber) {
        return (cycle << this.cycleShift) + (sequenceNumber & this.sequenceMask);
    }

    public long toSequenceNumber(long index) {
        return index & this.sequenceMask;
    }

    private long toLowerBitsWritePosition(long index) {
        return index >>> this.cycleShift;
    }

    public String toString() {
        return "RollCycleEncodeSequence{writePositionAndSequence=" + this.writePositionAndSequence + ", cycleShift=" + this.cycleShift + ", sequenceMask=" + this.sequenceMask + '}';
    }
}

