/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.expansion.service.AutoValue_WindowIntoTransformProvider_Configuration;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class WindowIntoTransformProvider
extends TypedSchemaTransformProvider<Configuration> {
    private static final @UnknownKeyFor @NonNull @Initialized String INPUT_ROWS_TAG = "input";
    protected static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_ROWS_TAG = "output";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized Configuration> configurationClass() {
        return Configuration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
        try {
            return new WindowIntoStrategy(WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)RunnerApi.WindowingStrategy.parseFrom((byte[])configuration.getSerializedWindowingStrategy()), null));
        }
        catch (IOException exn) {
            throw new RuntimeException(exn);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:yaml:window_into_strategy:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_ROWS_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_ROWS_TAG);
    }

    private static class WindowIntoStrategy
    extends SchemaTransform {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;

        WindowIntoStrategy(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
            this.windowingStrategy = windowingStrategy;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple inputTuple) {
            PCollection input = inputTuple.get(WindowIntoTransformProvider.INPUT_ROWS_TAG);
            return PCollectionRowTuple.of((String)WindowIntoTransformProvider.OUTPUT_ROWS_TAG, (PCollection)((PCollection)input.apply((PTransform)Window.Assign.createInternal(this.windowingStrategy))).setCoder(input.getCoder()));
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class Configuration {
        public abstract @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getSerializedWindowingStrategy();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_WindowIntoTransformProvider_Configuration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSerializedWindowingStrategy(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Configuration build();
        }
    }
}

