/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.util;

import io.github.spannm.jackcess.impl.ByteUtil;
import io.github.spannm.jackcess.impl.PageChannel;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;

public class ToStringBuilder {
    private static final Map<Object, Object> OBJ_REGISTRY = new WeakHashMap<Object, Object>();
    private final StringBuilder buffer = new StringBuilder(512);
    private final Object object;
    private final String fieldSeparator;
    private final boolean fieldSeparatorAtStart;
    private final String fieldNameValueSeparator;
    private final String contentStart;
    private final String contentEnd;
    private final String nullText;
    private final String implSuffix;
    private boolean useIdentityHashCode = true;
    private final int maxByteDetailLen = 20;

    ToStringBuilder(Object _object, String _fieldSeparator, boolean _fieldSeparatorAtStart, String _fieldNameValueSeparator, String _contentEnd, boolean _useIdentityHashCode) {
        this.object = _object;
        this.fieldSeparator = Optional.ofNullable(_fieldSeparator).orElse(",");
        this.fieldSeparatorAtStart = _fieldSeparatorAtStart;
        this.fieldNameValueSeparator = Optional.ofNullable(_fieldNameValueSeparator).orElse("=");
        this.contentStart = "[";
        this.contentEnd = Optional.ofNullable(_contentEnd).orElse("]");
        this.nullText = "<null>";
        this.implSuffix = "Impl";
        this.useIdentityHashCode = _useIdentityHashCode;
        if (this.object != null) {
            this.buffer.append(_object instanceof String ? _object : ToStringBuilder.getShortClassName(_object.getClass(), this.implSuffix));
            if (this.useIdentityHashCode) {
                this.buffer.append('@').append(Integer.toHexString(System.identityHashCode(this.object)));
            }
            this.buffer.append(this.contentStart);
            if (this.fieldSeparatorAtStart) {
                this.buffer.append(this.fieldSeparator);
            }
        }
    }

    public static ToStringBuilder valueBuilder(Object obj) {
        return new ToStringBuilder(obj, null, false, null, null, false);
    }

    public static ToStringBuilder builder(Object obj) {
        return new ToStringBuilder(obj, System.lineSeparator() + "  ", true, ": ", System.lineSeparator() + "]", true);
    }

    public ToStringBuilder append(String fieldName, Object value) {
        if (fieldName != null) {
            this.buffer.append(fieldName).append(this.fieldNameValueSeparator);
        }
        if (value == null) {
            this.buffer.append(this.nullText);
        } else {
            this.appendInternal(this.buffer, fieldName, value);
        }
        this.buffer.append(this.fieldSeparator);
        return this;
    }

    public ToStringBuilder appendIgnoreNull(String fieldName, Object value) {
        return this.append(fieldName, value == null ? "" : value);
    }

    public String toString() {
        if (this.object == null) {
            this.buffer.append(this.nullText);
        } else {
            ToStringBuilder.removeLastFieldSeparator(this.buffer, this.fieldSeparator);
            this.buffer.append(this.contentEnd);
        }
        return this.buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendInternal(StringBuilder _buffer, String _fieldName, Object _value) {
        boolean primitiveWrapper;
        boolean bl = primitiveWrapper = _value instanceof Number || _value instanceof Boolean || _value instanceof Character;
        if (OBJ_REGISTRY.containsKey(_value) && !primitiveWrapper) {
            _buffer.append(_value.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(_value)));
            return;
        }
        OBJ_REGISTRY.put(_value, null);
        try {
            if (_value instanceof byte[]) {
                ByteBuffer bb = PageChannel.wrap((byte[])_value);
                int len = bb.remaining();
                _buffer.append('(').append(len).append(") ").append(ByteUtil.toHexString(bb, bb.position(), Math.min(len, 20)));
                if (len > 20) {
                    _buffer.append("...");
                }
            } else if (_value.getClass().isArray()) {
                _buffer.append('{');
                for (int i = 0; i < Array.getLength(_value); ++i) {
                    Object item = Array.get(_value, i);
                    if (i > 0) {
                        _buffer.append(this.fieldSeparator);
                    }
                    if (item == null) {
                        _buffer.append(this.nullText);
                        continue;
                    }
                    this.appendInternal(_buffer, _fieldName, item);
                }
                _buffer.append('}');
            } else if (_value instanceof Collection) {
                String str = ((Collection)_value).stream().map(v -> v == null ? this.nullText : v.toString()).collect(Collectors.joining(","));
                _buffer.append('[').append(str).append(']');
            } else if (_value instanceof Map) {
                String str = ((Map)_value).entrySet().stream().map(e -> e.getKey() + "=" + (e.getValue() == null ? this.nullText : e.getValue())).collect(Collectors.joining(","));
                _buffer.append('{').append(str).append('}');
            } else {
                _buffer.append(_value);
            }
        }
        finally {
            OBJ_REGISTRY.remove(_value);
        }
    }

    static String getShortClassName(Class<?> clazz, String _implSuffix) {
        int idx;
        String nm = clazz.getSimpleName();
        if (nm.endsWith(_implSuffix)) {
            nm = nm.substring(0, nm.length() - _implSuffix.length());
        }
        return (idx = nm.lastIndexOf(46)) >= 0 ? nm.substring(idx + 1) : nm;
    }

    static void removeLastFieldSeparator(StringBuilder _buffer, String _fieldSeparator) {
        int len = _buffer.length();
        int sepLen = _fieldSeparator.length();
        if (len > 0 && sepLen > 0 && len >= sepLen) {
            boolean match = true;
            for (int i = 0; i < sepLen; ++i) {
                if (_buffer.charAt(len - 1 - i) == _fieldSeparator.charAt(sepLen - 1 - i)) continue;
                return;
            }
            if (match) {
                _buffer.setLength(len - sepLen);
            }
        }
    }
}

