/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.SystemReduceFn;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.io.SourceRDD;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.translation.BoundedDataset;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.GroupCombineFunctions;
import org.apache.beam.runners.spark.translation.GroupNonMergingWindowsFunctions;
import org.apache.beam.runners.spark.translation.MultiDoFnFunction;
import org.apache.beam.runners.spark.translation.ReifyTimestampsAndWindowsFunction;
import org.apache.beam.runners.spark.translation.SparkAssignWindowFn;
import org.apache.beam.runners.spark.translation.SparkCombineFn;
import org.apache.beam.runners.spark.translation.SparkGroupAlsoByWindowViaOutputBufferFn;
import org.apache.beam.runners.spark.translation.SparkPipelineTranslator;
import org.apache.beam.runners.spark.translation.TransformEvaluator;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.PTransformMatchers;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.util.construction.SplittableParDo;
import org.apache.beam.sdk.util.construction.SplittableParDoNaiveBounded;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.storage.StorageLevel;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import scala.Tuple2;

public final class TransformTranslator {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> EVALUATORS = new HashMap();

    private TransformTranslator() {
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Flatten.PCollections<T>> flattenPColl() {
        return new TransformEvaluator<Flatten.PCollections<T>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Flatten.PCollections<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                JavaRDD unionRDD;
                Collection<PCollection<?>> pcs = context.getInputs((PTransform<?, ?>)transform).values();
                if (pcs.isEmpty()) {
                    unionRDD = context.getSparkContext().emptyRDD();
                } else {
                    JavaRDD[] rdds = new JavaRDD[pcs.size()];
                    int index = 0;
                    for (PCollection<?> pc : pcs) {
                        rdds[index] = ((BoundedDataset)context.borrowDataset((PValue)pc)).getRDD();
                        ++index;
                    }
                    unionRDD = context.getSparkContext().union(rdds);
                }
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(unionRDD));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "sparkContext.union(...)";
            }
        };
    }

    private static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized GroupByKey<K, V>> groupByKey() {
        return new TransformEvaluator<GroupByKey<K, V>>(){

            @Override
            public void evaluate(@UnknownKeyFor @NonNull @Initialized GroupByKey<K, V> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                JavaRDD groupedByKey;
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                KvCoder coder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                WindowFn windowFn = windowingStrategy.getWindowFn();
                Coder keyCoder = coder.getKeyCoder();
                WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)coder.getValueCoder(), (Coder)windowFn.windowCoder());
                Partitioner partitioner = TransformTranslator.getPartitioner(context);
                if (windowingStrategy.getWindowFn().equals(new GlobalWindows()) && windowingStrategy.getTimestampCombiner().equals((Object)TimestampCombiner.END_OF_WINDOW)) {
                    groupedByKey = GroupNonMergingWindowsFunctions.groupByKeyInGlobalWindow(inRDD, keyCoder, coder.getValueCoder(), partitioner);
                } else if (GroupNonMergingWindowsFunctions.isEligibleForGroupByWindow(windowingStrategy)) {
                    groupedByKey = GroupNonMergingWindowsFunctions.groupByKeyAndWindow(inRDD, keyCoder, coder.getValueCoder(), windowingStrategy, partitioner);
                } else {
                    JavaRDD groupedByKeyOnly = GroupCombineFunctions.groupByKeyOnly(inRDD, keyCoder, wvCoder, partitioner);
                    groupedByKey = groupedByKeyOnly.flatMap(new SparkGroupAlsoByWindowViaOutputBufferFn(windowingStrategy, new TranslationUtils.InMemoryStateInternalsFactory(), SystemReduceFn.buffering((Coder)coder.getValueCoder()), context.getSerializableOptions()));
                }
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(groupedByKey));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "groupByKey()";
            }
        };
    }

    private static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.GroupedValues<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, InputT, OutputT>> combineGrouped() {
        return new TransformEvaluator<Combine.GroupedValues<KV<K, InputT>, InputT, OutputT>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Combine.GroupedValues<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, InputT, OutputT> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                CombineWithContext.CombineFnWithContext combineFn = CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)transform.getFn());
                SparkCombineFn sparkCombineFn = SparkCombineFn.keyed(combineFn, context.getSerializableOptions(), TranslationUtils.getSideInputs(transform.getSideInputs(), context), ((PCollection)context.getInput(transform)).getWindowingStrategy());
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                JavaRDD outRDD = inRDD.map((Function & Serializable)in -> WindowedValue.of((Object)KV.of((Object)((KV)in.getValue()).getKey(), (Object)combineFn.apply((Iterable)((KV)in.getValue()).getValue(), (CombineWithContext.Context)sparkCombineFn.ctxtForValue((WindowedValue<?>)in))), (Instant)in.getTimestamp(), (Collection)in.getWindows(), (PaneInfo)in.getPane()));
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(outRDD));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "map(new <fn>())";
            }
        };
    }

    private static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.Globally<InputT, OutputT>> combineGlobally() {
        return new TransformEvaluator<Combine.Globally<InputT, OutputT>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Combine.Globally<InputT, OutputT> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                JavaRDD outRdd;
                Coder aCoder;
                PCollection input = (PCollection)context.getInput(transform);
                Coder iCoder = ((PCollection)context.getInput(transform)).getCoder();
                Coder oCoder = ((PCollection)context.getOutput(transform)).getCoder();
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                CombineWithContext.CombineFnWithContext combineFn = CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)transform.getFn());
                WindowedValue.FullWindowedValueCoder wvoCoder = WindowedValue.FullWindowedValueCoder.of((Coder)oCoder, (Coder)windowingStrategy.getWindowFn().windowCoder());
                boolean hasDefault = transform.isInsertDefault();
                SparkCombineFn sparkCombineFn = SparkCombineFn.globally(combineFn, context.getSerializableOptions(), TranslationUtils.getSideInputs(transform.getSideInputs(), context), windowingStrategy);
                try {
                    aCoder = combineFn.getAccumulatorCoder(context.getPipeline().getCoderRegistry(), iCoder);
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalStateException("Could not determine coder for accumulator", e);
                }
                JavaRDD inRdd = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                SparkCombineFn.WindowedAccumulator accumulated = GroupCombineFunctions.combineGlobally(inRdd, sparkCombineFn, aCoder, windowingStrategy);
                if (!accumulated.isEmpty()) {
                    Iterable output = sparkCombineFn.extractOutput(accumulated);
                    outRdd = context.getSparkContext().parallelize(CoderHelpers.toByteArrays(output, wvoCoder)).map(CoderHelpers.fromByteFunction(wvoCoder));
                } else {
                    JavaSparkContext jsc = new JavaSparkContext(inRdd.context());
                    if (hasDefault) {
                        Object defaultValue = combineFn.defaultValue();
                        outRdd = jsc.parallelize((List)Lists.newArrayList((Object[])new byte[][]{CoderHelpers.toByteArray(defaultValue, oCoder)})).map(CoderHelpers.fromByteFunction(oCoder)).map(WindowedValue::valueInGlobalWindow);
                    } else {
                        outRdd = jsc.emptyRDD();
                    }
                }
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(outRdd));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "aggregate(..., new <fn>(), ...)";
            }
        };
    }

    private static <K, InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, InputT, OutputT>> combinePerKey() {
        return new TransformEvaluator<Combine.PerKey<K, InputT, OutputT>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, InputT, OutputT> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                Coder vaCoder;
                PCollection input = (PCollection)context.getInput(transform);
                KvCoder inputCoder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                CombineWithContext.CombineFnWithContext combineFn = CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)transform.getFn());
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs = TranslationUtils.getSideInputs(transform.getSideInputs(), context);
                SparkCombineFn sparkCombineFn = SparkCombineFn.keyed(combineFn, context.getSerializableOptions(), sideInputs, windowingStrategy);
                try {
                    vaCoder = combineFn.getAccumulatorCoder(context.getPipeline().getCoderRegistry(), inputCoder.getValueCoder());
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalStateException("Could not determine coder for accumulator", e);
                }
                JavaRDD inRdd = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                JavaPairRDD accumulatePerKey = GroupCombineFunctions.combinePerKey(inRdd, sparkCombineFn, inputCoder.getKeyCoder(), inputCoder.getValueCoder(), vaCoder, windowingStrategy);
                FlatMapFunction & Serializable flatMapFunction = (FlatMapFunction & Serializable)windowedAccumulator -> sparkCombineFn.extractOutputStream(windowedAccumulator).iterator();
                JavaPairRDD kwvs = accumulatePerKey.flatMapValues((FlatMapFunction)flatMapFunction);
                JavaRDD outRdd = kwvs.map(new TranslationUtils.FromPairFunction()).map(new TranslationUtils.ToKVByWindowInValueFunction());
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(outRdd));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "combineByKey(..., new <fn>(), ...)";
            }
        };
    }

    private static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT>> parDo() {
        return new TransformEvaluator<ParDo.MultiOutput<InputT, OutputT>>(){
            private final @UnknownKeyFor @NonNull @Initialized PTransformMatcher splitDoFnMatcher = PTransformMatchers.parDoWithFnType(SplittableParDoNaiveBounded.NaiveProcessFn.class);

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                boolean useBoundedConcurrentOutput = ExperimentalOptions.hasExperiment((PipelineOptions)context.getOptions(), (String)"use_bounded_concurrent_output_for_sdf") && this.splitDoFnMatcher.matches(context.getCurrentTransform());
                String stepName = context.getCurrentTransform().getFullName();
                DoFn doFn = transform.getFn();
                DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)doFn);
                Preconditions.checkState((!signature.processElement().isSplittable() ? 1 : 0) != 0, (String)"Not expected to directly translate splittable DoFn, should have been overridden: %s", (Object)doFn);
                Preconditions.checkState((signature.onWindowExpiration() == null ? 1 : 0) != 0, (String)"onWindowExpiration is not supported: %s", (Object)doFn);
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                MetricsContainerStepMapAccumulator metricsAccum = MetricsAccumulator.getInstance();
                Coder inputCoder = ((PCollection)context.getInput(transform)).getCoder();
                Map<TupleTag<?>, Coder<?>> outputCoders = context.getOutputCoders();
                boolean stateful = signature.stateDeclarations().size() > 0 || signature.timerDeclarations().size() > 0;
                DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
                Map sideInputMapping = ParDoTranslation.getSideInputMapping(context.getCurrentTransform());
                MultiDoFnFunction multiDoFnFunction = new MultiDoFnFunction(metricsAccum, stepName, doFn, context.getSerializableOptions(), transform.getMainOutputTag(), transform.getAdditionalOutputTags().getAll(), inputCoder, outputCoders, TranslationUtils.getSideInputs(transform.getSideInputs().values(), context), windowingStrategy, stateful, doFnSchemaInformation, sideInputMapping, useBoundedConcurrentOutput);
                JavaPairRDD all = stateful ? TransformTranslator.statefulParDoTransform((KvCoder)((PCollection)context.getInput(transform)).getCoder(), (Coder<? extends BoundedWindow>)windowingStrategy.getWindowFn().windowCoder(), inRDD, TransformTranslator.getPartitioner(context), multiDoFnFunction, signature.processElement().requiresTimeSortedInput()) : inRDD.mapPartitionsToPair(multiDoFnFunction);
                Map<TupleTag<?>, PCollection<?>> outputs = context.getOutputs((PTransform<?, ?>)transform);
                if (this.hasMultipleOutputs(outputs)) {
                    StorageLevel level = StorageLevel.fromString((String)context.storageLevel());
                    if (TranslationUtils.canAvoidRddSerialization(level)) {
                        all = all.persist(level);
                    } else {
                        Map<TupleTag<?>, Coder<WindowedValue<?>>> coderMap = TranslationUtils.getTupleTagCoders(outputs);
                        all = all.mapToPair(TranslationUtils.getTupleTagEncodeFunction(coderMap)).persist(level).mapToPair(TranslationUtils.getTupleTagDecodeFunction(coderMap));
                    }
                    for (Map.Entry<TupleTag<?>, PCollection<?>> output : outputs.entrySet()) {
                        JavaPairRDD filtered = all.filter(new TranslationUtils.TupleTagFilter(output.getKey()));
                        JavaRDD values = filtered.values();
                        context.putDataset((PValue)output.getValue(), new BoundedDataset(values));
                    }
                } else {
                    JavaRDD values = all.values();
                    context.putDataset((PValue)((Map.Entry)Iterables.getOnlyElement(outputs.entrySet())).getValue(), new BoundedDataset(values));
                }
            }

            private @UnknownKeyFor @NonNull @Initialized boolean hasMultipleOutputs(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs) {
                return outputs.size() > 1;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "mapPartitions(new <fn>())";
            }
        };
    }

    private static <K, V, OutputT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized JavaPairRDD<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> statefulParDoTransform(@UnknownKeyFor @NonNull @Initialized KvCoder<K, V> kvCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> kvInRDD, @UnknownKeyFor @NonNull @Initialized Partitioner partitioner, @UnknownKeyFor @NonNull @Initialized MultiDoFnFunction<@UnknownKeyFor @NonNull @Initialized KV<K, V>, OutputT> doFnFunction, @UnknownKeyFor @NonNull @Initialized boolean requiresSortedInput) {
        Coder keyCoder = kvCoder.getKeyCoder();
        WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)kvCoder.getValueCoder(), windowCoder);
        if (!requiresSortedInput) {
            return GroupCombineFunctions.groupByKeyOnly(kvInRDD, keyCoder, wvCoder, partitioner).map((Function & Serializable)input -> {
                Object key = input.getKey();
                Iterable value = (Iterable)input.getValue();
                return FluentIterable.from((Iterable)value).transform(windowedValue -> windowedValue.withValue((Object)KV.of((Object)key, (Object)windowedValue.getValue()))).iterator();
            }).flatMapToPair(doFnFunction);
        }
        JavaPairRDD pairRDD = kvInRDD.map(new ReifyTimestampsAndWindowsFunction()).mapToPair(TranslationUtils.toPairFunction()).mapToPair(CoderHelpers.toByteFunctionWithTs(keyCoder, wvCoder, (Function & Serializable)in -> ((WindowedValue)in._2()).getTimestamp()));
        JavaPairRDD sorted = pairRDD.repartitionAndSortWithinPartitions(TransformTranslator.keyPrefixPartitionerFrom(partitioner));
        return sorted.mapPartitionsToPair(TransformTranslator.wrapDoFnFromSortedRDD(doFnFunction, keyCoder, wvCoder));
    }

    private static @UnknownKeyFor @NonNull @Initialized Partitioner keyPrefixPartitionerFrom(final @UnknownKeyFor @NonNull @Initialized Partitioner partitioner) {
        return new Partitioner(){

            public @UnknownKeyFor @NonNull @Initialized int numPartitions() {
                return partitioner.numPartitions();
            }

            public @UnknownKeyFor @NonNull @Initialized int getPartition(@UnknownKeyFor @NonNull @Initialized Object o) {
                ByteArray b = (ByteArray)o;
                return partitioner.getPartition((Object)new ByteArray(Arrays.copyOfRange(b.getValue(), 0, b.getValue().length - 8)));
            }
        };
    }

    private static <K, V, OutputT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PairFlatMapFunction<@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> wrapDoFnFromSortedRDD(@UnknownKeyFor @NonNull @Initialized MultiDoFnFunction<@UnknownKeyFor @NonNull @Initialized KV<K, V>, OutputT> doFnFunction, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>> wvCoder) {
        return (PairFlatMapFunction & Serializable)in -> {
            Iterator mappedGroups = Iterators.transform(TransformTranslator.splitBySameKey(in, keyCoder, wvCoder), group -> {
                try {
                    return doFnFunction.call((Iterator)group);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
            return TransformTranslator.flatten(mappedGroups);
        };
    }

    @VisibleForTesting
    static <T> @UnknownKeyFor @NonNull @Initialized Iterator<T> flatten(final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Iterator<T>> toFlatten) {
        return new AbstractIterator<T>(){
            @Nullable @UnknownKeyFor @Initialized Iterator<T> current = null;

            protected T computeNext() {
                while (true) {
                    if (this.current == null) {
                        if (toFlatten.hasNext()) {
                            this.current = (Iterator)toFlatten.next();
                        } else {
                            return this.endOfData();
                        }
                    }
                    if (this.current.hasNext()) {
                        return this.current.next();
                    }
                    this.current = null;
                }
            }
        };
    }

    @VisibleForTesting
    static <K, V> @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>>> splitBySameKey(final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> in, final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>> wvCoder) {
        return new AbstractIterator<Iterator<WindowedValue<KV<K, V>>>>(){
            @Nullable @UnknownKeyFor @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> read = null;

            protected @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> computeNext() {
                this.readNext();
                if (this.read != null) {
                    byte[] value = ((ByteArray)this.read._1()).getValue();
                    byte[] keyPart = Arrays.copyOfRange(value, 0, value.length - 8);
                    Object key = CoderHelpers.fromByteArray(keyPart, keyCoder);
                    return this.createIteratorForKey(keyPart, key);
                }
                return (Iterator)this.endOfData();
            }

            private void readNext() {
                if (this.read == null && in.hasNext()) {
                    this.read = (Tuple2)in.next();
                }
            }

            private void consumed() {
                this.read = null;
            }

            private @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> createIteratorForKey(final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] keyPart, final K key) {
                return new AbstractIterator<WindowedValue<KV<K, V>>>(){

                    protected @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>> computeNext() {
                        byte[] value;
                        byte[] prefix;
                        this.readNext();
                        if (read != null && Arrays.equals(prefix = Arrays.copyOfRange(value = ((ByteArray)read._1()).getValue(), 0, value.length - 8), keyPart)) {
                            WindowedValue wv = (WindowedValue)CoderHelpers.fromByteArray((byte[])read._2(), wvCoder);
                            this.consumed();
                            return WindowedValue.of((Object)KV.of((Object)key, (Object)wv.getValue()), (Instant)wv.getTimestamp(), (Collection)wv.getWindows(), (PaneInfo)wv.getPane());
                        }
                        return (WindowedValue)this.endOfData();
                    }
                };
            }
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized Impulse> impulse() {
        return new TransformEvaluator<Impulse>(){

            @Override
            public void evaluate(@UnknownKeyFor @NonNull @Initialized Impulse transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                BoundedDataset<byte[]> output = new BoundedDataset<byte[]>((Iterable<byte[]>)Collections.singletonList(new byte[0]), context.getSparkContext(), (Coder<byte[]>)ByteArrayCoder.of());
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)output);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "sparkContext.<impulse>()";
            }
        };
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized SplittableParDo.PrimitiveBoundedRead<T>> readBounded() {
        return new TransformEvaluator<SplittableParDo.PrimitiveBoundedRead<T>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized SplittableParDo.PrimitiveBoundedRead<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                String stepName = context.getCurrentTransform().getFullName();
                JavaSparkContext jsc = context.getSparkContext();
                JavaRDD input = new SourceRDD.Bounded(jsc.sc(), transform.getSource(), context.getSerializableOptions(), stepName).toJavaRDD();
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(input));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "sparkContext.<readFrom(<source>)>()";
            }
        };
    }

    private static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Window.Assign<T>> window() {
        return new TransformEvaluator<Window.Assign<T>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Window.Assign<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                if (TranslationUtils.skipAssignWindows(transform, context)) {
                    context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(inRDD));
                } else {
                    context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(inRDD.map(new SparkAssignWindowFn(transform.getWindowFn()))));
                }
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "map(new <windowFn>())";
            }
        };
    }

    private static <ReadT, WriteT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView<ReadT, WriteT>> createPCollView() {
        return new TransformEvaluator<View.CreatePCollectionView<ReadT, WriteT>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized View.CreatePCollectionView<ReadT, WriteT> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                Iterable<WindowedValue<?>> iter = context.getWindowedValues((PCollection)context.getInput(transform));
                PCollectionView output = transform.getView();
                IterableCoder coderInternal = IterableCoder.of((Coder)WindowedValue.getFullCoder((Coder)output.getCoderInternal(), (Coder)output.getWindowingStrategyInternal().getWindowFn().windowCoder()));
                Iterable<WindowedValue<?>> iterCast = iter;
                context.putPView((PCollectionView<?>)output, iterCast, (Coder<Iterable<WindowedValue<?>>>)coderInternal);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "<createPCollectionView>";
            }
        };
    }

    private static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized Reshuffle<K, V>> reshuffle() {
        return new TransformEvaluator<Reshuffle<K, V>>(){

            @Override
            public void evaluate(@UnknownKeyFor @NonNull @Initialized Reshuffle<K, V> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                KvCoder coder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                WindowFn windowFn = windowingStrategy.getWindowFn();
                WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)coder, (Coder)windowFn.windowCoder());
                JavaRDD reshuffled = GroupCombineFunctions.reshuffle(inRDD, wvCoder);
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(reshuffled));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "repartition(...)";
            }
        };
    }

    private static @Nullable @UnknownKeyFor @Initialized Partitioner getPartitioner(@UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
        Long bundleSize = ((SparkPipelineOptions)context.getSerializableOptions().get().as(SparkPipelineOptions.class)).getBundleSize();
        return bundleSize > 0L ? null : new HashPartitioner(context.getSparkContext().defaultParallelism().intValue());
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized TransformEvaluator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getTranslator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        @Nullable String urn = PTransformTranslation.urnForTransformOrNull(transform);
        return urn == null ? null : EVALUATORS.get(urn);
    }

    static {
        EVALUATORS.put("beam:transform:impulse:v1", TransformTranslator.impulse());
        EVALUATORS.put("beam:transform:read:v1", TransformTranslator.readBounded());
        EVALUATORS.put("beam:transform:pardo:v1", TransformTranslator.parDo());
        EVALUATORS.put("beam:transform:group_by_key:v1", TransformTranslator.groupByKey());
        EVALUATORS.put("beam:transform:combine_grouped_values:v1", TransformTranslator.combineGrouped());
        EVALUATORS.put("beam:transform:combine_globally:v1", TransformTranslator.combineGlobally());
        EVALUATORS.put("beam:transform:combine_per_key:v1", TransformTranslator.combinePerKey());
        EVALUATORS.put("beam:transform:flatten:v1", TransformTranslator.flattenPColl());
        EVALUATORS.put("beam:transform:create_view:v1", TransformTranslator.createPCollView());
        EVALUATORS.put("beam:transform:window_into:v1", TransformTranslator.window());
        EVALUATORS.put("beam:transform:reshuffle:v1", TransformTranslator.reshuffle());
    }

    public static class Translator
    implements SparkPipelineTranslator {
        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean hasTranslation(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            return EVALUATORS.containsKey(PTransformTranslation.urnForTransformOrNull(transform));
        }

        @Override
        public <TransformT extends PTransform<?, ?>> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<TransformT> translateBounded(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            TransformEvaluator transformEvaluator = TransformTranslator.getTranslator(transform);
            Preconditions.checkState((transformEvaluator != null ? 1 : 0) != 0, (String)"No TransformEvaluator registered for BOUNDED transform %s", transform);
            return transformEvaluator;
        }

        @Override
        public <TransformT extends PTransform<?, ?>> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<TransformT> translateUnbounded(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            throw new IllegalStateException("TransformTranslator used in a batch pipeline only supports BOUNDED transforms.");
        }
    }
}

